/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.vm;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoveryVmIpFinder
extends TcpDiscoveryIpFinderAdapter {
    @LoggerResource
    private IgniteLogger log;
    @GridToStringInclude
    private Collection<InetSocketAddress> addrs;

    public TcpDiscoveryVmIpFinder() {
        String ips = IgniteSystemProperties.getString("IGNITE_TCP_DISCOVERY_ADDRESSES");
        if (!F.isEmpty(ips)) {
            LinkedHashSet<InetSocketAddress> addrsList = new LinkedHashSet<InetSocketAddress>();
            for (String s : ips.split(",")) {
                if (F.isEmpty(s) || F.isEmpty(s = s.trim())) continue;
                try {
                    addrsList.addAll(TcpDiscoveryVmIpFinder.address(s));
                }
                catch (IgniteSpiException e) {
                    throw new IgniteException(e);
                }
            }
            this.addrs = addrsList;
        } else {
            this.addrs = new LinkedHashSet<InetSocketAddress>();
        }
    }

    public TcpDiscoveryVmIpFinder(boolean shared) {
        String ips = IgniteSystemProperties.getString("IGNITE_TCP_DISCOVERY_ADDRESSES");
        if (!F.isEmpty(ips)) {
            LinkedHashSet<InetSocketAddress> addrsList = new LinkedHashSet<InetSocketAddress>();
            for (String s : ips.split(",")) {
                if (F.isEmpty(s) || F.isEmpty(s = s.trim())) continue;
                try {
                    addrsList.addAll(TcpDiscoveryVmIpFinder.address(s));
                }
                catch (IgniteSpiException e) {
                    throw new IgniteException(e);
                }
            }
            this.addrs = addrsList;
        } else {
            this.addrs = new LinkedHashSet<InetSocketAddress>();
        }
        this.setShared(shared);
    }

    @IgniteSpiConfiguration(optional=true)
    public synchronized TcpDiscoveryVmIpFinder setAddresses(Collection<String> addrs) throws IgniteSpiException {
        if (F.isEmpty(addrs)) {
            return this;
        }
        LinkedHashSet<InetSocketAddress> newAddrs = new LinkedHashSet<InetSocketAddress>();
        for (String ipStr : addrs) {
            newAddrs.addAll(TcpDiscoveryVmIpFinder.address(ipStr));
        }
        this.addrs = newAddrs;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<InetSocketAddress> address(String ipStr) throws IgniteSpiException {
        ipStr = ipStr.trim();
        String errMsg = "Failed to parse provided address: " + ipStr;
        int colonCnt = ipStr.length() - ipStr.replace(":", "").length();
        if (colonCnt > 1) {
            if (!ipStr.startsWith("[")) return Collections.singleton(new InetSocketAddress(ipStr, 0));
            if ((ipStr = ipStr.substring(1)).contains("]:")) {
                return TcpDiscoveryVmIpFinder.addresses(ipStr, "\\]\\:", errMsg);
            }
            if (!ipStr.endsWith("]")) throw new IgniteSpiException(errMsg);
            ipStr = ipStr.substring(0, ipStr.length() - 1);
            return Collections.singleton(new InetSocketAddress(ipStr, 0));
        } else if (ipStr.endsWith(":")) {
            ipStr = ipStr.substring(0, ipStr.length() - 1);
            return Collections.singleton(new InetSocketAddress(ipStr, 0));
        } else {
            if (ipStr.indexOf(58) < 0) return Collections.singleton(new InetSocketAddress(ipStr, 0));
            return TcpDiscoveryVmIpFinder.addresses(ipStr, "\\:", errMsg);
        }
    }

    private static Collection<InetSocketAddress> addresses(String ipStr, String regexDelim, String errMsg) throws IgniteSpiException {
        String[] tokens = ipStr.split(regexDelim);
        if (tokens.length == 2) {
            String addrStr = tokens[0];
            String portStr = tokens[1];
            if (portStr.contains("..")) {
                try {
                    int port1 = Integer.parseInt(portStr.substring(0, portStr.indexOf("..")));
                    int port2 = Integer.parseInt(portStr.substring(portStr.indexOf("..") + 2, portStr.length()));
                    if (port2 < port1 || port1 == port2 || port1 <= 0 || port2 <= 0) {
                        throw new IgniteSpiException(errMsg);
                    }
                    ArrayList<InetSocketAddress> res = new ArrayList<InetSocketAddress>(port2 - port1);
                    for (int i = port1; i <= port2; ++i) {
                        res.add(new InetSocketAddress(addrStr, i));
                    }
                    return res;
                }
                catch (IllegalArgumentException e) {
                    throw new IgniteSpiException(errMsg, e);
                }
            }
            try {
                int port = Integer.parseInt(portStr);
                return Collections.singleton(new InetSocketAddress(addrStr, port));
            }
            catch (IllegalArgumentException e) {
                throw new IgniteSpiException(errMsg, e);
            }
        }
        throw new IgniteSpiException(errMsg);
    }

    @Override
    public synchronized Collection<InetSocketAddress> getRegisteredAddresses() {
        return Collections.unmodifiableCollection(this.addrs);
    }

    @Override
    public synchronized void registerAddresses(Collection<InetSocketAddress> addrs) {
        assert (!F.isEmpty(addrs));
        this.addrs = new LinkedHashSet<InetSocketAddress>(this.addrs);
        this.addrs.addAll(addrs);
    }

    @Override
    public synchronized void unregisterAddresses(Collection<InetSocketAddress> addrs) {
        assert (!F.isEmpty(addrs));
        this.addrs = new LinkedHashSet<InetSocketAddress>(this.addrs);
        this.addrs.removeAll(addrs);
    }

    @Override
    public TcpDiscoveryVmIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryVmIpFinder.class, this, "super", (Object)super.toString());
    }
}

