<!--
   Licensed to the Apache Software Foundation (ASF) under one
   or more contributor license agreements.  See the NOTICE file
   distributed with this work for additional information
   regarding copyright ownership.  The ASF licenses this file
   to you under the Apache License, Version 2.0 (the
   "License"); you may not use this file except in compliance
   with the License.  You may obtain a copy of the License at
     http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing,
   software distributed under the License is distributed on an
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   KIND, either express or implied.  See the License for the
   specific language governing permissions and limitations
   under the License.
-->

## @kie-tools-scripts/sparse-checkout

Sparse checkout lets you partially clone the KIE Tools monorepo. Doing a sparse checkout will help you save time and disk space, while also reducing the amount of code you need to deal with when developing.

This script will look at `repo/graph.json` to decide what packages need to be downloaded, depending on what packages you specified during your sparse checkout.

Keep in mind that sparse checkouts make Git behave a little differently for some commands. Read more at https://git-scm.com/docs/git-sparse-checkout.

### Usage

- zsh

```
ORG="apache"
BRANCH="main"
PKGS="@kie-tools/boxed-expression-component"
bash <(curl -s https://raw.githubusercontent.com/$ORG/incubator-kie-tools/$BRANCH/scripts/sparse-checkout/run.sh) $ORG $BRANCH ${(z)PKGS}
pnpm -F boxed-expression-component... build:dev
```

---

- bash

```
ORG="apache"
BRANCH="main"
PKGS="@kie-tools/boxed-expression-component"
bash <(curl -s https://raw.githubusercontent.com/$ORG/incubator-kie-tools/$BRANCH/scripts/sparse-checkout/run.sh) $ORG $BRANCH $PKGS
pnpm -F boxed-expression-component... build:dev
```

- Docker

```
docker run -it -p 9900:9900 --rm docker.io/apache/incubator-kie-tools-ci-build:main bash -ic '\
cd; \
ORG="apache"; \
BRANCH="main"; \
PKGS="@kie-tools/boxed-expression-component"; \
bash <(curl -s https://raw.githubusercontent.com/$ORG/incubator-kie-tools/$BRANCH/scripts/sparse-checkout/run.sh) $ORG $BRANCH $PKGS; \
cd incubator-kie-tools; \
pnpm -F boxed-expression-component... build:dev'
```

## Known issues

- `repo/graph.dot` and `repo/graph.json` are not reliably re-generated by `pnpm bootstrap` because not all packages are present. Adding, removing, or renaming packages on partial clones won't work out of the box without a lot of manual intervention.

---

Apache KIE (incubating) is an effort undergoing incubation at The Apache Software
Foundation (ASF), sponsored by the name of Apache Incubator. Incubation is
required of all newly accepted projects until a further review indicates that
the infrastructure, communications, and decision making process have stabilized
in a manner consistent with other successful ASF projects. While incubation
status is not necessarily a reflection of the completeness or stability of the
code, it does indicate that the project has yet to be fully endorsed by the ASF.

Some of the incubating project’s releases may not be fully compliant with ASF
policy. For example, releases may have incomplete or un-reviewed licensing
conditions. What follows is a list of known issues the project is currently
aware of (note that this list, by definition, is likely to be incomplete):

- Hibernate, an LGPL project, is being used. Hibernate is in the process of
  relicensing to ASL v2
- Some files, particularly test files, and those not supporting comments, may
  be missing the ASF Licensing Header

If you are planning to incorporate this work into your product/project, please
be aware that you will need to conduct a thorough licensing review to determine
the overall implications of including this work. For the current status of this
project through the Apache Incubator visit:
https://incubator.apache.org/projects/kie.html
