/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.cli;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.livy.LivyConf$;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.thriftserver.LivyCLIService;
import org.apache.livy.thriftserver.auth.AuthFactory;
import org.apache.livy.thriftserver.cli.ThreadPoolExecutorWithOomHook;
import org.apache.livy.thriftserver.cli.ThriftCLIService;
import org.apache.livy.thriftserver.cli.ThriftHttpCLIService$;
import org.apache.livy.thriftserver.cli.ThriftHttpServlet;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u001b\t!B\u000b\u001b:jMRDE\u000f\u001e9D\u0019&\u001bVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u0007\rd\u0017N\u0003\u0002\u0006\r\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011q\u0001C\u0001\u0005Y&4\u0018P\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003!QC'/\u001b4u\u00072K5+\u001a:wS\u000e,\u0007\u0002C\n\u0001\u0005\u000b\u0007I\u0011\t\u000b\u0002\u0015\rd\u0017nU3sm&\u001cW-F\u0001\u0016!\t1r#D\u0001\u0005\u0013\tABA\u0001\bMSZL8\tT%TKJ4\u0018nY3\t\u0013i\u0001!\u0011!Q\u0001\nUY\u0012aC2mSN+'O^5dK\u0002J!a\u0005\t\t\u0011u\u0001!Q1A\u0005\u0002y\tqa\\8n\u0011>|7.F\u0001 !\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0003mC:<'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012\u0001BU;o]\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011\t\u0011)A\u0005?\u0005Aqn\\7I_>\\\u0007\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y5r\u0003CA\b\u0001\u0011\u0015\u0019\u0012\u00061\u0001\u0016\u0011\u0015i\u0012\u00061\u0001 \u0011%\u0001\u0004\u00011AA\u0002\u0013E\u0011'\u0001\u0004tKJ4XM]\u000b\u0002eA\u00111'O\u0007\u0002i)\u0011\u0001'\u000e\u0006\u0003m]\nQA[3uifT!\u0001\u000f\u0006\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011!\b\u000e\u0002\u0007'\u0016\u0014h/\u001a:\t\u0013q\u0002\u0001\u0019!a\u0001\n#i\u0014AC:feZ,'o\u0018\u0013fcR\u0011a\b\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0005+:LG\u000fC\u0004Fw\u0005\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0013\u0007\u0003\u0004H\u0001\u0001\u0006KAM\u0001\bg\u0016\u0014h/\u001a:!\u0011!I\u0005\u0001#b\u0001\n\u0003R\u0015a\u00045jm\u0016\fU\u000f\u001e5GC\u000e$xN]=\u0016\u0003-\u0003\"\u0001T(\u000e\u00035S!A\u0014\u0003\u0002\t\u0005,H\u000f[\u0005\u0003!6\u00131\"Q;uQ\u001a\u000b7\r^8ss\"A!\u000b\u0001E\u0001B\u0003&1*\u0001\tiSZ,\u0017)\u001e;i\r\u0006\u001cGo\u001c:zA!)A\u000b\u0001C\t+\u0006Q\u0011N\\5u'\u0016\u0014h/\u001a:\u0015\u0003yBQa\u0016\u0001\u0005BU\u000b1A];o\u0011\u0015I\u0006\u0001\"\u0003[\u0003-9W\r\u001e%uiB\u0004\u0016\r\u001e5\u0015\u0005m\u0013\u0007C\u0001/`\u001d\tyT,\u0003\u0002_\u0001\u00061\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tq\u0006\tC\u0003d1\u0002\u00071,\u0001\u0005iiR\u0004\b+\u0019;i\u0011\u0015)\u0007\u0001\"\u0005V\u0003)\u0019Ho\u001c9TKJ4XM]\u0004\u0006O\nA\t\u0001[\u0001\u0015)\"\u0014\u0018N\u001a;IiR\u00048\tT%TKJ4\u0018nY3\u0011\u0005=Ig!B\u0001\u0003\u0011\u0003Q7CA5l!\tyD.\u0003\u0002n\u0001\n1\u0011I\\=SK\u001aDQAK5\u0005\u0002=$\u0012\u0001\u001b\u0005\bc&\u0014\r\u0011\"\u0003s\u0003I\t\u0005\u000b\u0015'J\u0007\u0006#\u0016j\u0014(`)\"\u0013\u0016J\u0012+\u0016\u0003M\u0004\"\u0001\t;\n\u0005\u0001\f\u0003B\u0002<jA\u0003%1/A\nB!Bc\u0015jQ!U\u0013>su\f\u0016%S\u0013\u001a#\u0006\u0005")
public class ThriftHttpCLIService
extends ThriftCLIService {
    private final Runnable oomHook;
    private Server server;
    private AuthFactory hiveAuthFactory;
    private volatile boolean bitmap$0;

    private AuthFactory hiveAuthFactory$lzycompute() {
        ThriftHttpCLIService thriftHttpCLIService = this;
        synchronized (thriftHttpCLIService) {
            if (!this.bitmap$0) {
                this.hiveAuthFactory = new AuthFactory(this.livyConf());
                this.bitmap$0 = true;
            }
            return this.hiveAuthFactory;
        }
    }

    @Override
    public LivyCLIService cliService() {
        return super.cliService();
    }

    public Runnable oomHook() {
        return this.oomHook;
    }

    public Server server() {
        return this.server;
    }

    public void server_$eq(Server x$1) {
        this.server = x$1;
    }

    @Override
    public AuthFactory hiveAuthFactory() {
        return this.bitmap$0 ? this.hiveAuthFactory : this.hiveAuthFactory$lzycompute();
    }

    @Override
    public void initServer() {
        try {
            ServerConnector serverConnector;
            String schemeName;
            ThreadPoolExecutorWithOomHook executorService = new ThreadPoolExecutorWithOomHook(this.minWorkerThreads(), this.maxWorkerThreads(), this.workerKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new ThreadFactoryWithGarbageCleanup("LivyThriftserver-HttpHandler-Pool"), this.oomHook());
            ExecutorThreadPool threadPool = new ExecutorThreadPool((ExecutorService)executorService);
            this.server_$eq(new Server((ThreadPool)threadPool));
            HttpConfiguration conf = new HttpConfiguration();
            int requestHeaderSize = this.livyConf().getInt((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_REQUEST_HEADER_SIZE());
            int responseHeaderSize = this.livyConf().getInt((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_RESPONSE_HEADER_SIZE());
            conf.setRequestHeaderSize(requestHeaderSize);
            conf.setResponseHeaderSize(responseHeaderSize);
            HttpConnectionFactory http = new HttpConnectionFactory(conf);
            boolean useSsl = this.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_USE_SSL());
            String string = schemeName = useSsl ? "https" : "http";
            if (useSsl) {
                String keyStorePath = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.SSL_KEYSTORE()).trim();
                String keyStorePassword = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.SSL_KEYSTORE_PASSWORD());
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Not configured for SSL connection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LivyConf$.MODULE$.SSL_KEYSTORE().key()})));
                }
                SslContextFactory sslContextFactory = new SslContextFactory();
                String[] excludedProtocols = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_SSL_PROTOCOL_BLACKLIST()).split(",");
                this.info((Function0<Object>)new Serializable(this, excludedProtocols){
                    public static final long serialVersionUID = 0L;
                    private final String[] excludedProtocols$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP Server SSL: adding excluded protocols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.excludedProtocols$1}));
                    }
                    {
                        this.excludedProtocols$1 = excludedProtocols$1;
                    }
                });
                sslContextFactory.addExcludeProtocols(excludedProtocols);
                this.info((Function0<Object>)new Serializable(this, sslContextFactory){
                    public static final long serialVersionUID = 0L;
                    private final SslContextFactory sslContextFactory$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"HTTP Server SSL: SslContextFactory.getExcludeProtocols = ").append((Object)this.sslContextFactory$1.getExcludeProtocols()).toString();
                    }
                    {
                        this.sslContextFactory$1 = sslContextFactory$1;
                    }
                });
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                serverConnector = new ServerConnector(this.server(), sslContextFactory, new ConnectionFactory[]{http});
            } else {
                serverConnector = new ServerConnector(this.server(), new ConnectionFactory[]{http});
            }
            ServerConnector connector = serverConnector;
            connector.setPort(this.portNum());
            connector.setReuseAddress(true);
            int maxIdleTime = (int)this.livyConf().getTimeAsMs((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_MAX_IDLE_TIME());
            connector.setIdleTimeout((long)maxIdleTime);
            this.server().addConnector((Connector)connector);
            TCLIService.Processor processor = new TCLIService.Processor((TCLIService.Iface)this);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            UserGroupInformation serviceUGI = this.cliService().getServiceUGI();
            UserGroupInformation httpUGI = this.cliService().getHttpUGI();
            String authType = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_AUTHENTICATION());
            ThriftHttpServlet thriftHttpServlet = new ThriftHttpServlet((TProcessor)processor, (TProtocolFactory)protocolFactory, authType, serviceUGI, httpUGI, this.hiveAuthFactory(), this.livyConf());
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            if (this.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_XSRF_FILTER_ENABLED())) {
                this.debug((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "XSRF filter enabled";
                    }
                });
            } else {
                this.warn((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "XSRF filter disabled";
                    }
                });
            }
            String httpPath = this.getHttpPath(this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_PATH()));
            if (this.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_XSRF_FILTER_ENABLED())) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler((Handler)context);
                gzipHandler.addIncludedMethods(new String[]{"POST"});
                gzipHandler.addIncludedMimeTypes(new String[]{ThriftHttpCLIService$.MODULE$.org$apache$livy$thriftserver$cli$ThriftHttpCLIService$$APPLICATION_THRIFT()});
                this.server().setHandler((Handler)gzipHandler);
            } else {
                this.server().setHandler((Handler)context);
            }
            context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
            this.server().start();
            this.info((Function0<Object>)new Serializable(this, schemeName, httpPath){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThriftHttpCLIService $outer;
                private final String schemeName$1;
                private final String httpPath$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started ", " in ", " mode on port "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ThriftHttpCLIService.class.getSimpleName(), this.schemeName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " path=", " with ", "...", " worker threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.portNum()), this.httpPath$1, BoxesRunTime.boxToInteger((int)this.$outer.minWorkerThreads()), BoxesRunTime.boxToInteger((int)this.$outer.maxWorkerThreads())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.schemeName$1 = schemeName$1;
                    this.httpPath$1 = httpPath$1;
                }
            });
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to init HttpServer", exception);
        }
    }

    @Override
    public void run() {
        try {
            this.server().join();
        }
        catch (Throwable throwable) {
            this.error((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThriftHttpCLIService $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception caught by ", ". Exiting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getClass().getSimpleName()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, throwable);
            System.exit(-1);
        }
        catch (InterruptedException interruptedException) {
            this.info((Function0<Object>)new Serializable(this, interruptedException){
                public static final long serialVersionUID = 0L;
                private final InterruptedException t$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Caught ", ". Shutting down thrift server."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1.getClass().getSimpleName()}));
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    private String getHttpPath(String httpPath) {
        Option option;
        block4: {
            String string;
            block3: {
                String withStartingSlash;
                block2: {
                    Some some;
                    String string2;
                    option = Option$.MODULE$.apply((Object)httpPath);
                    boolean bl = None$.MODULE$.equals(option) ? true : option instanceof Some && "".equals(string2 = (String)(some = (Some)option).x());
                    if (!bl) break block2;
                    string = "/*";
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String path = (String)some.x();
                String string3 = withStartingSlash = path.startsWith("/") ? path : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
                string = httpPath.endsWith("/") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{withStartingSlash})) : (httpPath.endsWith("/*") ? withStartingSlash : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{withStartingSlash})));
            }
            return string;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void stopServer() {
        if (this.server() != null && this.server().isStarted()) {
            try {
                this.server().stop();
                this.server_$eq(null);
                this.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Thrift HTTP server has been stopped";
                    }
                });
            }
            catch (Exception exception) {
                this.error((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error stopping HTTP server: ";
                    }
                }, exception);
            }
        }
    }

    public ThriftHttpCLIService(LivyCLIService cliService, Runnable oomHook) {
        this.oomHook = oomHook;
        super(cliService, ThriftHttpCLIService.class.getSimpleName());
    }
}

