/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.FilteredObjectInputStream;
import org.apache.spark.launcher.LauncherProtocol;

abstract class LauncherConnection
implements Closeable,
Runnable {
    private static final Logger LOG = Logger.getLogger(LauncherConnection.class.getName());
    private final Socket socket;
    private final ObjectOutputStream out;
    private volatile boolean closed;

    LauncherConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.out = new ObjectOutputStream(socket.getOutputStream());
        this.closed = false;
    }

    protected abstract void handle(LauncherProtocol.Message var1) throws IOException;

    @Override
    public void run() {
        block8: {
            try {
                FilteredObjectInputStream in = new FilteredObjectInputStream(this.socket.getInputStream());
                while (!this.closed) {
                    LauncherProtocol.Message msg = (LauncherProtocol.Message)in.readObject();
                    this.handle(msg);
                }
            }
            catch (EOFException eof) {
                try {
                    this.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                if (this.closed) break block8;
                LOG.log(Level.WARNING, "Error in inbound message handling.", e);
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected synchronized void send(LauncherProtocol.Message msg) throws IOException {
        try {
            CommandBuilderUtils.checkState(!this.closed, "Disconnected.", new Object[0]);
            this.out.writeObject(msg);
            this.out.flush();
        }
        catch (IOException ioe) {
            if (!this.closed) {
                LOG.log(Level.WARNING, "Error when sending message.", ioe);
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            LauncherConnection launcherConnection = this;
            synchronized (launcherConnection) {
                if (!this.closed) {
                    this.closed = true;
                    this.socket.close();
                }
            }
        }
    }
}

