/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.query.udf.datastructure.SerializableList;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryQueryDataFileService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(TemporaryQueryDataFileService.class);
    private static final String TEMPORARY_FILE_DIR = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "udf" + File.separator + "tmp";
    private final AtomicLong uniqueDataId = new AtomicLong(0L);
    private final Map<Long, List<SerializableList.SerializationRecorder>> recorders = new ConcurrentHashMap<Long, List<SerializableList.SerializationRecorder>>();

    private TemporaryQueryDataFileService() {
    }

    public String register(SerializableList.SerializationRecorder recorder) throws IOException {
        long queryId = recorder.getQueryId();
        if (!this.recorders.containsKey(queryId)) {
            this.recorders.put(queryId, new ArrayList());
        }
        this.recorders.get(queryId).add(recorder);
        String dirName = this.getDirName(queryId);
        this.makeDirIfNecessary(dirName);
        return this.getFileName(dirName, this.uniqueDataId.getAndIncrement());
    }

    public void deregister(long queryId) {
        List<SerializableList.SerializationRecorder> recorderList = this.recorders.remove(queryId);
        if (recorderList == null) {
            return;
        }
        for (SerializableList.SerializationRecorder recorder : recorderList) {
            try {
                recorder.closeFile();
            }
            catch (IOException e) {
                logger.warn(String.format("Failed to close file in method deregister(%d), because %s", queryId, e));
            }
        }
        try {
            FileUtils.cleanDirectory((File)SystemFileFactory.INSTANCE.getFile(this.getDirName(queryId)));
        }
        catch (IOException e) {
            logger.warn(String.format("Failed to clean dir in method deregister(%d), because %s", queryId, e));
        }
    }

    private void makeDirIfNecessary(String dir) throws IOException {
        File file = SystemFileFactory.INSTANCE.getFile(dir);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
    }

    private String getDirName(long queryId) {
        return TEMPORARY_FILE_DIR + File.separator + queryId + File.separator;
    }

    private String getFileName(String dir, long index) {
        return dir + index;
    }

    @Override
    public void start() throws StartupException {
        try {
            this.makeDirIfNecessary(TEMPORARY_FILE_DIR);
        }
        catch (IOException e) {
            throw new StartupException(e);
        }
    }

    @Override
    public void stop() {
        for (Object queryId : this.recorders.keySet().toArray()) {
            this.deregister((Long)queryId);
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.TEMPORARY_QUERY_DATA_FILE_SERVICE;
    }

    public static TemporaryQueryDataFileService getInstance() {
        return TemporaryQueryDataFileServiceHelper.INSTANCE;
    }

    private static class TemporaryQueryDataFileServiceHelper {
        private static final TemporaryQueryDataFileService INSTANCE = new TemporaryQueryDataFileService();

        private TemporaryQueryDataFileServiceHelper() {
        }
    }
}

