/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.BaseSourceRewriter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.IPartitionRelatedNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaFetchMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ActiveRegionScanMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationMergeSortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.HorizontallyConcatNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.RawDataAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.InnerTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryCollectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.DeviceRegionScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.RegionScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.TimeseriesRegionScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.CrossSeriesAggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.tsfile.enums.TSDataType;

public class SourceRewriter
extends BaseSourceRewriter<DistributionPlanContext> {
    private final Analysis analysis;
    private static final OrderByParameter TIME_ASC = new OrderByParameter(Collections.singletonList(new SortItem("TIME", Ordering.ASC)));
    private static final OrderByParameter TIME_DESC = new OrderByParameter(Collections.singletonList(new SortItem("TIME", Ordering.DESC)));

    public SourceRewriter(Analysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public List<PlanNode> visitMergeSort(MergeSortNode node, DistributionPlanContext context) {
        MergeSortNode newRoot = this.cloneMergeSortNodeWithoutChild(node, context);
        for (int i = 0; i < node.getChildren().size(); ++i) {
            List<PlanNode> rewroteNodes = this.rewrite(node.getChildren().get(i), context);
            rewroteNodes.forEach(newRoot::addChild);
        }
        return Collections.singletonList(newRoot);
    }

    private MergeSortNode cloneMergeSortNodeWithoutChild(MergeSortNode node, DistributionPlanContext context) {
        return new MergeSortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getOutputColumnNames());
    }

    @Override
    public List<PlanNode> visitSingleDeviceView(SingleDeviceViewNode node, DistributionPlanContext context) {
        if (this.analysis.isDeviceViewSpecialProcess()) {
            List<PlanNode> rewroteChildren = this.rewrite(node.getChild(), context);
            if (rewroteChildren.size() != 1) {
                throw new IllegalStateException("SingleDeviceViewNode have only one child");
            }
            node.setChild(rewroteChildren.get(0));
            return Collections.singletonList(node);
        }
        String device = node.getDevice();
        ArrayList<TRegionReplicaSet> regionReplicaSets = !this.analysis.useLogicalView() ? new ArrayList<TRegionReplicaSet>(this.analysis.getPartitionInfo(device, context.getPartitionTimeFilter())) : new ArrayList<TRegionReplicaSet>(this.analysis.getPartitionInfo(this.analysis.getOutputDeviceToQueriedDevicesMap().get(device), context.getPartitionTimeFilter()));
        ArrayList<PlanNode> singleDeviceViewList = new ArrayList<PlanNode>();
        for (TRegionReplicaSet tRegionReplicaSet : regionReplicaSets) {
            singleDeviceViewList.add(this.buildSingleDeviceViewNodeInRegion(node, tRegionReplicaSet, context.queryContext));
        }
        return singleDeviceViewList;
    }

    private PlanNode buildSingleDeviceViewNodeInRegion(PlanNode root, TRegionReplicaSet regionReplicaSet, MPPQueryContext context) {
        List<PlanNode> children = root.getChildren().stream().map(child -> this.buildSingleDeviceViewNodeInRegion((PlanNode)child, regionReplicaSet, context)).collect(Collectors.toList());
        PlanNode newRoot = root.cloneWithChildren(children);
        newRoot.setPlanNodeId(context.getQueryId().genPlanNodeId());
        if (newRoot instanceof SourceNode) {
            ((SourceNode)newRoot).setRegionReplicaSet(regionReplicaSet);
        }
        return newRoot;
    }

    @Override
    public List<PlanNode> visitDeviceView(DeviceViewNode node, DistributionPlanContext context) {
        if (node.getDevices().size() != node.getChildren().size()) {
            throw new IllegalArgumentException("size of devices and its children in DeviceViewNode should be same");
        }
        HashSet<TRegionReplicaSet> relatedDataRegions = new HashSet<TRegionReplicaSet>();
        ArrayList<DeviceViewSplit> deviceViewSplits = new ArrayList<DeviceViewSplit>();
        boolean existDeviceCrossRegion = false;
        for (int i = 0; i < node.getDevices().size(); ++i) {
            ArrayList<TRegionReplicaSet> regionReplicaSets;
            String outputDevice = node.getDevices().get(i);
            PlanNode child = node.getChildren().get(i);
            ArrayList<TRegionReplicaSet> arrayList = regionReplicaSets = this.analysis.useLogicalView() ? new ArrayList<TRegionReplicaSet>(this.analysis.getPartitionInfo(this.analysis.getOutputDeviceToQueriedDevicesMap().get(outputDevice), context.getPartitionTimeFilter())) : new ArrayList<TRegionReplicaSet>(this.analysis.getPartitionInfo(outputDevice, context.getPartitionTimeFilter()));
            if (regionReplicaSets.size() > 1 && !existDeviceCrossRegion) {
                existDeviceCrossRegion = true;
                if (this.analysis.isDeviceViewSpecialProcess() && this.aggregationCannotUseMergeSort()) {
                    return this.processSpecialDeviceView(node, context);
                }
            }
            deviceViewSplits.add(new DeviceViewSplit(outputDevice, child, regionReplicaSets));
            relatedDataRegions.addAll(regionReplicaSets);
        }
        ArrayList<PlanNode> deviceViewNodeList = new ArrayList<PlanNode>();
        if (existDeviceCrossRegion) {
            this.constructDeviceViewNodeListWithCrossRegion(deviceViewNodeList, relatedDataRegions, deviceViewSplits, node, context);
        } else {
            this.constructDeviceViewNodeListWithoutCrossRegion(deviceViewNodeList, deviceViewSplits, node, context, this.analysis);
        }
        if (deviceViewNodeList.size() == 1 || this.analysis.isHasSortNode() || this.analysis.isUseTopKNode()) {
            return deviceViewNodeList;
        }
        if (existDeviceCrossRegion && this.analysis.isDeviceViewSpecialProcess()) {
            HashMap<Integer, List<Integer>> newMeasurementIdxMap = new HashMap<Integer, List<Integer>>();
            ArrayList<String> newPartialOutputColumns = new ArrayList<String>();
            Set<Expression> deviceViewOutputExpressions = this.analysis.getDeviceViewOutputExpressions();
            int i = 0;
            int newIdxSum = 0;
            for (Expression expression : deviceViewOutputExpressions) {
                if (i == 0) {
                    newPartialOutputColumns.add(expression.getOutputSymbol());
                    ++i;
                    ++newIdxSum;
                    continue;
                }
                FunctionExpression aggExpression = (FunctionExpression)expression;
                List<String> actualPartialAggregationNames = this.getActualPartialAggregationNames(aggExpression.getFunctionName());
                for (String actualAggName : actualPartialAggregationNames) {
                    FunctionExpression partialFunctionExpression = new FunctionExpression(actualAggName, aggExpression.getFunctionAttributes(), aggExpression.getExpressions());
                    if (actualPartialAggregationNames.size() > 1) {
                        TSDataType dataType = ExpressionTypeAnalyzer.analyzeExpression(this.analysis, (Expression)partialFunctionExpression);
                        context.queryContext.getTypeProvider().setType(partialFunctionExpression.getOutputSymbol(), dataType);
                    }
                    newPartialOutputColumns.add(partialFunctionExpression.getOutputSymbol());
                }
                newMeasurementIdxMap.put(i++, actualPartialAggregationNames.size() > 1 ? Arrays.asList(newIdxSum++, newIdxSum++) : Collections.singletonList(newIdxSum++));
            }
            for (String device : node.getDevices()) {
                List<Integer> oldMeasurementIdxList = node.getDeviceToMeasurementIndexesMap().get(device);
                ArrayList newMeasurementIdxList = new ArrayList();
                oldMeasurementIdxList.forEach(idx -> newMeasurementIdxList.addAll((Collection)newMeasurementIdxMap.get(idx)));
                node.getDeviceToMeasurementIndexesMap().put(device, newMeasurementIdxList);
            }
            for (PlanNode planNode : deviceViewNodeList) {
                DeviceViewNode deviceViewNode = (DeviceViewNode)planNode;
                deviceViewNode.setOutputColumnNames(newPartialOutputColumns);
                this.transferAggregatorsRecursively(planNode, context);
            }
            boolean hasGroupBy = this.analysis.getGroupByTimeParameter() != null || this.analysis.hasGroupByParameter();
            AggregationMergeSortNode mergeSortNode = new AggregationMergeSortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getOutputColumnNames(), deviceViewOutputExpressions, hasGroupBy);
            deviceViewNodeList.forEach(mergeSortNode::addChild);
            return Collections.singletonList(mergeSortNode);
        }
        MergeSortNode mergeSortNode = new MergeSortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getOutputColumnNames());
        deviceViewNodeList.forEach(mergeSortNode::addChild);
        return Collections.singletonList(mergeSortNode);
    }

    private boolean aggregationCannotUseMergeSort() {
        if (this.analysis.hasGroupByParameter()) {
            return true;
        }
        for (Expression expression : this.analysis.getDeviceViewOutputExpressions()) {
            String functionName;
            if (!(expression instanceof FunctionExpression) || !"count_if".equalsIgnoreCase(functionName = ((FunctionExpression)expression).getFunctionName()) && !"diff".equalsIgnoreCase(functionName)) continue;
            return true;
        }
        return false;
    }

    private void constructDeviceViewNodeListWithCrossRegion(List<PlanNode> deviceViewNodeList, Set<TRegionReplicaSet> relatedDataRegions, List<DeviceViewSplit> deviceViewSplits, DeviceViewNode node, DistributionPlanContext context) {
        for (TRegionReplicaSet regionReplicaSet : relatedDataRegions) {
            ArrayList<String> devices = new ArrayList<String>();
            ArrayList<PlanNode> children = new ArrayList<PlanNode>();
            for (DeviceViewSplit split : deviceViewSplits) {
                if (!split.needDistributeTo(regionReplicaSet)) continue;
                devices.add(split.device);
                children.add(split.buildPlanNodeInRegion(regionReplicaSet, context.queryContext));
            }
            DeviceViewNode regionDeviceViewNode = this.cloneDeviceViewNodeWithoutChild(node, context);
            for (int i = 0; i < devices.size(); ++i) {
                regionDeviceViewNode.addChildDeviceNode((String)devices.get(i), (PlanNode)children.get(i));
            }
            deviceViewNodeList.add(regionDeviceViewNode);
        }
    }

    private void constructDeviceViewNodeListWithoutCrossRegion(List<PlanNode> deviceViewNodeList, List<DeviceViewSplit> deviceViewSplits, DeviceViewNode node, DistributionPlanContext context, Analysis analysis) {
        HashMap<TRegionReplicaSet, DeviceViewNode> regionDeviceViewMap = new HashMap<TRegionReplicaSet, DeviceViewNode>();
        for (DeviceViewSplit split : deviceViewSplits) {
            if (split.dataPartitions.size() != 1) {
                throw new IllegalStateException("In non-cross data region device-view situation, each device should only have on data partition.");
            }
            TRegionReplicaSet region = split.dataPartitions.iterator().next();
            DeviceViewNode regionDeviceViewNode = regionDeviceViewMap.computeIfAbsent(region, k -> {
                DeviceViewNode deviceViewNode = this.cloneDeviceViewNodeWithoutChild(node, context);
                deviceViewNodeList.add(deviceViewNode);
                return deviceViewNode;
            });
            PlanNode childNode = split.buildPlanNodeInRegion(region, context.queryContext);
            if (analysis.isDeviceViewSpecialProcess()) {
                List<PlanNode> rewriteResult = this.rewrite(childNode, context);
                if (rewriteResult.size() != 1) {
                    throw new IllegalStateException("In non-cross data region aggregation device-view situation, each rewrite child node of DeviceView should only be one.");
                }
                childNode = rewriteResult.get(0);
            }
            regionDeviceViewNode.addChildDeviceNode(split.device, childNode);
        }
    }

    public List<String> getActualPartialAggregationNames(String aggregationType) {
        ArrayList<String> outputAggregationNames = new ArrayList<String>();
        switch (aggregationType) {
            case "avg": {
                outputAggregationNames.add("count");
                outputAggregationNames.add("sum");
                break;
            }
            case "first_value": {
                outputAggregationNames.add("first_value");
                outputAggregationNames.add("min_time");
                break;
            }
            case "last_value": {
                outputAggregationNames.add("last_value");
                outputAggregationNames.add("max_time");
                break;
            }
            case "time_duration": {
                outputAggregationNames.add("max_time");
                outputAggregationNames.add("min_time");
                break;
            }
            default: {
                outputAggregationNames.add(aggregationType);
            }
        }
        return outputAggregationNames;
    }

    private void transferAggregatorsRecursively(PlanNode planNode, DistributionPlanContext context) {
        List<AggregationDescriptor> descriptorList = this.getAggregationDescriptors(planNode);
        if (descriptorList != null) {
            for (AggregationDescriptor descriptor : descriptorList) {
                descriptor.setStep(planNode instanceof SlidingWindowAggregationNode ? AggregationStep.INTERMEDIATE : AggregationStep.PARTIAL);
                LogicalPlanBuilder.updateTypeProviderByPartialAggregation(descriptor, context.queryContext.getTypeProvider());
            }
        }
        planNode.getChildren().forEach(child -> this.transferAggregatorsRecursively((PlanNode)child, context));
    }

    private List<AggregationDescriptor> getAggregationDescriptors(PlanNode planNode) {
        List<AggregationDescriptor> descriptorList = null;
        if (planNode instanceof SeriesAggregationSourceNode) {
            descriptorList = ((SeriesAggregationSourceNode)planNode).getAggregationDescriptorList();
        } else if (planNode instanceof AggregationNode) {
            descriptorList = ((AggregationNode)planNode).getAggregationDescriptorList();
        } else if (planNode instanceof SlidingWindowAggregationNode) {
            descriptorList = ((SlidingWindowAggregationNode)planNode).getAggregationDescriptorList();
        } else if (planNode instanceof RawDataAggregationNode) {
            descriptorList = ((RawDataAggregationNode)planNode).getAggregationDescriptorList();
        }
        return descriptorList;
    }

    private List<PlanNode> processSpecialDeviceView(DeviceViewNode node, DistributionPlanContext context) {
        DeviceViewNode newRoot = this.cloneDeviceViewNodeWithoutChild(node, context);
        for (int i = 0; i < node.getDevices().size(); ++i) {
            List<PlanNode> rewroteNode = this.rewrite(node.getChildren().get(i), context);
            for (PlanNode planNode : rewroteNode) {
                newRoot.addChildDeviceNode(node.getDevices().get(i), planNode);
            }
        }
        return Collections.singletonList(newRoot);
    }

    private DeviceViewNode cloneDeviceViewNodeWithoutChild(DeviceViewNode node, DistributionPlanContext context) {
        return new DeviceViewNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getOutputColumnNames(), node.getDeviceToMeasurementIndexesMap());
    }

    @Override
    public List<PlanNode> visitTransform(TransformNode node, DistributionPlanContext context) {
        List<PlanNode> children = this.rewrite(node.getChild(), context);
        if (children.size() == 1) {
            node.setChild(children.get(0));
            return Collections.singletonList(node);
        }
        return children.stream().map(child -> {
            TransformNode transformNode = this.cloneTransformNodeWithOutChild(node, context);
            transformNode.addChild((PlanNode)child);
            return transformNode;
        }).collect(Collectors.toList());
    }

    private TransformNode cloneTransformNodeWithOutChild(TransformNode node, DistributionPlanContext context) {
        return new TransformNode(context.queryContext.getQueryId().genPlanNodeId(), node.getOutputExpressions(), node.isKeepNull(), node.getScanOrder());
    }

    @Override
    public List<PlanNode> visitSort(SortNode node, DistributionPlanContext context) {
        this.analysis.setHasSortNode(true);
        List<PlanNode> children = this.rewrite(node.getChild(), context);
        if (children.size() == 1) {
            node.setChild(children.get(0));
            return Collections.singletonList(node);
        }
        MergeSortNode mergeSortNode = new MergeSortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getOrderByParameter(), node.getOutputColumnNames());
        for (PlanNode child : children) {
            SortNode sortNode = this.cloneSortNodeWithOutChild(node, context);
            sortNode.setChild(child);
            mergeSortNode.addChild(sortNode);
        }
        return Collections.singletonList(mergeSortNode);
    }

    private SortNode cloneSortNodeWithOutChild(SortNode node, DistributionPlanContext context) {
        return new SortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getOrderByParameter());
    }

    @Override
    public List<PlanNode> visitSchemaQueryMerge(SchemaQueryMergeNode node, DistributionPlanContext context) {
        SchemaQueryMergeNode root = (SchemaQueryMergeNode)node.clone();
        SchemaQueryScanNode seed = (SchemaQueryScanNode)node.getChildren().get(0);
        List<PartialPath> pathPatternList = seed.getPathPatternList();
        HashSet regionsOfSystemDatabase = new HashSet();
        if (pathPatternList.size() == 1) {
            TreeSet<TRegionReplicaSet> schemaRegions = new TreeSet<TRegionReplicaSet>(Comparator.comparingInt(region -> region.getRegionId().getId()));
            this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().forEach((storageGroup, deviceGroup) -> {
                if (storageGroup.equals("root.__system")) {
                    deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> regionsOfSystemDatabase.add(schemaRegionReplicaSet));
                } else {
                    deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> schemaRegions.add((TRegionReplicaSet)schemaRegionReplicaSet));
                }
            });
            schemaRegions.forEach(region -> this.addSchemaSourceNode(root, seed.getPath(), (TRegionReplicaSet)region, context.queryContext.getQueryId().genPlanNodeId(), seed));
            regionsOfSystemDatabase.forEach(region -> this.addSchemaSourceNode(root, seed.getPath(), (TRegionReplicaSet)region, context.queryContext.getQueryId().genPlanNodeId(), seed));
        } else {
            PathPatternTree patternTree = new PathPatternTree();
            for (PartialPath pathPattern : pathPatternList) {
                patternTree.appendPathPattern(pathPattern);
            }
            HashMap<String, Set> storageGroupSchemaRegionMap = new HashMap<String, Set>();
            this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().forEach((storageGroup, deviceGroup) -> {
                if (storageGroup.equals("root.__system")) {
                    deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> regionsOfSystemDatabase.add(schemaRegionReplicaSet));
                } else {
                    deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> storageGroupSchemaRegionMap.computeIfAbsent((String)storageGroup, k -> new HashSet()).add(schemaRegionReplicaSet));
                }
            });
            storageGroupSchemaRegionMap.forEach((storageGroup, schemaRegionSet) -> {
                List<PartialPath> filteredPathPatternList = this.filterPathPattern(patternTree, (String)storageGroup);
                schemaRegionSet.forEach(region -> this.addSchemaSourceNode(root, filteredPathPatternList.size() == 1 ? (PartialPath)filteredPathPatternList.get(0) : seed.getPath(), (TRegionReplicaSet)region, context.queryContext.getQueryId().genPlanNodeId(), seed));
            });
            if (!regionsOfSystemDatabase.isEmpty()) {
                List<PartialPath> filteredPathPatternList = this.filterPathPattern(patternTree, "root.__system");
                regionsOfSystemDatabase.forEach(region -> this.addSchemaSourceNode(root, filteredPathPatternList.size() == 1 ? (PartialPath)filteredPathPatternList.get(0) : seed.getPath(), (TRegionReplicaSet)region, context.queryContext.getQueryId().genPlanNodeId(), seed));
            }
        }
        return Collections.singletonList(root);
    }

    private List<PartialPath> filterPathPattern(PathPatternTree patternTree, String database) {
        HashSet filteredPathPatternSet = new HashSet();
        try {
            PartialPath storageGroupPath = new PartialPath(database);
            filteredPathPatternSet.addAll(patternTree.getOverlappedPathPatterns(storageGroupPath));
            filteredPathPatternSet.addAll(patternTree.getOverlappedPathPatterns(storageGroupPath.concatNode("**")));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        return new ArrayList<PartialPath>(filteredPathPatternSet);
    }

    private void addSchemaSourceNode(SchemaQueryMergeNode root, PartialPath pathPattern, TRegionReplicaSet schemaRegion, PlanNodeId planNodeId, SchemaQueryScanNode seed) {
        SchemaQueryScanNode schemaQueryScanNode = (SchemaQueryScanNode)seed.clone();
        schemaQueryScanNode.setPlanNodeId(planNodeId);
        schemaQueryScanNode.setRegionReplicaSet(schemaRegion);
        schemaQueryScanNode.setPath(pathPattern);
        root.addChild(schemaQueryScanNode);
    }

    @Override
    public List<PlanNode> visitCountMerge(CountSchemaMergeNode node, DistributionPlanContext context) {
        CountSchemaMergeNode root = (CountSchemaMergeNode)node.clone();
        SchemaQueryScanNode seed = (SchemaQueryScanNode)node.getChildren().get(0);
        HashSet schemaRegions = new HashSet();
        this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().forEach((storageGroup, deviceGroup) -> deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> schemaRegions.add(schemaRegionReplicaSet)));
        schemaRegions.forEach(region -> {
            SchemaQueryScanNode schemaQueryScanNode = (SchemaQueryScanNode)seed.clone();
            schemaQueryScanNode.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            schemaQueryScanNode.setRegionReplicaSet((TRegionReplicaSet)region);
            root.addChild(schemaQueryScanNode);
        });
        return Collections.singletonList(root);
    }

    @Override
    public List<PlanNode> visitSeriesScan(SeriesScanNode node, DistributionPlanContext context) {
        FullOuterTimeJoinNode fullOuterTimeJoinNode = new FullOuterTimeJoinNode(context.queryContext.getQueryId().genPlanNodeId(), node.getScanOrder());
        return this.processRawSeriesScan(node, context, fullOuterTimeJoinNode);
    }

    @Override
    public List<PlanNode> visitAlignedSeriesScan(AlignedSeriesScanNode node, DistributionPlanContext context) {
        FullOuterTimeJoinNode fullOuterTimeJoinNode = new FullOuterTimeJoinNode(context.queryContext.getQueryId().genPlanNodeId(), node.getScanOrder());
        return this.processRawSeriesScan(node, context, fullOuterTimeJoinNode);
    }

    @Override
    public List<PlanNode> visitLastQueryScan(LastQueryScanNode node, DistributionPlanContext context) {
        LastQueryNode mergeNode = new LastQueryNode(context.queryContext.getQueryId().genPlanNodeId(), null, false);
        return this.processRawSeriesScan(node, context, mergeNode);
    }

    @Override
    public List<PlanNode> visitAlignedLastQueryScan(AlignedLastQueryScanNode node, DistributionPlanContext context) {
        LastQueryNode mergeNode = new LastQueryNode(context.queryContext.getQueryId().genPlanNodeId(), null, false);
        return this.processRawSeriesScan(node, context, mergeNode);
    }

    private List<PlanNode> processRegionScan(RegionScanNode node, DistributionPlanContext context) {
        List<PlanNode> planNodeList = this.splitRegionScanNodeByRegion(node, context);
        if (planNodeList.size() == 1) {
            return planNodeList;
        }
        boolean outputCountInScanNode = node.isOutputCount() && !context.isOneSeriesInMultiRegion();
        ActiveRegionScanMergeNode regionMergeNode = new ActiveRegionScanMergeNode(context.queryContext.getQueryId().genPlanNodeId(), node.isOutputCount(), !outputCountInScanNode, node.getSize());
        for (PlanNode planNode : planNodeList) {
            ((RegionScanNode)planNode).setOutputCount(outputCountInScanNode);
            regionMergeNode.addChild(planNode);
        }
        return Collections.singletonList(regionMergeNode);
    }

    @Override
    public List<PlanNode> visitDeviceRegionScan(DeviceRegionScanNode node, DistributionPlanContext context) {
        return this.processRegionScan(node, context);
    }

    @Override
    public List<PlanNode> visitTimeSeriesRegionScan(TimeseriesRegionScanNode node, DistributionPlanContext context) {
        return this.processRegionScan(node, context);
    }

    private List<PlanNode> processRawSeriesScan(SeriesSourceNode node, DistributionPlanContext context, MultiChildProcessNode parent) {
        List<PlanNode> sourceNodes = this.splitSeriesSourceNodeByPartition(node, context);
        if (sourceNodes.size() == 1) {
            return sourceNodes;
        }
        sourceNodes.forEach(parent::addChild);
        return Collections.singletonList(parent);
    }

    private List<PlanNode> splitRegionScanNodeByRegion(RegionScanNode node, DistributionPlanContext context) {
        HashMap<TRegionReplicaSet, RegionScanNode> regionScanNodeMap = new HashMap<TRegionReplicaSet, RegionScanNode>();
        Set<PartialPath> devicesList = node.getDevicePaths();
        boolean isAllDeviceOnlyInOneRegion = true;
        for (PartialPath device : devicesList) {
            List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfoByDevice(device, context.getPartitionTimeFilter());
            isAllDeviceOnlyInOneRegion = isAllDeviceOnlyInOneRegion && dataDistribution.size() == 1;
            for (TRegionReplicaSet dataRegion : dataDistribution) {
                regionScanNodeMap.computeIfAbsent(dataRegion, k -> {
                    RegionScanNode regionScanNode = (RegionScanNode)node.clone();
                    regionScanNode.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                    regionScanNode.setRegionReplicaSet(dataRegion);
                    regionScanNode.setOutputCount(node.isOutputCount());
                    regionScanNode.clearPath();
                    return regionScanNode;
                }).addDevicePath(device, node);
            }
        }
        context.setOneSeriesInMultiRegion(!isAllDeviceOnlyInOneRegion);
        return new ArrayList<PlanNode>(regionScanNodeMap.values());
    }

    private List<PlanNode> splitSeriesSourceNodeByPartition(SeriesSourceNode node, DistributionPlanContext context) {
        ArrayList<PlanNode> ret = new ArrayList<PlanNode>();
        List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfo(node.getPartitionPath(), context.getPartitionTimeFilter());
        if (dataDistribution.size() == 1) {
            node.setRegionReplicaSet(dataDistribution.get(0));
            ret.add(node);
            return ret;
        }
        for (TRegionReplicaSet dataRegion : dataDistribution) {
            SeriesSourceNode split = (SeriesSourceNode)node.clone();
            split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            split.setRegionReplicaSet(dataRegion);
            context.getQueryContext().reserveMemoryForFrontEnd(MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(split));
            ret.add(split);
        }
        return ret;
    }

    @Override
    public List<PlanNode> visitSeriesAggregationScan(SeriesAggregationScanNode node, DistributionPlanContext context) {
        return this.processSeriesAggregationSource(node, context);
    }

    @Override
    public List<PlanNode> visitAlignedSeriesAggregationScan(AlignedSeriesAggregationScanNode node, DistributionPlanContext context) {
        return this.processSeriesAggregationSource(node, context);
    }

    private List<PlanNode> processSeriesAggregationSource(SeriesAggregationSourceNode node, DistributionPlanContext context) {
        List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfo(node.getPartitionPath(), context.getPartitionTimeFilter());
        if (dataDistribution.size() == 1) {
            node.setRegionReplicaSet(dataDistribution.get(0));
            return Collections.singletonList(node);
        }
        ArrayList<AggregationDescriptor> leafAggDescriptorList = new ArrayList<AggregationDescriptor>();
        node.getAggregationDescriptorList().forEach(descriptor -> leafAggDescriptorList.add(new AggregationDescriptor(descriptor.getAggregationFuncName(), AggregationStep.PARTIAL, descriptor.getInputExpressions(), descriptor.getInputAttributes())));
        leafAggDescriptorList.forEach(d -> LogicalPlanBuilder.updateTypeProviderByPartialAggregation(d, context.queryContext.getTypeProvider()));
        ArrayList<AggregationDescriptor> rootAggDescriptorList = new ArrayList<AggregationDescriptor>();
        node.getAggregationDescriptorList().forEach(descriptor -> rootAggDescriptorList.add(new AggregationDescriptor(descriptor.getAggregationFuncName(), context.isRoot ? AggregationStep.FINAL : AggregationStep.INTERMEDIATE, descriptor.getInputExpressions(), descriptor.getInputAttributes())));
        AggregationNode aggregationNode = new AggregationNode(context.queryContext.getQueryId().genPlanNodeId(), rootAggDescriptorList, node.getGroupByTimeParameter(), node.getScanOrder());
        for (TRegionReplicaSet dataRegion : dataDistribution) {
            SeriesAggregationSourceNode split = (SeriesAggregationSourceNode)node.clone();
            split.setAggregationDescriptorList(leafAggDescriptorList);
            split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            split.setRegionReplicaSet(dataRegion);
            context.getQueryContext().reserveMemoryForFrontEnd(MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(split));
            aggregationNode.addChild(split);
        }
        return Collections.singletonList(aggregationNode);
    }

    @Override
    public List<PlanNode> visitSchemaFetchMerge(SchemaFetchMergeNode node, DistributionPlanContext context) {
        SchemaFetchMergeNode root = (SchemaFetchMergeNode)node.clone();
        HashMap storageGroupSchemaRegionMap = new HashMap();
        this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().forEach((storageGroup, deviceGroup) -> {
            storageGroupSchemaRegionMap.put(storageGroup, new HashSet());
            deviceGroup.forEach((deviceGroupId, schemaRegionReplicaSet) -> ((Set)storageGroupSchemaRegionMap.get(storageGroup)).add(schemaRegionReplicaSet));
        });
        for (PlanNode child : node.getChildren()) {
            for (TRegionReplicaSet schemaRegion : (Set)storageGroupSchemaRegionMap.get(((SchemaFetchScanNode)child).getStorageGroup().getFullPath())) {
                SchemaFetchScanNode schemaFetchScanNode = (SchemaFetchScanNode)child.clone();
                schemaFetchScanNode.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                schemaFetchScanNode.setRegionReplicaSet(schemaRegion);
                root.addChild(schemaFetchScanNode);
            }
        }
        return Collections.singletonList(root);
    }

    @Override
    public List<PlanNode> visitLastQuery(LastQueryNode node, DistributionPlanContext context) {
        context.setForceAddParent();
        PlanNode root = this.processRawMultiChildNode(node, context, false);
        if (context.queryMultiRegion) {
            PlanNode newRoot = this.genLastQueryRootNode(node, context);
            if (newRoot instanceof LastQueryMergeNode && !node.needOrderByTimeseries()) {
                this.addSortForEachLastQueryNode(root, Ordering.ASC);
            }
            root.getChildren().forEach(newRoot::addChild);
            return Collections.singletonList(newRoot);
        }
        return Collections.singletonList(root);
    }

    private void addSortForEachLastQueryNode(PlanNode root, Ordering timeseriesOrdering) {
        if (root instanceof LastQueryNode && (root.getChildren().get(0) instanceof LastQueryScanNode || root.getChildren().get(0) instanceof AlignedLastQueryScanNode)) {
            LastQueryNode lastQueryNode = (LastQueryNode)root;
            lastQueryNode.setTimeseriesOrdering(timeseriesOrdering);
            lastQueryNode.setChildren(lastQueryNode.getChildren().stream().sorted(Comparator.comparing(child -> {
                String sortKey = "";
                if (child instanceof LastQueryScanNode) {
                    sortKey = ((LastQueryScanNode)child).getOutputSymbolForSort();
                } else if (child instanceof AlignedLastQueryScanNode) {
                    sortKey = ((AlignedLastQueryScanNode)child).getOutputSymbolForSort();
                }
                return sortKey;
            })).collect(Collectors.toList()));
            lastQueryNode.getChildren().forEach(child -> {
                if (child instanceof AlignedLastQueryScanNode) {
                    ((AlignedLastQueryScanNode)child).getSeriesPath().sortMeasurement(Comparator.naturalOrder());
                }
            });
        } else {
            for (PlanNode child2 : root.getChildren()) {
                this.addSortForEachLastQueryNode(child2, timeseriesOrdering);
            }
        }
    }

    private PlanNode genLastQueryRootNode(LastQueryNode node, DistributionPlanContext context) {
        PlanNodeId id = context.queryContext.getQueryId().genPlanNodeId();
        if (context.oneSeriesInMultiRegion || node.needOrderByTimeseries()) {
            return new LastQueryMergeNode(id, node.getTimeseriesOrdering(), node.isContainsLastTransformNode());
        }
        return new LastQueryCollectNode(id, node.isContainsLastTransformNode());
    }

    @Override
    public List<PlanNode> visitInnerTimeJoin(InnerTimeJoinNode node, DistributionPlanContext context) {
        ArrayList<SeriesSourceNode> seriesScanNodes = new ArrayList<SeriesSourceNode>(node.getChildren().size());
        ArrayList<List<List<TTimePartitionSlot>>> sourceTimeRangeList = new ArrayList<List<List<TTimePartitionSlot>>>();
        for (PlanNode child2 : node.getChildren()) {
            if (!(child2 instanceof SeriesSourceNode)) {
                throw new IllegalStateException("All child nodes of InnerTimeJoinNode should be SeriesSourceNode");
            }
            SeriesSourceNode sourceNode = (SeriesSourceNode)child2;
            seriesScanNodes.add(sourceNode);
            sourceTimeRangeList.add(this.analysis.getTimePartitionRange(sourceNode.getPartitionPath(), context.getPartitionTimeFilter()));
        }
        List<List<TTimePartitionSlot>> res = SourceRewriter.splitTimePartition(sourceTimeRangeList);
        List<PlanNode> children = this.splitInnerTimeJoinNode(res, node, context, seriesScanNodes);
        if (children.size() == 1) {
            return children;
        }
        List<String> outputColumnNames = node.getOutputColumnNames();
        MergeSortNode mergeSortNode = new MergeSortNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrder() == Ordering.ASC ? TIME_ASC : TIME_DESC, outputColumnNames);
        children.forEach(child -> ((InnerTimeJoinNode)child).setOutputColumnNames(outputColumnNames));
        mergeSortNode.setChildren(children);
        return Collections.singletonList(mergeSortNode);
    }

    protected static List<List<TTimePartitionSlot>> splitTimePartition(List<List<List<TTimePartitionSlot>>> childTimePartitionList) {
        if (childTimePartitionList.isEmpty()) {
            return Collections.emptyList();
        }
        List<List<TTimePartitionSlot>> res = new ArrayList<List<TTimePartitionSlot>>((Collection)childTimePartitionList.get(0));
        int size = childTimePartitionList.size();
        for (int i = 1; i < size && !res.isEmpty(); ++i) {
            res = SourceRewriter.combineTwoTimePartitionList(res, childTimePartitionList.get(i));
        }
        return res;
    }

    private static List<List<TTimePartitionSlot>> combineTwoTimePartitionList(List<List<TTimePartitionSlot>> left, List<List<TTimePartitionSlot>> right) {
        int leftIndex = 0;
        int leftSize = left.size();
        int rightIndex = 0;
        int rightSize = right.size();
        ArrayList<List<TTimePartitionSlot>> res = new ArrayList<List<TTimePartitionSlot>>(Math.max(leftSize, rightSize));
        int previousResIndex = 0;
        res.add(new ArrayList());
        int leftCurrentListIndex = 0;
        int rightCurrentListIndex = 0;
        while (leftIndex < leftSize && rightIndex < rightSize) {
            List<TTimePartitionSlot> leftCurrentList = left.get(leftIndex);
            List<TTimePartitionSlot> rightCurrentList = right.get(rightIndex);
            int leftCurrentListSize = leftCurrentList.size();
            int rightCurrentListSize = rightCurrentList.size();
            while (leftCurrentListIndex < leftCurrentListSize && rightCurrentListIndex < rightCurrentListSize) {
                if (leftCurrentList.get((int)leftCurrentListIndex).startTime == rightCurrentList.get((int)rightCurrentListIndex).startTime) {
                    if (leftCurrentListIndex == 0 && leftIndex != 0 || rightCurrentListIndex == 0 && rightIndex != 0) {
                        ++previousResIndex;
                        res.add(new ArrayList());
                    }
                    ((List)res.get(previousResIndex)).add(leftCurrentList.get(leftCurrentListIndex));
                    ++leftCurrentListIndex;
                    ++rightCurrentListIndex;
                    continue;
                }
                if (leftCurrentList.get((int)leftCurrentListIndex).startTime < rightCurrentList.get((int)rightCurrentListIndex).startTime) {
                    ++leftCurrentListIndex;
                    continue;
                }
                ++rightCurrentListIndex;
            }
            if (leftCurrentListIndex == leftCurrentListSize) {
                ++leftIndex;
                leftCurrentListIndex = 0;
            }
            if (rightCurrentListIndex != rightCurrentListSize) continue;
            ++rightIndex;
            rightCurrentListIndex = 0;
        }
        return res;
    }

    private List<PlanNode> splitInnerTimeJoinNode(List<List<TTimePartitionSlot>> continuousTimeRange, InnerTimeJoinNode node, DistributionPlanContext context, List<SeriesSourceNode> seriesScanNodes) {
        ArrayList<PlanNode> subInnerJoinNode = new ArrayList<PlanNode>(continuousTimeRange.size());
        for (List<TTimePartitionSlot> oneRegion : continuousTimeRange) {
            if (oneRegion.isEmpty()) continue;
            InnerTimeJoinNode innerTimeJoinNode = (InnerTimeJoinNode)node.clone();
            innerTimeJoinNode.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            List<Long> timePartitionIds = this.convertToTimePartitionIds(oneRegion);
            innerTimeJoinNode.setTimePartitions(timePartitionIds);
            HashMap<Integer, PlanNode> map = new HashMap<Integer, PlanNode>();
            for (SeriesSourceNode seriesSourceNode : seriesScanNodes) {
                TRegionReplicaSet dataRegion = this.analysis.getPartitionInfo(seriesSourceNode.getPartitionPath(), oneRegion.get(0));
                InnerTimeJoinNode parent = (InnerTimeJoinNode)map.computeIfAbsent(dataRegion.regionId.id, k -> {
                    InnerTimeJoinNode value = (InnerTimeJoinNode)node.clone();
                    value.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                    value.setTimePartitions(timePartitionIds);
                    return value;
                });
                SeriesSourceNode split = (SeriesSourceNode)seriesSourceNode.clone();
                split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                split.setRegionReplicaSet(dataRegion);
                parent.addChild(split);
            }
            for (Map.Entry entry : map.entrySet()) {
                InnerTimeJoinNode joinNode = (InnerTimeJoinNode)entry.getValue();
                if (joinNode.getChildren().size() != 1) continue;
                map.put((Integer)entry.getKey(), joinNode.getChildren().get(0));
            }
            if (map.size() > 1) {
                map.values().forEach(innerTimeJoinNode::addChild);
                subInnerJoinNode.add(innerTimeJoinNode);
                continue;
            }
            subInnerJoinNode.add((PlanNode)map.values().iterator().next());
        }
        if (subInnerJoinNode.isEmpty()) {
            for (SeriesSourceNode sourceNode : seriesScanNodes) {
                sourceNode.setRegionReplicaSet(DataPartition.NOT_ASSIGNED);
            }
            return Collections.singletonList(node);
        }
        return subInnerJoinNode;
    }

    private List<Long> convertToTimePartitionIds(List<TTimePartitionSlot> timePartitionSlotList) {
        ArrayList<Long> res = new ArrayList<Long>(timePartitionSlotList.size());
        for (TTimePartitionSlot timePartitionSlot : timePartitionSlotList) {
            res.add(TimePartitionUtils.getTimePartitionId((long)timePartitionSlot.startTime));
        }
        return res;
    }

    @Override
    public List<PlanNode> visitFullOuterTimeJoin(FullOuterTimeJoinNode node, DistributionPlanContext context) {
        if (this.containsAggregationSource(node)) {
            return this.planAggregationWithTimeJoin(node, context);
        }
        return Collections.singletonList(this.processRawMultiChildNode(node, context, true));
    }

    private PlanNode processRawMultiChildNode(MultiChildProcessNode node, DistributionPlanContext context, boolean isTimeJoin) {
        MultiChildProcessNode root = (MultiChildProcessNode)node.clone();
        Map<TRegionReplicaSet, List<SourceNode>> sourceGroup = this.groupBySourceNodes(node, context);
        boolean addParent = false;
        for (Map.Entry<TRegionReplicaSet, List<SourceNode>> entry : sourceGroup.entrySet()) {
            boolean appendToRootDirectly;
            TRegionReplicaSet region = entry.getKey();
            List<SourceNode> seriesScanNodes = entry.getValue();
            if (seriesScanNodes.size() == 1 && (!context.isForceAddParent() || isTimeJoin)) {
                root.addChild(seriesScanNodes.get(0));
                continue;
            }
            boolean bl = appendToRootDirectly = sourceGroup.size() == 1 || !addParent && !context.isForceAddParent();
            if (appendToRootDirectly) {
                context.queryContext.setMainFragmentLocatedRegion(region);
                seriesScanNodes.forEach(root::addChild);
                addParent = true;
                continue;
            }
            MultiChildProcessNode parentOfGroup = (MultiChildProcessNode)root.clone();
            parentOfGroup.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            seriesScanNodes.forEach(parentOfGroup::addChild);
            root.addChild(parentOfGroup);
        }
        for (PlanNode child : node.getChildren()) {
            if (child instanceof SeriesSourceNode) continue;
            List<PlanNode> children = this.visit(child, context);
            children.forEach(root::addChild);
        }
        return root;
    }

    private Map<TRegionReplicaSet, List<SourceNode>> groupBySourceNodes(MultiChildProcessNode node, DistributionPlanContext context) {
        ArrayList<SeriesSourceNode> sources = new ArrayList<SeriesSourceNode>();
        for (PlanNode child : node.getChildren()) {
            if (!(child instanceof SeriesSourceNode)) continue;
            SeriesSourceNode sourceNode = (SeriesSourceNode)child;
            List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfo(sourceNode.getPartitionPath(), context.getPartitionTimeFilter());
            if (dataDistribution.size() > 1) {
                context.setOneSeriesInMultiRegion(true);
            }
            for (TRegionReplicaSet dataRegion : dataDistribution) {
                SeriesSourceNode split = (SeriesSourceNode)sourceNode.clone();
                split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                split.setRegionReplicaSet(dataRegion);
                sources.add(split);
            }
        }
        Map<TRegionReplicaSet, List<SourceNode>> sourceGroup = sources.stream().collect(Collectors.groupingBy(IPartitionRelatedNode::getRegionReplicaSet));
        if (sourceGroup.size() > 1) {
            context.setQueryMultiRegion(true);
        }
        return sourceGroup;
    }

    private boolean containsAggregationSource(FullOuterTimeJoinNode node) {
        for (PlanNode child : node.getChildren()) {
            if (!(child instanceof SeriesAggregationScanNode) && !(child instanceof AlignedSeriesAggregationScanNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PlanNode> visitSlidingWindowAggregation(SlidingWindowAggregationNode node, DistributionPlanContext context) {
        DistributionPlanContext childContext = context.copy().setRoot(false);
        List<PlanNode> children = this.visit(node.getChild(), childContext);
        PlanNode newRoot = node.clone();
        children.forEach(newRoot::addChild);
        return Collections.singletonList(newRoot);
    }

    private List<PlanNode> planAggregationWithTimeJoin(FullOuterTimeJoinNode root, DistributionPlanContext context) {
        MultiChildProcessNode newRoot;
        Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup;
        if (context.isRoot) {
            ArrayList<SeriesAggregationSourceNode> sources = new ArrayList<SeriesAggregationSourceNode>();
            HashMap<PartialPath, Integer> regionCountPerSeries = new HashMap<PartialPath, Integer>();
            boolean[] eachSeriesOneRegion = new boolean[]{true};
            sourceGroup = this.splitAggregationSourceByPartition(root, context, sources, eachSeriesOneRegion, regionCountPerSeries);
            if (eachSeriesOneRegion[0]) {
                newRoot = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
            } else {
                ArrayList<AggregationDescriptor> rootAggDescriptorList = new ArrayList<AggregationDescriptor>();
                for (PlanNode child : root.getChildren()) {
                    SeriesAggregationSourceNode handle = (SeriesAggregationSourceNode)child;
                    handle.getAggregationDescriptorList().forEach(descriptor -> rootAggDescriptorList.add(new AggregationDescriptor(descriptor.getAggregationFuncName(), (Integer)regionCountPerSeries.get(handle.getPartitionPath()) == 1 ? AggregationStep.STATIC : AggregationStep.FINAL, descriptor.getInputExpressions(), descriptor.getInputAttributes())));
                }
                SeriesAggregationSourceNode seed = (SeriesAggregationSourceNode)root.getChildren().get(0);
                newRoot = new AggregationNode(context.queryContext.getQueryId().genPlanNodeId(), rootAggDescriptorList, seed.getGroupByTimeParameter(), seed.getScanOrder());
            }
        } else {
            sourceGroup = this.splitAggregationSourceByPartition(root, context);
            ArrayList<AggregationDescriptor> rootAggDescriptorList = new ArrayList<AggregationDescriptor>();
            for (PlanNode child : root.getChildren()) {
                SeriesAggregationSourceNode handle = (SeriesAggregationSourceNode)child;
                handle.getAggregationDescriptorList().forEach(descriptor -> rootAggDescriptorList.add(new AggregationDescriptor(descriptor.getAggregationFuncName(), AggregationStep.INTERMEDIATE, descriptor.getInputExpressions(), descriptor.getInputAttributes())));
            }
            SeriesAggregationSourceNode seed = (SeriesAggregationSourceNode)root.getChildren().get(0);
            newRoot = new AggregationNode(context.queryContext.getQueryId().genPlanNodeId(), rootAggDescriptorList, seed.getGroupByTimeParameter(), seed.getScanOrder());
        }
        boolean[] addParent = new boolean[]{false};
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            if (sourceNodes.size() == 1) {
                newRoot.addChild((PlanNode)sourceNodes.get(0));
            } else if (!addParent[0]) {
                sourceNodes.forEach(newRoot::addChild);
                addParent[0] = true;
            } else {
                HorizontallyConcatNode parentOfGroup = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(parentOfGroup::addChild);
                newRoot.addChild(parentOfGroup);
            }
        });
        return Collections.singletonList(newRoot);
    }

    @Override
    public List<PlanNode> visitGroupByLevel(GroupByLevelNode root, DistributionPlanContext context) {
        if (this.shouldUseNaiveAggregation(root)) {
            return this.defaultRewrite(root, context);
        }
        Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup = this.splitAggregationSourceByPartition(root, context);
        boolean containsSlidingWindow = root.getChildren().size() == 1 && root.getChildren().get(0) instanceof SlidingWindowAggregationNode;
        GroupByLevelNode newRoot = containsSlidingWindow ? this.groupSourcesForGroupByLevelWithSlidingWindow(root, (SlidingWindowAggregationNode)root.getChildren().get(0), sourceGroup, context) : this.groupSourcesForGroupByLevel(root, sourceGroup, context);
        HashMap<String, List<Expression>> columnNameToExpression = new HashMap<String, List<Expression>>();
        for (CrossSeriesAggregationDescriptor originalDescriptor : newRoot.getGroupByLevelDescriptors()) {
            columnNameToExpression.putAll(originalDescriptor.getGroupedInputStringToExpressionsMap());
            columnNameToExpression.put(originalDescriptor.getParametersString(), originalDescriptor.getOutputExpressions());
        }
        context.setColumnNameToExpression(columnNameToExpression);
        this.calculateGroupByLevelNodeAttributes(newRoot, 0, context);
        return Collections.singletonList(newRoot);
    }

    @Override
    public List<PlanNode> visitGroupByTag(GroupByTagNode root, DistributionPlanContext context) {
        Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup = this.splitAggregationSourceByPartition(root, context);
        boolean containsSlidingWindow = root.getChildren().size() == 1 && root.getChildren().get(0) instanceof SlidingWindowAggregationNode;
        return Collections.singletonList(containsSlidingWindow ? this.groupSourcesForGroupByTagWithSlidingWindow(root, (SlidingWindowAggregationNode)root.getChildren().get(0), sourceGroup, context) : this.groupSourcesForGroupByTag(root, sourceGroup, context));
    }

    @Override
    public List<PlanNode> visitLimit(LimitNode node, DistributionPlanContext context) {
        ArrayList<PlanNode> result = new ArrayList<PlanNode>();
        for (PlanNode planNode : this.rewrite(node.getChild(), context)) {
            LimitNode newNode = new LimitNode(context.queryContext.getQueryId().genPlanNodeId(), planNode, node.getLimit());
            result.add(newNode);
        }
        return result;
    }

    private boolean shouldUseNaiveAggregation(PlanNode root) {
        if (root instanceof RawDataAggregationNode) {
            return true;
        }
        for (PlanNode child : root.getChildren()) {
            if (!this.shouldUseNaiveAggregation(child)) continue;
            return true;
        }
        return false;
    }

    private GroupByLevelNode groupSourcesForGroupByLevelWithSlidingWindow(GroupByLevelNode root, SlidingWindowAggregationNode slidingWindowNode, Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup, DistributionPlanContext context) {
        GroupByLevelNode newRoot = (GroupByLevelNode)root.clone();
        ArrayList groups = new ArrayList();
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            SlidingWindowAggregationNode parentOfGroup = (SlidingWindowAggregationNode)slidingWindowNode.clone();
            parentOfGroup.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            if (sourceNodes.size() == 1) {
                parentOfGroup.addChild((PlanNode)sourceNodes.get(0));
            } else {
                HorizontallyConcatNode verticallyConcatNode = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(verticallyConcatNode::addChild);
                parentOfGroup.addChild(verticallyConcatNode);
            }
            groups.add(parentOfGroup);
        });
        for (int i = 0; i < groups.size(); ++i) {
            if (i == 0) {
                newRoot.addChild((PlanNode)groups.get(i));
                continue;
            }
            GroupByLevelNode parent = (GroupByLevelNode)root.clone();
            parent.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            parent.addChild((PlanNode)groups.get(i));
            newRoot.addChild(parent);
        }
        return newRoot;
    }

    private GroupByLevelNode groupSourcesForGroupByLevel(GroupByLevelNode root, Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup, DistributionPlanContext context) {
        GroupByLevelNode newRoot = (GroupByLevelNode)root.clone();
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            if (sourceNodes.size() == 1) {
                newRoot.addChild((PlanNode)sourceNodes.get(0));
            } else if (sourceGroup.size() == 1) {
                sourceNodes.forEach(newRoot::addChild);
            } else {
                GroupByLevelNode parentOfGroup = (GroupByLevelNode)root.clone();
                parentOfGroup.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(parentOfGroup::addChild);
                newRoot.addChild(parentOfGroup);
            }
        });
        return newRoot;
    }

    private void calculateGroupByLevelNodeAttributes(PlanNode node, int level, DistributionPlanContext context) {
        ArrayList<AggregationDescriptor> descriptorList;
        ProcessNode handle;
        if (node == null) {
            return;
        }
        node.getChildren().forEach(child -> this.calculateGroupByLevelNodeAttributes((PlanNode)child, level + 1, context));
        HashSet childrenOutputColumns = new HashSet();
        node.getChildren().forEach(child -> childrenOutputColumns.addAll(child.getOutputColumnNames()));
        if (node instanceof SlidingWindowAggregationNode) {
            handle = (SlidingWindowAggregationNode)node;
            descriptorList = new ArrayList<AggregationDescriptor>();
            for (AggregationDescriptor originalDescriptor : ((SlidingWindowAggregationNode)handle).getAggregationDescriptorList()) {
                boolean keep = false;
                block1: for (String childColumn : childrenOutputColumns) {
                    for (String string : originalDescriptor.getInputExpressionsAsStringList()) {
                        if (!this.isAggColumnMatchExpression(childColumn, string)) continue;
                        keep = true;
                        continue block1;
                    }
                }
                if (!keep) continue;
                descriptorList.add(originalDescriptor);
                LogicalPlanBuilder.updateTypeProviderByPartialAggregation(originalDescriptor, context.queryContext.getTypeProvider());
            }
            ((SlidingWindowAggregationNode)handle).setAggregationDescriptorList(descriptorList);
        }
        if (node instanceof GroupByLevelNode) {
            handle = (GroupByLevelNode)node;
            descriptorList = new ArrayList();
            Map<String, List<Expression>> columnNameToExpression = context.getColumnNameToExpression();
            HashMap<String, List<Expression>> childrenExpressionMap = new HashMap<String, List<Expression>>();
            for (String childColumn : childrenOutputColumns) {
                String childInput = childColumn.substring(childColumn.indexOf("(") + 1, childColumn.lastIndexOf(")"));
                childrenExpressionMap.put(childInput, columnNameToExpression.get(childInput));
            }
            for (CrossSeriesAggregationDescriptor originalDescriptor : ((GroupByLevelNode)handle).getGroupByLevelDescriptors()) {
                HashSet<Expression> descriptorExpressions = new HashSet<Expression>();
                if (childrenExpressionMap.containsKey(originalDescriptor.getParametersString())) {
                    descriptorExpressions.addAll(originalDescriptor.getOutputExpressions());
                }
                if (this.analysis.useLogicalView()) {
                    for (List list : originalDescriptor.getGroupedInputExpressions()) {
                        String groupedInputExpressionsString = originalDescriptor.getInputString(list);
                        List inputExpressions = (List)childrenExpressionMap.get(groupedInputExpressionsString);
                        if (inputExpressions == null || inputExpressions.isEmpty()) continue;
                        descriptorExpressions.addAll(list);
                    }
                } else {
                    for (String string : originalDescriptor.getGroupedInputExpressionStrings()) {
                        List inputExpressions = (List)childrenExpressionMap.get(string);
                        if (inputExpressions == null || inputExpressions.isEmpty()) continue;
                        descriptorExpressions.addAll(inputExpressions);
                    }
                }
                if (descriptorExpressions.isEmpty()) continue;
                CrossSeriesAggregationDescriptor descriptor = originalDescriptor.deepClone();
                descriptor.setStep(level == 0 ? AggregationStep.FINAL : AggregationStep.INTERMEDIATE);
                descriptor.setInputExpressions(new ArrayList<Expression>(descriptorExpressions));
                descriptorList.add(descriptor);
                LogicalPlanBuilder.updateTypeProviderByPartialAggregation(descriptor, context.queryContext.getTypeProvider());
            }
            ((GroupByLevelNode)handle).setGroupByLevelDescriptors(descriptorList);
        }
    }

    private GroupByTagNode groupSourcesForGroupByTagWithSlidingWindow(GroupByTagNode root, SlidingWindowAggregationNode slidingWindowNode, Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup, DistributionPlanContext context) {
        GroupByTagNode newRoot = (GroupByTagNode)root.clone();
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            SlidingWindowAggregationNode parentOfGroup = (SlidingWindowAggregationNode)slidingWindowNode.clone();
            parentOfGroup.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            ArrayList<AggregationDescriptor> childDescriptors = new ArrayList<AggregationDescriptor>();
            sourceNodes.forEach(n -> n.getAggregationDescriptorList().forEach(v -> childDescriptors.add(new AggregationDescriptor(v.getAggregationFuncName(), AggregationStep.INTERMEDIATE, v.getInputExpressions(), v.getInputAttributes()))));
            parentOfGroup.setAggregationDescriptorList(childDescriptors);
            if (sourceNodes.size() == 1) {
                parentOfGroup.addChild((PlanNode)sourceNodes.get(0));
            } else {
                HorizontallyConcatNode verticallyConcatNode = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(verticallyConcatNode::addChild);
                parentOfGroup.addChild(verticallyConcatNode);
            }
            newRoot.addChild(parentOfGroup);
        });
        return newRoot;
    }

    private GroupByTagNode groupSourcesForGroupByTag(GroupByTagNode root, Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> sourceGroup, DistributionPlanContext context) {
        GroupByTagNode newRoot = (GroupByTagNode)root.clone();
        sourceGroup.forEach((dataRegion, sourceNodes) -> {
            if (sourceNodes.size() == 1) {
                newRoot.addChild((PlanNode)sourceNodes.get(0));
            } else if (sourceGroup.size() == 1) {
                sourceNodes.forEach(newRoot::addChild);
            } else {
                HorizontallyConcatNode horizontallyConcatNode = new HorizontallyConcatNode(context.queryContext.getQueryId().genPlanNodeId());
                sourceNodes.forEach(horizontallyConcatNode::addChild);
                newRoot.addChild(horizontallyConcatNode);
            }
        });
        return newRoot;
    }

    private boolean isAggColumnMatchExpression(String columnName, String expression) {
        if (columnName == null) {
            return false;
        }
        return columnName.contains(expression);
    }

    private Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> splitAggregationSourceByPartition(PlanNode root, DistributionPlanContext context) {
        List<SeriesAggregationSourceNode> rawSources = AggregationNode.findAggregationSourceNode(root);
        ArrayList<SeriesAggregationSourceNode> sources = new ArrayList<SeriesAggregationSourceNode>();
        for (SeriesAggregationSourceNode child : rawSources) {
            this.constructAggregationSourceNodeForPerRegion(context, sources, child);
        }
        for (SeriesAggregationSourceNode source : sources) {
            source.getAggregationDescriptorList().forEach(d -> {
                d.setStep(AggregationStep.PARTIAL);
                LogicalPlanBuilder.updateTypeProviderByPartialAggregation(d, context.queryContext.getTypeProvider());
            });
        }
        return sources.stream().collect(Collectors.groupingBy(IPartitionRelatedNode::getRegionReplicaSet));
    }

    private Map<TRegionReplicaSet, List<SeriesAggregationSourceNode>> splitAggregationSourceByPartition(PlanNode root, DistributionPlanContext context, List<SeriesAggregationSourceNode> sources, boolean[] eachSeriesOneRegion, Map<PartialPath, Integer> regionCountPerSeries) {
        List<SeriesAggregationSourceNode> rawSources = AggregationNode.findAggregationSourceNode(root);
        for (SeriesAggregationSourceNode child : rawSources) {
            regionCountPerSeries.put(child.getPartitionPath(), this.constructAggregationSourceNodeForPerRegion(context, sources, child));
        }
        for (SeriesAggregationSourceNode source : sources) {
            boolean isSingle = regionCountPerSeries.get(source.getPartitionPath()) == 1;
            source.getAggregationDescriptorList().forEach(descriptor -> {
                if (isSingle) {
                    descriptor.setStep(AggregationStep.SINGLE);
                } else {
                    eachSeriesOneRegion[0] = false;
                    descriptor.setStep(AggregationStep.PARTIAL);
                    LogicalPlanBuilder.updateTypeProviderByPartialAggregation(descriptor, context.queryContext.getTypeProvider());
                }
            });
        }
        return sources.stream().collect(Collectors.groupingBy(IPartitionRelatedNode::getRegionReplicaSet));
    }

    private int constructAggregationSourceNodeForPerRegion(DistributionPlanContext context, List<SeriesAggregationSourceNode> sources, SeriesAggregationSourceNode child) {
        List<TRegionReplicaSet> dataDistribution = this.analysis.getPartitionInfo(child.getPartitionPath(), context.getPartitionTimeFilter());
        for (TRegionReplicaSet dataRegion : dataDistribution) {
            SeriesAggregationSourceNode split = (SeriesAggregationSourceNode)child.clone();
            split.setPlanNodeId(context.queryContext.getQueryId().genPlanNodeId());
            split.setRegionReplicaSet(dataRegion);
            split.setAggregationDescriptorList(child.getAggregationDescriptorList().stream().map(AggregationDescriptor::deepClone).collect(Collectors.toList()));
            sources.add(split);
        }
        return dataDistribution.size();
    }

    public List<PlanNode> visit(PlanNode node, DistributionPlanContext context) {
        return node.accept(this, context);
    }

    private static class DeviceViewSplit {
        protected String device;
        protected PlanNode root;
        protected Set<TRegionReplicaSet> dataPartitions;

        protected DeviceViewSplit(String device, PlanNode root, List<TRegionReplicaSet> dataPartitions) {
            this.device = device;
            this.root = root;
            this.dataPartitions = new HashSet<TRegionReplicaSet>();
            this.dataPartitions.addAll(dataPartitions);
        }

        protected PlanNode buildPlanNodeInRegion(TRegionReplicaSet regionReplicaSet, MPPQueryContext context) {
            return this.buildPlanNodeInRegion(this.root, regionReplicaSet, context);
        }

        protected boolean needDistributeTo(TRegionReplicaSet regionReplicaSet) {
            return this.dataPartitions.contains(regionReplicaSet);
        }

        private PlanNode buildPlanNodeInRegion(PlanNode root, TRegionReplicaSet regionReplicaSet, MPPQueryContext context) {
            List<PlanNode> children = root.getChildren().stream().map(child -> this.buildPlanNodeInRegion((PlanNode)child, regionReplicaSet, context)).collect(Collectors.toList());
            PlanNode newRoot = root.cloneWithChildren(children);
            newRoot.setPlanNodeId(context.getQueryId().genPlanNodeId());
            if (newRoot instanceof SourceNode) {
                ((SourceNode)newRoot).setRegionReplicaSet(regionReplicaSet);
            }
            return newRoot;
        }
    }
}

