/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.row;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.datastructure.Cache;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.RowListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.row.SerializableRowList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;

public class ElasticSerializableRowList {
    protected static final int MEMORY_CHECK_THRESHOLD = 1000;
    protected TSDataType[] dataTypes;
    protected String queryId;
    protected float memoryLimitInMB;
    protected int internalRowListCapacity;
    protected int numCacheBlock;
    protected LRUCache cache;
    protected List<SerializableRowList> internalRowList;
    protected List<Integer> internalBlockCountList;
    protected int rowCount;
    protected int lastRowCount;
    protected int evictionUpperBound;
    protected boolean disableMemoryControl;
    protected int[] indexListOfTextFields;
    protected int byteArrayLengthForMemoryControl;
    protected long rowByteArrayLength;
    protected long totalByteArrayLengthLimit;
    protected long totalByteArrayLength;
    protected List<RowListForwardIterator> iteratorList;

    public ElasticSerializableRowList(TSDataType[] dataTypes, String queryId, float memoryLimitInMB, int numCacheBlock) throws QueryProcessException {
        this.dataTypes = dataTypes;
        this.queryId = queryId;
        this.memoryLimitInMB = memoryLimitInMB;
        int allocatableCapacity = SerializableRowList.calculateCapacity(dataTypes, memoryLimitInMB, SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL);
        this.internalRowListCapacity = allocatableCapacity / numCacheBlock;
        if (this.internalRowListCapacity == 0) {
            numCacheBlock = 1;
            this.internalRowListCapacity = allocatableCapacity;
        }
        this.numCacheBlock = numCacheBlock;
        this.cache = new LRUCache(numCacheBlock);
        this.internalRowList = new ArrayList<SerializableRowList>();
        this.internalBlockCountList = new ArrayList<Integer>();
        this.rowCount = 0;
        this.evictionUpperBound = 0;
        this.disableMemoryControl = true;
        int textFieldsCount = 0;
        for (TSDataType dataType : dataTypes) {
            if (!dataType.equals((Object)TSDataType.TEXT)) continue;
            ++textFieldsCount;
            this.disableMemoryControl = false;
        }
        this.indexListOfTextFields = new int[textFieldsCount];
        int fieldIndex = 0;
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypes[i].equals((Object)TSDataType.TEXT)) continue;
            this.indexListOfTextFields[fieldIndex++] = i;
        }
        this.byteArrayLengthForMemoryControl = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
        this.totalByteArrayLengthLimit = 0L;
        this.totalByteArrayLength = 0L;
        this.rowByteArrayLength = (long)this.byteArrayLengthForMemoryControl * (long)textFieldsCount;
        this.iteratorList = new ArrayList<RowListForwardIterator>();
    }

    protected ElasticSerializableRowList(TSDataType[] dataTypes, String queryId, float memoryLimitInMB, int internalRowListCapacity, int numCacheBlock) {
        this.dataTypes = dataTypes;
        this.queryId = queryId;
        this.memoryLimitInMB = memoryLimitInMB;
        this.internalRowListCapacity = internalRowListCapacity;
        this.numCacheBlock = numCacheBlock;
        this.cache = new LRUCache(numCacheBlock);
        this.internalRowList = new ArrayList<SerializableRowList>();
        this.internalBlockCountList = new ArrayList<Integer>();
        this.rowCount = 0;
        this.evictionUpperBound = 0;
        this.disableMemoryControl = true;
        this.iteratorList = new ArrayList<RowListForwardIterator>();
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public int size() {
        return this.rowCount;
    }

    public int getInternalRowListCapacity() {
        return this.internalRowListCapacity;
    }

    public int getSerializableRowListSize() {
        return this.internalRowList.size();
    }

    public SerializableRowList getSerializableRowList(int index) {
        return this.internalRowList.get(index);
    }

    public long getTime(int index) throws IOException {
        return this.cache.get(index / this.internalRowListCapacity).getTime(index % this.internalRowListCapacity);
    }

    public Object[] getRowRecord(int index) throws IOException {
        return this.cache.get(index / this.internalRowListCapacity).getRow(index % this.internalRowListCapacity);
    }

    public Column[] getColumns(int externalIndex, int internalIndex) throws IOException {
        return this.cache.get(externalIndex).getColumns(internalIndex);
    }

    public void put(Column[] columns) throws IOException, QueryProcessException {
        this.checkExpansion();
        int begin = 0;
        int end = 0;
        int total = columns[0].getPositionCount();
        while (total > 0) {
            int i;
            Column[] insertedColumns;
            int consumed;
            if (total + this.rowCount % this.internalRowListCapacity < this.internalRowListCapacity) {
                consumed = total;
                if (begin == 0) {
                    insertedColumns = columns;
                } else {
                    insertedColumns = new Column[columns.length];
                    for (i = 0; i < columns.length; ++i) {
                        insertedColumns[i] = columns[i].getRegionCopy(begin, consumed);
                    }
                }
            } else {
                consumed = this.internalRowListCapacity - this.rowCount % this.internalRowListCapacity;
                insertedColumns = new Column[columns.length];
                for (i = 0; i < columns.length; ++i) {
                    insertedColumns[i] = columns[i].getRegionCopy(begin, consumed);
                }
            }
            begin = end += consumed;
            this.cache.get(this.rowCount / this.internalRowListCapacity).putColumns(insertedColumns);
            this.rowCount += consumed;
            if ((total -= consumed) <= 0) continue;
            this.doExpansion();
        }
        if (!this.disableMemoryControl) {
            int count = columns[0].getPositionCount();
            this.totalByteArrayLengthLimit += this.rowByteArrayLength * (long)count;
            for (int i = 0; i < count; ++i) {
                for (int indexListOfTextField : this.indexListOfTextFields) {
                    Column bianryColumn = columns[indexListOfTextField];
                    if (bianryColumn.isNull(i)) continue;
                    this.totalByteArrayLength += (long)bianryColumn.getBinary(i).getLength();
                }
            }
            this.checkMemoryUsage();
        }
    }

    public void putNulls(int total) throws IOException {
        assert (this.rowCount % this.internalRowListCapacity == 0);
        this.checkExpansion();
        while (total > 0) {
            int consumed = Math.min(total, this.internalRowListCapacity);
            this.cache.get(this.rowCount / this.internalRowListCapacity).putNulls(consumed);
            this.rowCount += consumed;
            if ((total -= consumed) <= 0) continue;
            this.doExpansion();
        }
        if (!this.disableMemoryControl) {
            this.totalByteArrayLengthLimit += this.rowByteArrayLength * (long)total;
            this.totalByteArrayLength += this.rowByteArrayLength * (long)total;
        }
    }

    public RowListForwardIterator constructIterator() {
        RowListForwardIterator iterator = new RowListForwardIterator(this);
        this.iteratorList.add(iterator);
        return iterator;
    }

    private void copyLatterColumnsAfterEvictionUpperBound(ElasticSerializableRowList newESRowList) throws IOException, QueryProcessException {
        int externalColumnIndex = this.evictionUpperBound / this.internalRowListCapacity;
        int internalRowIndex = this.evictionUpperBound % this.internalRowListCapacity;
        int internalColumnIndex = this.internalRowList.get(externalColumnIndex).getColumnIndex(internalRowIndex);
        int rowOffsetInColumns = this.internalRowList.get(externalColumnIndex).getRowOffsetInColumns(internalRowIndex);
        RowListForwardIterator iterator = new RowListForwardIterator(this, externalColumnIndex, internalColumnIndex);
        Column[] columns = iterator.currentBlock();
        if (rowOffsetInColumns != 0) {
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = columns[i].subColumnCopy(rowOffsetInColumns);
            }
        }
        newESRowList.put(columns);
        while (iterator.hasNext()) {
            iterator.next();
            this.copyColumnByIterator(newESRowList, iterator);
        }
    }

    private void copyColumnByIterator(ElasticSerializableRowList target, RowListForwardIterator source) throws IOException, QueryProcessException {
        Column[] columns = source.currentBlock();
        target.put(columns);
    }

    private void checkExpansion() {
        if (this.rowCount % this.internalRowListCapacity == 0) {
            this.doExpansion();
        }
    }

    private void doExpansion() {
        if (this.internalRowList.size() > 0) {
            int lastIndex = this.internalRowList.size() - 1;
            SerializableRowList lastInternalList = this.internalRowList.get(lastIndex);
            if (lastInternalList != null) {
                this.internalBlockCountList.add(lastInternalList.getBlockCount());
            } else {
                this.internalBlockCountList.add(0);
            }
        }
        this.internalRowList.add(SerializableRowList.construct(this.queryId, this.dataTypes));
    }

    public int getBlockCount(int index) {
        if (index == this.internalRowList.size() - 1) {
            SerializableRowList lastList = this.internalRowList.get(index);
            return lastList.getBlockCount();
        }
        return this.internalBlockCountList.get(index);
    }

    protected void checkMemoryUsage() throws IOException, QueryProcessException {
        if (this.rowCount - this.lastRowCount < 1000 || this.totalByteArrayLength <= this.totalByteArrayLengthLimit) {
            return;
        }
        this.lastRowCount = this.rowCount;
        int newByteArrayLengthForMemoryControl = this.byteArrayLengthForMemoryControl;
        while ((long)newByteArrayLengthForMemoryControl * (long)this.rowCount < this.totalByteArrayLength) {
            newByteArrayLengthForMemoryControl *= 2;
        }
        int newInternalTVListCapacity = SerializableRowList.calculateCapacity(this.dataTypes, this.memoryLimitInMB, newByteArrayLengthForMemoryControl) / this.numCacheBlock;
        if (newInternalTVListCapacity > 0) {
            this.applyNewMemoryControlParameters(newByteArrayLengthForMemoryControl, newInternalTVListCapacity);
            return;
        }
        int delta = (int)((this.totalByteArrayLength - this.totalByteArrayLengthLimit) / (long)this.rowCount / (long)this.indexListOfTextFields.length / (long)SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL);
        newByteArrayLengthForMemoryControl = this.byteArrayLengthForMemoryControl + 2 * (delta + 1) * SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
        newInternalTVListCapacity = SerializableRowList.calculateCapacity(this.dataTypes, this.memoryLimitInMB, newByteArrayLengthForMemoryControl) / this.numCacheBlock;
        if (newInternalTVListCapacity > 0) {
            this.applyNewMemoryControlParameters(newByteArrayLengthForMemoryControl, newInternalTVListCapacity);
            return;
        }
        throw new QueryProcessException("Memory is not enough for current query.");
    }

    protected void applyNewMemoryControlParameters(int newByteArrayLengthForMemoryControl, int newInternalRowRecordListCapacity) throws IOException, QueryProcessException {
        ElasticSerializableRowList newESRowList = new ElasticSerializableRowList(this.dataTypes, this.queryId, this.memoryLimitInMB, newInternalRowRecordListCapacity, this.numCacheBlock);
        newESRowList.evictionUpperBound = this.evictionUpperBound;
        int internalListEvictionUpperBound = this.evictionUpperBound / newInternalRowRecordListCapacity;
        for (int i = 0; i < internalListEvictionUpperBound; ++i) {
            newESRowList.internalRowList.add(null);
            if (i == 0) continue;
            newESRowList.internalBlockCountList.add(0);
        }
        newESRowList.rowCount = internalListEvictionUpperBound * newInternalRowRecordListCapacity;
        int emptyColumnSize = this.evictionUpperBound - newESRowList.rowCount;
        if (emptyColumnSize != 0) {
            newESRowList.putNulls(emptyColumnSize);
        }
        this.copyLatterColumnsAfterEvictionUpperBound(newESRowList);
        this.internalRowListCapacity = newInternalRowRecordListCapacity;
        this.cache = newESRowList.cache;
        this.internalRowList = newESRowList.internalRowList;
        this.internalBlockCountList = newESRowList.internalBlockCountList;
        this.byteArrayLengthForMemoryControl = newByteArrayLengthForMemoryControl;
        this.rowByteArrayLength = (long)this.byteArrayLengthForMemoryControl * (long)this.indexListOfTextFields.length;
        this.totalByteArrayLengthLimit = (long)this.rowCount * this.rowByteArrayLength;
        this.notifyAllIterators();
    }

    public void notifyAllIterators() throws IOException {
        for (RowListForwardIterator iterator : this.iteratorList) {
            iterator.adjust();
        }
    }

    public boolean fieldsHasAnyNull(int index) throws IOException {
        Object[] row;
        for (Object field : row = this.internalRowList.get(index / this.internalRowListCapacity).getRow(index % this.internalRowListCapacity)) {
            if (field != null) continue;
            return true;
        }
        return false;
    }

    public int getLastRowIndex(int externalIndex, int internalIndex) {
        int index = this.internalRowListCapacity * externalIndex;
        int offset = this.internalRowList.get(externalIndex).getLastRowIndex(internalIndex);
        return index + offset;
    }

    public void setEvictionUpperBound(int evictionUpperBound) {
        this.evictionUpperBound = evictionUpperBound;
    }

    private class LRUCache
    extends Cache {
        LRUCache(int capacity) {
            super(capacity);
        }

        SerializableRowList get(int targetIndex) throws IOException {
            if (!this.containsKey(targetIndex)) {
                if (this.cacheCapacity <= super.size()) {
                    int lastIndex = this.getLast();
                    if (lastIndex < ElasticSerializableRowList.this.evictionUpperBound / ElasticSerializableRowList.this.internalRowListCapacity) {
                        ElasticSerializableRowList.this.internalRowList.set(lastIndex, null);
                    } else {
                        ElasticSerializableRowList.this.internalRowList.get(lastIndex).serialize();
                    }
                }
                ElasticSerializableRowList.this.internalRowList.get(targetIndex).deserialize();
            }
            this.putKey(targetIndex);
            return ElasticSerializableRowList.this.internalRowList.get(targetIndex);
        }
    }
}

