/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.QueryExecutor;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.IFragmentParallelPlaner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.TreeModelTimePredicate;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.MultiChildrenSinkNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastSeriesSourceNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ExplainAnalyzeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowQueriesStatement;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFragmentParallelPlanner
implements IFragmentParallelPlaner {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFragmentParallelPlanner.class);
    private final SubPlan subPlan;
    private final Analysis analysis;
    private final MPPQueryContext queryContext;
    private final Map<PlanFragmentId, FragmentInstance> instanceMap;
    private final Map<PlanNodeId, Pair<PlanFragmentId, PlanNode>> planNodeMap;
    private final List<FragmentInstance> fragmentInstanceList;
    private final Map<TDataNodeLocation, List<FragmentInstance>> dataNodeFIMap;

    public SimpleFragmentParallelPlanner(SubPlan subPlan, Analysis analysis, MPPQueryContext context) {
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = context;
        this.instanceMap = new HashMap<PlanFragmentId, FragmentInstance>();
        this.planNodeMap = new HashMap<PlanNodeId, Pair<PlanFragmentId, PlanNode>>();
        this.fragmentInstanceList = new ArrayList<FragmentInstance>();
        this.dataNodeFIMap = new HashMap<TDataNodeLocation, List<FragmentInstance>>();
    }

    @Override
    public List<FragmentInstance> parallelPlan() {
        this.prepare();
        this.calculateNodeTopologyBetweenInstance();
        return this.fragmentInstanceList;
    }

    private void prepare() {
        List<PlanFragment> fragments = this.subPlan.getPlanFragmentList();
        for (PlanFragment fragment : fragments) {
            this.recordPlanNodeRelation(fragment.getPlanNodeTree(), fragment.getId());
            this.produceFragmentInstance(fragment);
        }
        this.fragmentInstanceList.forEach(fragmentInstance -> fragmentInstance.setDataNodeFINum(this.dataNodeFIMap.get(fragmentInstance.getHostDataNode()).size()));
        if (this.analysis.getStatement() instanceof QueryStatement && ((QueryStatement)this.analysis.getStatement()).isLastQuery()) {
            HashMap pathSumMap = new HashMap();
            this.dataNodeFIMap.values().forEach(fragmentInstances -> {
                fragmentInstances.forEach(fragmentInstance -> this.updateScanNum(fragmentInstance.getFragment().getPlanNodeTree(), pathSumMap));
                pathSumMap.clear();
            });
        }
    }

    private void updateScanNum(PlanNode planNode, Map<Path, AtomicInteger> pathSumMap) {
        if (planNode instanceof LastSeriesSourceNode) {
            LastSeriesSourceNode lastSeriesSourceNode = (LastSeriesSourceNode)planNode;
            pathSumMap.merge((Path)lastSeriesSourceNode.getSeriesPath(), lastSeriesSourceNode.getDataNodeSeriesScanNum(), (k, v) -> {
                v.incrementAndGet();
                return v;
            });
        }
        planNode.getChildren().forEach(node -> this.updateScanNum((PlanNode)node, pathSumMap));
    }

    private void produceFragmentInstance(PlanFragment fragment) {
        Expression globalTimePredicate = this.analysis.getGlobalTimePredicate();
        FragmentInstance fragmentInstance = new FragmentInstance(fragment, fragment.getId().genFragmentInstanceId(), globalTimePredicate == null ? null : new TreeModelTimePredicate(globalTimePredicate), this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession(), this.queryContext.isExplainAnalyze(), fragment.isRoot());
        TRegionReplicaSet regionReplicaSet = fragment.getTargetRegion();
        if (regionReplicaSet == null || regionReplicaSet.getRegionId() == null) {
            TDataNodeLocation dataNodeLocation = fragment.getTargetLocation();
            if (dataNodeLocation != null) {
                fragmentInstance.setExecutorAndHost((ExecutorType)new QueryExecutor(dataNodeLocation));
            } else {
                fragmentInstance.setExecutorAndHost((ExecutorType)new QueryExecutor(DataNodeEndPoints.getLocalDataNodeLocation()));
            }
        } else {
            fragmentInstance.setExecutorAndHost((ExecutorType)new StorageExecutor(regionReplicaSet));
            fragmentInstance.setHostDataNode(this.selectTargetDataNode(regionReplicaSet));
        }
        this.dataNodeFIMap.compute(fragmentInstance.getHostDataNode(), (k, v) -> {
            if (v == null) {
                v = new ArrayList<FragmentInstance>();
            }
            v.add(fragmentInstance);
            return v;
        });
        if (this.analysis.getStatement() instanceof QueryStatement || this.analysis.getStatement() instanceof ExplainAnalyzeStatement || this.analysis.getStatement() instanceof ShowQueriesStatement || this.analysis.getStatement() instanceof ShowTimeSeriesStatement && ((ShowTimeSeriesStatement)this.analysis.getStatement()).isOrderByHeat()) {
            fragmentInstance.getFragment().generateTypeProvider(this.queryContext.getTypeProvider());
        }
        this.instanceMap.putIfAbsent(fragment.getId(), fragmentInstance);
        this.fragmentInstanceList.add(fragmentInstance);
    }

    private TDataNodeLocation selectTargetDataNode(TRegionReplicaSet regionReplicaSet) {
        if (regionReplicaSet == null || regionReplicaSet.getDataNodeLocations() == null || regionReplicaSet.getDataNodeLocations().isEmpty()) {
            throw new IllegalArgumentException(String.format("regionReplicaSet is invalid: %s", regionReplicaSet));
        }
        String readConsistencyLevel = IoTDBDescriptor.getInstance().getConfig().getReadConsistencyLevel();
        boolean selectRandomDataNode = "weak".equals(readConsistencyLevel);
        List<TDataNodeLocation> availableDataNodes = this.filterAvailableTDataNode(regionReplicaSet.getDataNodeLocations());
        if (availableDataNodes.isEmpty()) {
            String errorMsg = String.format("all replicas for region[%s] are not available in these DataNodes[%s]", regionReplicaSet.getRegionId(), regionReplicaSet.getDataNodeLocations());
            throw new IllegalArgumentException(errorMsg);
        }
        if (regionReplicaSet.getDataNodeLocationsSize() != availableDataNodes.size()) {
            logger.info("available replicas: " + availableDataNodes);
        }
        int targetIndex = !selectRandomDataNode || this.queryContext.getSession() == null ? 0 : (int)(this.queryContext.getSession().getSessionId() % (long)availableDataNodes.size());
        return availableDataNodes.get(targetIndex);
    }

    private List<TDataNodeLocation> filterAvailableTDataNode(List<TDataNodeLocation> originalDataNodeList) {
        LinkedList<TDataNodeLocation> result = new LinkedList<TDataNodeLocation>();
        for (TDataNodeLocation dataNodeLocation : originalDataNodeList) {
            if (!this.isAvailableDataNode(dataNodeLocation)) continue;
            result.add(dataNodeLocation);
        }
        return result;
    }

    private boolean isAvailableDataNode(TDataNodeLocation dataNodeLocation) {
        for (TEndPoint endPoint : this.queryContext.getEndPointBlackList()) {
            if (!endPoint.equals(dataNodeLocation.internalEndPoint)) continue;
            return false;
        }
        return true;
    }

    private void calculateNodeTopologyBetweenInstance() {
        for (FragmentInstance instance : this.fragmentInstanceList) {
            PlanNode rootNode = instance.getFragment().getPlanNodeTree();
            if (!(rootNode instanceof MultiChildrenSinkNode)) continue;
            MultiChildrenSinkNode sinkNode = (MultiChildrenSinkNode)rootNode;
            sinkNode.getDownStreamChannelLocationList().forEach(downStreamChannelLocation -> {
                PlanNodeId downStreamNodeId = new PlanNodeId(downStreamChannelLocation.getRemotePlanNodeId());
                FragmentInstance downStreamInstance = this.findDownStreamInstance(downStreamNodeId);
                downStreamChannelLocation.setRemoteEndpoint(downStreamInstance.getHostDataNode().getMPPDataExchangeEndPoint());
                downStreamChannelLocation.setRemoteFragmentInstanceId(downStreamInstance.getId().toThrift());
                PlanNode downStreamExchangeNode = (PlanNode)this.planNodeMap.get((Object)downStreamNodeId).right;
                ((ExchangeNode)downStreamExchangeNode).setUpstream(instance.getHostDataNode().getMPPDataExchangeEndPoint(), instance.getId(), sinkNode.getPlanNodeId());
            });
        }
    }

    private FragmentInstance findDownStreamInstance(PlanNodeId exchangeNodeId) {
        return this.instanceMap.get(this.planNodeMap.get((Object)exchangeNodeId).left);
    }

    private void recordPlanNodeRelation(PlanNode root, PlanFragmentId planFragmentId) {
        this.planNodeMap.put(root.getPlanNodeId(), (Pair<PlanFragmentId, PlanNode>)new Pair((Object)planFragmentId, (Object)root));
        for (PlanNode child : root.getChildren()) {
            this.recordPlanNodeRelation(child, planFragmentId);
        }
    }
}

