/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ServerStatusDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=862");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=863");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=864");
    private final DateTime startTime;
    private final DateTime currentTime;
    private final ServerState state;
    private final BuildInfo buildInfo;
    private final UInteger secondsTillShutdown;
    private final LocalizedText shutdownReason;

    public ServerStatusDataType(DateTime startTime, DateTime currentTime, ServerState state, BuildInfo buildInfo, UInteger secondsTillShutdown, LocalizedText shutdownReason) {
        this.startTime = startTime;
        this.currentTime = currentTime;
        this.state = state;
        this.buildInfo = buildInfo;
        this.secondsTillShutdown = secondsTillShutdown;
        this.shutdownReason = shutdownReason;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getCurrentTime() {
        return this.currentTime;
    }

    public ServerState getState() {
        return this.state;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public UInteger getSecondsTillShutdown() {
        return this.secondsTillShutdown;
    }

    public LocalizedText getShutdownReason() {
        return this.shutdownReason;
    }

    protected ServerStatusDataType(ServerStatusDataTypeBuilder<?, ?> b) {
        super(b);
        this.startTime = ((ServerStatusDataTypeBuilder)b).startTime;
        this.currentTime = ((ServerStatusDataTypeBuilder)b).currentTime;
        this.state = ((ServerStatusDataTypeBuilder)b).state;
        this.buildInfo = ((ServerStatusDataTypeBuilder)b).buildInfo;
        this.secondsTillShutdown = ((ServerStatusDataTypeBuilder)b).secondsTillShutdown;
        this.shutdownReason = ((ServerStatusDataTypeBuilder)b).shutdownReason;
    }

    public static ServerStatusDataTypeBuilder<?, ?> builder() {
        return new ServerStatusDataTypeBuilderImpl();
    }

    public ServerStatusDataTypeBuilder<?, ?> toBuilder() {
        return new ServerStatusDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerStatusDataType)) {
            return false;
        }
        ServerStatusDataType other = (ServerStatusDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DateTime this$startTime = this.getStartTime();
        DateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        DateTime this$currentTime = this.getCurrentTime();
        DateTime other$currentTime = other.getCurrentTime();
        if (this$currentTime == null ? other$currentTime != null : !((Object)this$currentTime).equals(other$currentTime)) {
            return false;
        }
        ServerState this$state = this.getState();
        ServerState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        BuildInfo this$buildInfo = this.getBuildInfo();
        BuildInfo other$buildInfo = other.getBuildInfo();
        if (this$buildInfo == null ? other$buildInfo != null : !((Object)this$buildInfo).equals(other$buildInfo)) {
            return false;
        }
        UInteger this$secondsTillShutdown = this.getSecondsTillShutdown();
        UInteger other$secondsTillShutdown = other.getSecondsTillShutdown();
        if (this$secondsTillShutdown == null ? other$secondsTillShutdown != null : !((Object)this$secondsTillShutdown).equals(other$secondsTillShutdown)) {
            return false;
        }
        LocalizedText this$shutdownReason = this.getShutdownReason();
        LocalizedText other$shutdownReason = other.getShutdownReason();
        return !(this$shutdownReason == null ? other$shutdownReason != null : !((Object)this$shutdownReason).equals(other$shutdownReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerStatusDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        DateTime $currentTime = this.getCurrentTime();
        result = result * 59 + ($currentTime == null ? 43 : ((Object)$currentTime).hashCode());
        ServerState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        BuildInfo $buildInfo = this.getBuildInfo();
        result = result * 59 + ($buildInfo == null ? 43 : ((Object)$buildInfo).hashCode());
        UInteger $secondsTillShutdown = this.getSecondsTillShutdown();
        result = result * 59 + ($secondsTillShutdown == null ? 43 : ((Object)$secondsTillShutdown).hashCode());
        LocalizedText $shutdownReason = this.getShutdownReason();
        result = result * 59 + ($shutdownReason == null ? 43 : ((Object)$shutdownReason).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ServerStatusDataType(startTime=" + this.getStartTime() + ", currentTime=" + this.getCurrentTime() + ", state=" + this.getState() + ", buildInfo=" + this.getBuildInfo() + ", secondsTillShutdown=" + this.getSecondsTillShutdown() + ", shutdownReason=" + this.getShutdownReason() + ")";
    }

    private static final class ServerStatusDataTypeBuilderImpl
    extends ServerStatusDataTypeBuilder<ServerStatusDataType, ServerStatusDataTypeBuilderImpl> {
        private ServerStatusDataTypeBuilderImpl() {
        }

        @Override
        protected ServerStatusDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public ServerStatusDataType build() {
            return new ServerStatusDataType(this);
        }
    }

    public static abstract class ServerStatusDataTypeBuilder<C extends ServerStatusDataType, B extends ServerStatusDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private DateTime startTime;
        private DateTime currentTime;
        private ServerState state;
        private BuildInfo buildInfo;
        private UInteger secondsTillShutdown;
        private LocalizedText shutdownReason;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ServerStatusDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ServerStatusDataType instance, ServerStatusDataTypeBuilder<?, ?> b) {
            b.startTime(instance.startTime);
            b.currentTime(instance.currentTime);
            b.state(instance.state);
            b.buildInfo(instance.buildInfo);
            b.secondsTillShutdown(instance.secondsTillShutdown);
            b.shutdownReason(instance.shutdownReason);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B startTime(DateTime startTime) {
            this.startTime = startTime;
            return (B)this.self();
        }

        public B currentTime(DateTime currentTime) {
            this.currentTime = currentTime;
            return (B)this.self();
        }

        public B state(ServerState state) {
            this.state = state;
            return (B)this.self();
        }

        public B buildInfo(BuildInfo buildInfo) {
            this.buildInfo = buildInfo;
            return (B)this.self();
        }

        public B secondsTillShutdown(UInteger secondsTillShutdown) {
            this.secondsTillShutdown = secondsTillShutdown;
            return (B)this.self();
        }

        public B shutdownReason(LocalizedText shutdownReason) {
            this.shutdownReason = shutdownReason;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ServerStatusDataType.ServerStatusDataTypeBuilder(super=" + super.toString() + ", startTime=" + this.startTime + ", currentTime=" + this.currentTime + ", state=" + this.state + ", buildInfo=" + this.buildInfo + ", secondsTillShutdown=" + this.secondsTillShutdown + ", shutdownReason=" + this.shutdownReason + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ServerStatusDataType> {
        @Override
        public Class<ServerStatusDataType> getType() {
            return ServerStatusDataType.class;
        }

        @Override
        public ServerStatusDataType decode(SerializationContext context, UaDecoder decoder) {
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime currentTime = decoder.readDateTime("CurrentTime");
            ServerState state = decoder.readEnum("State", ServerState.class);
            BuildInfo buildInfo = (BuildInfo)decoder.readStruct("BuildInfo", BuildInfo.TYPE_ID);
            UInteger secondsTillShutdown = decoder.readUInt32("SecondsTillShutdown");
            LocalizedText shutdownReason = decoder.readLocalizedText("ShutdownReason");
            return new ServerStatusDataType(startTime, currentTime, state, buildInfo, secondsTillShutdown, shutdownReason);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ServerStatusDataType value) {
            encoder.writeDateTime("StartTime", value.getStartTime());
            encoder.writeDateTime("CurrentTime", value.getCurrentTime());
            encoder.writeEnum("State", value.getState());
            encoder.writeStruct("BuildInfo", (Object)value.getBuildInfo(), BuildInfo.TYPE_ID);
            encoder.writeUInt32("SecondsTillShutdown", value.getSecondsTillShutdown());
            encoder.writeLocalizedText("ShutdownReason", value.getShutdownReason());
        }
    }
}

