/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema.mnode.basic;

import java.util.ArrayList;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.confignode.persistence.schema.mnode.container.ConfigMNodeContainer;
import org.apache.iotdb.confignode.persistence.schema.mnode.info.ConfigMNodeInfo;

public abstract class ConfigBasicMNode
implements IConfigMNode {
    private static final long serialVersionUID = -770028375899514063L;
    private IConfigMNode parent;
    private final ConfigMNodeInfo configMNodeInfo;
    private String fullPath;

    public ConfigBasicMNode(IConfigMNode parent, String name) {
        this.parent = parent;
        this.configMNodeInfo = new ConfigMNodeInfo(name);
    }

    public String getName() {
        return this.configMNodeInfo.getName();
    }

    public void setName(String name) {
        this.configMNodeInfo.setName(name);
    }

    public IConfigMNode getParent() {
        return this.parent;
    }

    public void setParent(IConfigMNode parent) {
        this.parent = parent;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath();
        }
        return this.fullPath;
    }

    String concatFullPath() {
        StringBuilder builder = new StringBuilder(this.getName());
        IConfigMNode curr = this;
        while (curr.getParent() != null) {
            curr = (IConfigMNode)curr.getParent();
            builder.insert(0, '.').insert(0, curr.getName());
        }
        return builder.toString();
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public PartialPath getPartialPath() {
        ArrayList<String> detachedPath = new ArrayList<String>();
        IConfigMNode temp = this;
        detachedPath.add(temp.getName());
        while (temp.getParent() != null) {
            temp = (IConfigMNode)temp.getParent();
            detachedPath.add(0, temp.getName());
        }
        return new PartialPath(detachedPath.toArray(new String[0]));
    }

    public boolean hasChild(String name) {
        return false;
    }

    public IConfigMNode getChild(String name) {
        return null;
    }

    public IConfigMNode addChild(String name, IConfigMNode child) {
        return null;
    }

    public IConfigMNode addChild(IConfigMNode child) {
        return null;
    }

    public IConfigMNode deleteChild(String name) {
        return null;
    }

    public IMNodeContainer<IConfigMNode> getChildren() {
        return ConfigMNodeContainer.emptyMNodeContainer();
    }

    public void setChildren(IMNodeContainer<IConfigMNode> children) {
    }

    public boolean isAboveDatabase() {
        return false;
    }

    public boolean isDatabase() {
        return false;
    }

    public IDatabaseMNode<IConfigMNode> getAsDatabaseMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return (R)visitor.visitBasicMNode((IMNode)this, context);
    }

    @Override
    public void setSchemaTemplateId(int id) {
        this.configMNodeInfo.setSchemaTemplateId(id);
    }

    @Override
    public int getSchemaTemplateId() {
        return this.configMNodeInfo.getSchemaTemplateId();
    }

    @Override
    public void preUnsetSchemaTemplate() {
        this.configMNodeInfo.preUnsetSchemaTemplate();
    }

    @Override
    public void rollbackUnsetSchemaTemplate() {
        this.configMNodeInfo.rollbackUnsetSchemaTemplate();
    }

    @Override
    public boolean isSchemaTemplatePreUnset() {
        return this.configMNodeInfo.isSchemaTemplatePreUnset();
    }

    @Override
    public void unsetSchemaTemplate() {
        this.configMNodeInfo.unsetSchemaTemplate();
    }

    public int estimateSize() {
        return 76 + this.configMNodeInfo.estimateSize();
    }
}

