/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.consumer;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubscriptionExecutorServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionExecutorServiceManager.class);
    private static final long AWAIT_TERMINATION_TIMEOUT_MS = 15000L;
    private static final String CONTROL_FLOW_EXECUTOR_NAME = "SubscriptionControlFlowExecutor";
    private static final String UPSTREAM_DATA_FLOW_EXECUTOR_NAME = "SubscriptionUpstreamDataFlowExecutor";
    private static final String DOWNSTREAM_DATA_FLOW_EXECUTOR_NAME = "SubscriptionDownstreamDataFlowExecutor";
    private static final SubscriptionScheduledExecutorService CONTROL_FLOW_EXECUTOR = new SubscriptionScheduledExecutorService("SubscriptionControlFlowExecutor", Math.max(Runtime.getRuntime().availableProcessors() / 2, 1));
    private static final SubscriptionScheduledExecutorService UPSTREAM_DATA_FLOW_EXECUTOR = new SubscriptionScheduledExecutorService("SubscriptionUpstreamDataFlowExecutor", Math.max(Runtime.getRuntime().availableProcessors() / 2, 1));
    private static final SubscriptionExecutorService DOWNSTREAM_DATA_FLOW_EXECUTOR = new SubscriptionExecutorService("SubscriptionDownstreamDataFlowExecutor", Math.max(Runtime.getRuntime().availableProcessors(), 1));

    public static void setControlFlowExecutorCorePoolSize(int corePoolSize) {
        CONTROL_FLOW_EXECUTOR.setCorePoolSize(corePoolSize);
    }

    public static void setUpstreamDataFlowExecutorCorePoolSize(int corePoolSize) {
        UPSTREAM_DATA_FLOW_EXECUTOR.setCorePoolSize(corePoolSize);
    }

    public static void setDownstreamDataFlowExecutorCorePoolSize(int corePoolSize) {
        DOWNSTREAM_DATA_FLOW_EXECUTOR.setCorePoolSize(corePoolSize);
    }

    public static ScheduledFuture<?> submitHeartbeatWorker(Runnable task, long heartbeatIntervalMs) {
        CONTROL_FLOW_EXECUTOR.launchIfNeeded();
        return CONTROL_FLOW_EXECUTOR.scheduleWithFixedDelay(task, SubscriptionExecutorServiceManager.generateRandomInitialDelayMs(heartbeatIntervalMs), heartbeatIntervalMs, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> submitEndpointsSyncer(Runnable task, long endpointsSyncIntervalMs) {
        CONTROL_FLOW_EXECUTOR.launchIfNeeded();
        return CONTROL_FLOW_EXECUTOR.scheduleWithFixedDelay(task, SubscriptionExecutorServiceManager.generateRandomInitialDelayMs(endpointsSyncIntervalMs), endpointsSyncIntervalMs, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> submitAutoPollWorker(Runnable task, long autoPollIntervalMs) {
        CONTROL_FLOW_EXECUTOR.launchIfNeeded();
        return CONTROL_FLOW_EXECUTOR.scheduleWithFixedDelay(task, SubscriptionExecutorServiceManager.generateRandomInitialDelayMs(autoPollIntervalMs), autoPollIntervalMs, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> submitAutoCommitWorker(Runnable task, long autoCommitIntervalMs) {
        UPSTREAM_DATA_FLOW_EXECUTOR.launchIfNeeded();
        return UPSTREAM_DATA_FLOW_EXECUTOR.scheduleWithFixedDelay(task, SubscriptionExecutorServiceManager.generateRandomInitialDelayMs(autoCommitIntervalMs), autoCommitIntervalMs, TimeUnit.MILLISECONDS);
    }

    public static void submitAsyncCommitWorker(Runnable task) {
        UPSTREAM_DATA_FLOW_EXECUTOR.launchIfNeeded();
        UPSTREAM_DATA_FLOW_EXECUTOR.submit(task);
    }

    public static <T> List<Future<T>> submitMultiplePollTasks(Collection<? extends Callable<T>> tasks, long timeoutMs) throws InterruptedException {
        DOWNSTREAM_DATA_FLOW_EXECUTOR.launchIfNeeded();
        return DOWNSTREAM_DATA_FLOW_EXECUTOR.invokeAll(tasks, timeoutMs);
    }

    public static int getAvailableThreadCountForPollTasks() {
        DOWNSTREAM_DATA_FLOW_EXECUTOR.launchIfNeeded();
        return DOWNSTREAM_DATA_FLOW_EXECUTOR.getAvailableCount();
    }

    private static long generateRandomInitialDelayMs(long maxMs) {
        return (long)(Math.random() * (double)maxMs);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new SubscriptionExecutorServiceShutdownHook(), "SubscriptionExecutorServiceShutdownHook"));
    }

    private static class SubscriptionExecutorService {
        String name;
        volatile int corePoolSize;
        volatile ExecutorService executor;

        SubscriptionExecutorService(String name, int corePoolSize) {
            this.name = name;
            this.corePoolSize = corePoolSize;
        }

        boolean isShutdown() {
            return Objects.isNull(this.executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCorePoolSize(int corePoolSize) {
            if (this.isShutdown()) {
                SubscriptionExecutorService subscriptionExecutorService = this;
                synchronized (subscriptionExecutorService) {
                    if (this.isShutdown()) {
                        this.corePoolSize = corePoolSize;
                        return;
                    }
                }
            }
            LOGGER.warn("{} has been launched, set core pool size to {} will be ignored", (Object)this.name, (Object)corePoolSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void launchIfNeeded() {
            if (this.isShutdown()) {
                SubscriptionExecutorService subscriptionExecutorService = this;
                synchronized (subscriptionExecutorService) {
                    if (this.isShutdown()) {
                        LOGGER.info("Launching {} with core pool size {}...", (Object)this.name, (Object)this.corePoolSize);
                        this.executor = Executors.newFixedThreadPool(this.corePoolSize, r -> {
                            Thread t = new Thread(Thread.currentThread().getThreadGroup(), r, this.name, 0L);
                            if (!t.isDaemon()) {
                                t.setDaemon(true);
                            }
                            if (t.getPriority() != 5) {
                                t.setPriority(5);
                            }
                            return t;
                        });
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            if (!this.isShutdown()) {
                SubscriptionExecutorService subscriptionExecutorService = this;
                synchronized (subscriptionExecutorService) {
                    if (!this.isShutdown()) {
                        LOGGER.info("Shutting down {}...", (Object)this.name);
                        this.executor.shutdown();
                        try {
                            if (!this.executor.awaitTermination(15000L, TimeUnit.MILLISECONDS)) {
                                this.executor.shutdownNow();
                                LOGGER.warn("Interrupt the worker, which may cause some task inconsistent. Please check the biz logs.");
                                if (!this.executor.awaitTermination(15000L, TimeUnit.MILLISECONDS)) {
                                    LOGGER.error("Thread pool can't be shutdown even with interrupting worker threads, which may cause some task inconsistent. Please check the biz logs.");
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            this.executor.shutdownNow();
                            LOGGER.error("The current thread is interrupted when it is trying to stop the worker threads. This may leave an inconsistent state. Please check the biz logs.");
                            Thread.currentThread().interrupt();
                        }
                        this.executor = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Future<?> submit(Runnable task) {
            if (!this.isShutdown()) {
                SubscriptionExecutorService subscriptionExecutorService = this;
                synchronized (subscriptionExecutorService) {
                    if (!this.isShutdown()) {
                        return this.executor.submit(task);
                    }
                }
            }
            LOGGER.warn("{} has not been launched, ignore submit task", (Object)this.name);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeoutMs) throws InterruptedException {
            if (!this.isShutdown()) {
                SubscriptionExecutorService subscriptionExecutorService = this;
                synchronized (subscriptionExecutorService) {
                    if (!this.isShutdown()) {
                        return this.executor.invokeAll(tasks, timeoutMs, TimeUnit.MILLISECONDS);
                    }
                }
            }
            LOGGER.warn("{} has not been launched, ignore invoke all tasks", (Object)this.name);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getAvailableCount() {
            if (!this.isShutdown()) {
                SubscriptionExecutorService subscriptionExecutorService = this;
                synchronized (subscriptionExecutorService) {
                    if (!this.isShutdown()) {
                        return 0;
                    }
                }
            }
            LOGGER.warn("{} has not been launched, return zero", (Object)this.name);
            return 0;
        }
    }

    private static class SubscriptionScheduledExecutorService
    extends SubscriptionExecutorService {
        SubscriptionScheduledExecutorService(String name, int corePoolSize) {
            super(name, corePoolSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void launchIfNeeded() {
            if (this.isShutdown()) {
                SubscriptionScheduledExecutorService subscriptionScheduledExecutorService = this;
                synchronized (subscriptionScheduledExecutorService) {
                    if (this.isShutdown()) {
                        LOGGER.info("Launching {} with core pool size {}...", (Object)this.name, (Object)this.corePoolSize);
                        this.executor = Executors.newScheduledThreadPool(this.corePoolSize, r -> {
                            Thread t = new Thread(Thread.currentThread().getThreadGroup(), r, this.name, 0L);
                            if (!t.isDaemon()) {
                                t.setDaemon(true);
                            }
                            if (t.getPriority() != 5) {
                                t.setPriority(5);
                            }
                            return t;
                        });
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            if (!this.isShutdown()) {
                SubscriptionScheduledExecutorService subscriptionScheduledExecutorService = this;
                synchronized (subscriptionScheduledExecutorService) {
                    if (!this.isShutdown()) {
                        return ((ScheduledExecutorService)this.executor).scheduleWithFixedDelay(task, initialDelay, delay, unit);
                    }
                }
            }
            LOGGER.warn("{} has not been launched, ignore scheduleWithFixedDelay for task", (Object)this.name);
            return null;
        }
    }

    private static class SubscriptionExecutorServiceShutdownHook
    implements Runnable {
        private SubscriptionExecutorServiceShutdownHook() {
        }

        @Override
        public void run() {
            CONTROL_FLOW_EXECUTOR.shutdown();
            UPSTREAM_DATA_FLOW_EXECUTOR.shutdown();
            DOWNSTREAM_DATA_FLOW_EXECUTOR.shutdown();
        }
    }
}

