/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricRegistriesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistriesLoader.class);
    static final String DEFAULT_CLASS = "org.apache.ratis.metrics.impl.MetricRegistriesImpl";

    private MetricRegistriesLoader() {
    }

    public static MetricRegistries load() {
        List<MetricRegistries> availableImplementations = MetricRegistriesLoader.getDefinedImplementations();
        return MetricRegistriesLoader.load(availableImplementations);
    }

    @VisibleForTesting
    static MetricRegistries load(List<MetricRegistries> registries) {
        if (registries.isEmpty()) {
            try {
                return (MetricRegistries)ReflectionUtils.newInstance(Class.forName(DEFAULT_CLASS).asSubclass(MetricRegistries.class));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to load default MetricRegistries org.apache.ratis.metrics.impl.MetricRegistriesImpl", e);
            }
        }
        MetricRegistries first = registries.get(0);
        if (registries.size() == 1) {
            LOG.debug("Loaded {}", first.getClass());
        } else {
            List classes = registries.stream().map(Object::getClass).collect(Collectors.toList());
            LOG.warn("Found multiple MetricRegistries: {}. Using the first: {}", classes, first.getClass());
        }
        return first;
    }

    private static List<MetricRegistries> getDefinedImplementations() {
        ServiceLoader<MetricRegistries> loader = ServiceLoader.load(MetricRegistries.class, MetricRegistries.class.getClassLoader());
        ArrayList<MetricRegistries> availableFactories = new ArrayList<MetricRegistries>();
        for (MetricRegistries impl : loader) {
            availableFactories.add(impl);
        }
        return availableFactories;
    }
}

