/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.warnings;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.db.queryengine.execution.warnings.IoTDBWarning;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;

@ThreadSafe
public class DefaultWarningCollector
implements WarningCollector {
    @GuardedBy(value="this")
    private final Set<IoTDBWarning> warnings = new LinkedHashSet<IoTDBWarning>();
    private final int maxWarnings;

    public DefaultWarningCollector(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    @Override
    public synchronized void add(IoTDBWarning warning) {
        Objects.requireNonNull(warning, "warning is null");
        if (this.warnings.size() < this.maxWarnings) {
            this.warnings.add(warning);
        }
    }

    @Override
    public synchronized List<IoTDBWarning> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }
}

