/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.tsfile.file.metadata.IDeviceID;

public class DeviceIDFactory {
    public static DeviceIDFactory getInstance() {
        return DeviceIDFactoryHolder.INSTANCE;
    }

    private DeviceIDFactory() {
    }

    public IDeviceID getDeviceID(PartialPath devicePath) {
        return devicePath.getIDeviceID();
    }

    public static List<IDeviceID> convertRawDeviceIDs2PartitionKeys(String tableName, List<Object[]> deviceIdList) {
        ArrayList<IDeviceID> tmpPartitionKeyList = new ArrayList<IDeviceID>();
        for (Object[] rawId : deviceIdList) {
            String[] partitionKey = new String[rawId.length + 1];
            partitionKey[0] = tableName;
            for (int i = 1; i <= rawId.length; ++i) {
                partitionKey[i] = (String)rawId[i - 1];
            }
            tmpPartitionKeyList.add(IDeviceID.Factory.DEFAULT_FACTORY.create(partitionKey));
        }
        return tmpPartitionKeyList;
    }

    public static List<Object[]> truncateTailingNull(List<Object[]> deviceIdList) {
        return deviceIdList.stream().map(DeviceIDFactory::truncateTailingNull).collect(Collectors.toList());
    }

    public static Object[] truncateTailingNull(Object[] device) {
        if (device == null) {
            throw new IllegalArgumentException("DeviceID's length should be larger than 0.");
        }
        int lastNonNullIndex = -1;
        for (int i = device.length - 1; i >= 0; --i) {
            if (device[i] == null) continue;
            lastNonNullIndex = i;
            break;
        }
        return lastNonNullIndex == device.length - 1 ? device : Arrays.copyOf(device, lastNonNullIndex + 1);
    }

    private static class DeviceIDFactoryHolder {
        private static final DeviceIDFactory INSTANCE = new DeviceIDFactory();

        private DeviceIDFactoryHolder() {
        }
    }
}

