/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionAnalyzeVisitor;

public abstract class ReconstructVisitor<C>
extends ExpressionAnalyzeVisitor<Expression, C> {
    @Override
    public Expression visitTernaryExpression(TernaryExpression ternaryExpression, C context) {
        List childResults = this.getResultsFromChild(ternaryExpression, context);
        return ExpressionUtils.reconstructTernaryExpression(ternaryExpression, (Expression)childResults.get(0), (Expression)childResults.get(1), (Expression)childResults.get(2));
    }

    @Override
    public Expression visitBinaryExpression(BinaryExpression binaryExpression, C context) {
        List childResults = this.getResultsFromChild(binaryExpression, context);
        return ExpressionUtils.reconstructBinaryExpression(binaryExpression, (Expression)childResults.get(0), (Expression)childResults.get(1));
    }

    @Override
    public Expression visitUnaryExpression(UnaryExpression unaryExpression, C context) {
        List childResults = this.getResultsFromChild(unaryExpression, context);
        return ExpressionUtils.reconstructUnaryExpression(unaryExpression, (Expression)childResults.get(0));
    }

    @Override
    public Expression visitCaseWhenThenExpression(CaseWhenThenExpression caseWhenThenExpression, C context) {
        List<Expression> childResults = this.getResultsFromChild(caseWhenThenExpression, context);
        return ExpressionUtils.reconstructCaseWhenThenExpression(caseWhenThenExpression, childResults);
    }

    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, C context) {
        List<Expression> reconstructedChildren = this.getReconstructedChildren(functionExpression, context);
        return ExpressionUtils.reconstructFunctionExpression(functionExpression, reconstructedChildren);
    }

    protected List<Expression> getReconstructedChildren(FunctionExpression functionExpression, C context) {
        int i;
        List<Expression> expressions = functionExpression.getExpressions();
        int childrenStartIndex = 0;
        int childrenEndIndex = "count_if".equalsIgnoreCase(functionExpression.getFunctionName()) ? 1 : expressions.size();
        ArrayList<Expression> reconstructedChildren = new ArrayList<Expression>();
        for (i = childrenStartIndex; i < childrenEndIndex; ++i) {
            reconstructedChildren.add((Expression)this.process(expressions.get(i), context));
        }
        for (i = childrenEndIndex; i < expressions.size(); ++i) {
            reconstructedChildren.add(expressions.get(i));
        }
        return reconstructedChildren;
    }

    @Override
    public Expression visitLeafOperand(LeafOperand leafOperand, C context) {
        return leafOperand;
    }
}

