/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CollectNode
extends MultiChildProcessNode {
    private List<Symbol> outputSymbols;

    public CollectNode(PlanNodeId id, List<Symbol> outputSymbols) {
        super(id);
        this.outputSymbols = outputSymbols;
    }

    public CollectNode(PlanNodeId id, List<PlanNode> children, List<Symbol> outputSymbols) {
        super(id, children);
        this.outputSymbols = outputSymbols;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitCollect(this, context);
    }

    @Override
    public PlanNode clone() {
        return new CollectNode(this.id, this.outputSymbols);
    }

    public void setOutputSymbols(List<Symbol> outputSymbols) {
        this.outputSymbols = outputSymbols;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((this.children.size() == newChildren.size() ? 1 : 0) != 0, (Object)"wrong number of new children");
        return new CollectNode(this.id, newChildren, this.outputSymbols);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_COLLECT_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputSymbols.size(), (ByteBuffer)byteBuffer);
        this.outputSymbols.forEach(symbol -> Symbol.serialize(symbol, byteBuffer));
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_COLLECT_NODE.serialize(stream);
        ReadWriteIOUtils.write((int)this.outputSymbols.size(), (OutputStream)stream);
        for (Symbol symbol : this.outputSymbols) {
            Symbol.serialize(symbol, stream);
        }
    }

    public static CollectNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> outputSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            outputSymbols.add(Symbol.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new CollectNode(planNodeId, (List<Symbol>)outputSymbols);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode()});
    }

    public String toString() {
        return "CollectNode-" + this.getPlanNodeId();
    }
}

