/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class IrConcatenation
extends IrRowPattern {
    private final List<IrRowPattern> patterns;

    public IrConcatenation(List<IrRowPattern> patterns) {
        this.patterns = Objects.requireNonNull(patterns, "patterns is null");
        Preconditions.checkArgument((patterns.size() >= 2 ? 1 : 0) != 0, (String)"pattern concatenation must have at least 2 elements (actual: %s)", (int)patterns.size());
    }

    public List<IrRowPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public <R, C> R accept(IrRowPatternVisitor<R, C> visitor, C context) {
        return visitor.visitIrConcatenation(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrConcatenation o = (IrConcatenation)obj;
        return Objects.equals(this.patterns, o.patterns);
    }

    public int hashCode() {
        return Objects.hash(this.patterns);
    }

    public String toString() {
        return this.patterns.stream().map(Object::toString).collect(Collectors.joining(" ", "(", ")"));
    }

    public static void serialize(IrConcatenation pattern, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)pattern.patterns.size(), (ByteBuffer)byteBuffer);
        for (IrRowPattern subPattern : pattern.patterns) {
            IrRowPattern.serialize(subPattern, byteBuffer);
        }
    }

    public static void serialize(IrConcatenation pattern, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)pattern.patterns.size(), (OutputStream)stream);
        for (IrRowPattern subPattern : pattern.patterns) {
            IrRowPattern.serialize(subPattern, stream);
        }
    }

    public static IrConcatenation deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<IrRowPattern> patterns = new ArrayList<IrRowPattern>(size);
        for (int i = 0; i < size; ++i) {
            patterns.add(IrRowPattern.deserialize(byteBuffer));
        }
        return new IrConcatenation(patterns);
    }
}

