/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.BitwiseUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class BitCount2ColumnTransformer
extends BinaryColumnTransformer {
    public BitCount2ColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void checkType() {
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.transform(leftColumn, rightColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i] && !leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.transform(leftColumn, rightColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(Column leftColumn, Column rightColumn, ColumnBuilder columnBuilder, int i) {
        long num = leftColumn.getLong(i);
        long bits = rightColumn.getLong(i);
        long currentValue = BitwiseUtils.bitCountTransform(num, bits);
        columnBuilder.writeLong(currentValue);
    }
}

