/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import org.apache.james.jdkim.tagvalue.SignatureRecordImpl;
import org.junit.Assert;
import org.junit.Test;

public class SignatureRecordImplTest {
    @Test
    public void testQPDecode() {
        Assert.assertEquals((Object)"", (Object)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)""));
        Assert.assertEquals((Object)"@", (Object)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=40"));
        Assert.assertEquals((Object)"\r\n", (Object)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=0D=0A"));
        Assert.assertEquals((Object)"\u0000CIAO\u0000", (Object)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=00CIAO=00"));
        Assert.assertEquals((Object)"thisisatest", (Object)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"this\r\n\tis\r\n a\r\n  \t test"));
    }

    @Test
    public void testQPWhiteSpaces() {
        Assert.assertEquals((Object)"thisisatest", (Object)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"this is a test"));
        Assert.assertEquals((Object)"thisisatest", (Object)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"this\r\n is a test"));
    }

    @Test
    public void testQPInvalid() {
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"==");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=2 3");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=3");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=3a");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"==20");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=20=");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=3x");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"this\r\nis a test");
            Assert.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWrongHashSyntaxes() {
        SignatureRecordImpl sr = new SignatureRecordImpl("v=1; a=nothyphenedword;");
        try {
            sr.getHashAlgo();
            Assert.fail((String)"expected failure");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().toLowerCase().contains("hash"));
        }
        try {
            sr.getHashMethod();
            Assert.fail((String)"expected failure");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().toLowerCase().contains("hash"));
        }
        try {
            sr.getHashAlgo();
            Assert.fail((String)"expected failure");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().toLowerCase().contains("hash"));
        }
    }

    @Test
    public void testExpired() {
        SignatureRecordImpl sr = new SignatureRecordImpl("v=1; c=simple; h=from:to; s=select; d=example.com; a=rsa-sha1; x=0; bh=abcdef; b=1235345987;");
        try {
            sr.validate();
            Assert.fail((String)"expected failure");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("expired"));
        }
    }
}

