/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class CharRangeMatcher
extends AbstractMatcher {
    public final char cLow;
    public final char cHigh;

    public CharRangeMatcher(char c, char c2) {
        super(StringUtils.escape(c) + ".." + StringUtils.escape(c2));
        Preconditions.checkArgument(c < c2);
        this.cLow = c;
        this.cHigh = c2;
    }

    public boolean match(MatcherContext matcherContext) {
        char c = matcherContext.getCurrentChar();
        if (c < this.cLow || c > this.cHigh) {
            return false;
        }
        matcherContext.advanceIndex(1);
        matcherContext.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> matcherVisitor) {
        Preconditions.checkArgNotNull(matcherVisitor, "visitor");
        return matcherVisitor.visit(this);
    }
}

