/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.process;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.client.ml.job.results.Result;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ModelSizeStats
implements ToXContentObject {
    public static final String RESULT_TYPE_VALUE = "model_size_stats";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("model_size_stats", new String[0]);
    public static final ParseField MODEL_BYTES_FIELD = new ParseField("model_bytes", new String[0]);
    public static final ParseField PEAK_MODEL_BYTES_FIELD = new ParseField("peak_model_bytes", new String[0]);
    public static final ParseField MODEL_BYTES_EXCEEDED_FIELD = new ParseField("model_bytes_exceeded", new String[0]);
    public static final ParseField MODEL_BYTES_MEMORY_LIMIT_FIELD = new ParseField("model_bytes_memory_limit", new String[0]);
    public static final ParseField TOTAL_BY_FIELD_COUNT_FIELD = new ParseField("total_by_field_count", new String[0]);
    public static final ParseField TOTAL_OVER_FIELD_COUNT_FIELD = new ParseField("total_over_field_count", new String[0]);
    public static final ParseField TOTAL_PARTITION_FIELD_COUNT_FIELD = new ParseField("total_partition_field_count", new String[0]);
    public static final ParseField BUCKET_ALLOCATION_FAILURES_COUNT_FIELD = new ParseField("bucket_allocation_failures_count", new String[0]);
    public static final ParseField MEMORY_STATUS_FIELD = new ParseField("memory_status", new String[0]);
    public static final ParseField CATEGORIZED_DOC_COUNT_FIELD = new ParseField("categorized_doc_count", new String[0]);
    public static final ParseField TOTAL_CATEGORY_COUNT_FIELD = new ParseField("total_category_count", new String[0]);
    public static final ParseField FREQUENT_CATEGORY_COUNT_FIELD = new ParseField("frequent_category_count", new String[0]);
    public static final ParseField RARE_CATEGORY_COUNT_FIELD = new ParseField("rare_category_count", new String[0]);
    public static final ParseField DEAD_CATEGORY_COUNT_FIELD = new ParseField("dead_category_count", new String[0]);
    public static final ParseField FAILED_CATEGORY_COUNT_FIELD = new ParseField("failed_category_count", new String[0]);
    public static final ParseField CATEGORIZATION_STATUS_FIELD = new ParseField("categorization_status", new String[0]);
    public static final ParseField LOG_TIME_FIELD = new ParseField("log_time", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp", new String[0]);
    public static final ConstructingObjectParser<Builder, Void> PARSER = new ConstructingObjectParser("model_size_stats", true, a -> new Builder((String)a[0]));
    private final String jobId;
    private final long modelBytes;
    private final Long peakModelBytes;
    private final Long modelBytesExceeded;
    private final Long modelBytesMemoryLimit;
    private final long totalByFieldCount;
    private final long totalOverFieldCount;
    private final long totalPartitionFieldCount;
    private final long bucketAllocationFailuresCount;
    private final MemoryStatus memoryStatus;
    private final long categorizedDocCount;
    private final long totalCategoryCount;
    private final long frequentCategoryCount;
    private final long rareCategoryCount;
    private final long deadCategoryCount;
    private final long failedCategoryCount;
    private final CategorizationStatus categorizationStatus;
    private final Date timestamp;
    private final Date logTime;

    private ModelSizeStats(String jobId, long modelBytes, Long peakModelBytes, Long modelBytesExceeded, Long modelBytesMemoryLimit, long totalByFieldCount, long totalOverFieldCount, long totalPartitionFieldCount, long bucketAllocationFailuresCount, MemoryStatus memoryStatus, long categorizedDocCount, long totalCategoryCount, long frequentCategoryCount, long rareCategoryCount, long deadCategoryCount, long failedCategoryCount, CategorizationStatus categorizationStatus, Date timestamp, Date logTime) {
        this.jobId = jobId;
        this.modelBytes = modelBytes;
        this.peakModelBytes = peakModelBytes;
        this.modelBytesExceeded = modelBytesExceeded;
        this.modelBytesMemoryLimit = modelBytesMemoryLimit;
        this.totalByFieldCount = totalByFieldCount;
        this.totalOverFieldCount = totalOverFieldCount;
        this.totalPartitionFieldCount = totalPartitionFieldCount;
        this.bucketAllocationFailuresCount = bucketAllocationFailuresCount;
        this.memoryStatus = memoryStatus;
        this.categorizedDocCount = categorizedDocCount;
        this.totalCategoryCount = totalCategoryCount;
        this.frequentCategoryCount = frequentCategoryCount;
        this.rareCategoryCount = rareCategoryCount;
        this.deadCategoryCount = deadCategoryCount;
        this.failedCategoryCount = failedCategoryCount;
        this.categorizationStatus = categorizationStatus;
        this.timestamp = timestamp;
        this.logTime = logTime;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(MODEL_BYTES_FIELD.getPreferredName(), this.modelBytes);
        if (this.peakModelBytes != null) {
            builder.field(PEAK_MODEL_BYTES_FIELD.getPreferredName(), this.peakModelBytes);
        }
        if (this.modelBytesExceeded != null) {
            builder.field(MODEL_BYTES_EXCEEDED_FIELD.getPreferredName(), this.modelBytesExceeded);
        }
        if (this.modelBytesMemoryLimit != null) {
            builder.field(MODEL_BYTES_MEMORY_LIMIT_FIELD.getPreferredName(), this.modelBytesMemoryLimit);
        }
        builder.field(TOTAL_BY_FIELD_COUNT_FIELD.getPreferredName(), this.totalByFieldCount);
        builder.field(TOTAL_OVER_FIELD_COUNT_FIELD.getPreferredName(), this.totalOverFieldCount);
        builder.field(TOTAL_PARTITION_FIELD_COUNT_FIELD.getPreferredName(), this.totalPartitionFieldCount);
        builder.field(BUCKET_ALLOCATION_FAILURES_COUNT_FIELD.getPreferredName(), this.bucketAllocationFailuresCount);
        builder.field(MEMORY_STATUS_FIELD.getPreferredName(), (Object)this.memoryStatus);
        builder.field(CATEGORIZED_DOC_COUNT_FIELD.getPreferredName(), this.categorizedDocCount);
        builder.field(TOTAL_CATEGORY_COUNT_FIELD.getPreferredName(), this.totalCategoryCount);
        builder.field(FREQUENT_CATEGORY_COUNT_FIELD.getPreferredName(), this.frequentCategoryCount);
        builder.field(RARE_CATEGORY_COUNT_FIELD.getPreferredName(), this.rareCategoryCount);
        builder.field(DEAD_CATEGORY_COUNT_FIELD.getPreferredName(), this.deadCategoryCount);
        builder.field(FAILED_CATEGORY_COUNT_FIELD.getPreferredName(), this.failedCategoryCount);
        builder.field(CATEGORIZATION_STATUS_FIELD.getPreferredName(), (Object)this.categorizationStatus);
        builder.timeField(LOG_TIME_FIELD.getPreferredName(), LOG_TIME_FIELD.getPreferredName() + "_string", this.logTime.getTime());
        if (this.timestamp != null) {
            builder.timeField(TIMESTAMP_FIELD.getPreferredName(), TIMESTAMP_FIELD.getPreferredName() + "_string", this.timestamp.getTime());
        }
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getModelBytes() {
        return this.modelBytes;
    }

    public Long getPeakModelBytes() {
        return this.peakModelBytes;
    }

    public Long getModelBytesExceeded() {
        return this.modelBytesExceeded;
    }

    public Long getModelBytesMemoryLimit() {
        return this.modelBytesMemoryLimit;
    }

    public long getTotalByFieldCount() {
        return this.totalByFieldCount;
    }

    public long getTotalPartitionFieldCount() {
        return this.totalPartitionFieldCount;
    }

    public long getTotalOverFieldCount() {
        return this.totalOverFieldCount;
    }

    public long getBucketAllocationFailuresCount() {
        return this.bucketAllocationFailuresCount;
    }

    public MemoryStatus getMemoryStatus() {
        return this.memoryStatus;
    }

    public long getCategorizedDocCount() {
        return this.categorizedDocCount;
    }

    public long getTotalCategoryCount() {
        return this.totalCategoryCount;
    }

    public long getFrequentCategoryCount() {
        return this.frequentCategoryCount;
    }

    public long getRareCategoryCount() {
        return this.rareCategoryCount;
    }

    public long getDeadCategoryCount() {
        return this.deadCategoryCount;
    }

    public long getFailedCategoryCount() {
        return this.failedCategoryCount;
    }

    public CategorizationStatus getCategorizationStatus() {
        return this.categorizationStatus;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.modelBytes, this.peakModelBytes, this.modelBytesExceeded, this.modelBytesMemoryLimit, this.totalByFieldCount, this.totalOverFieldCount, this.totalPartitionFieldCount, this.bucketAllocationFailuresCount, this.memoryStatus, this.categorizedDocCount, this.totalCategoryCount, this.frequentCategoryCount, this.rareCategoryCount, this.deadCategoryCount, this.failedCategoryCount, this.categorizationStatus, this.timestamp, this.logTime});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ModelSizeStats that = (ModelSizeStats)other;
        return this.modelBytes == that.modelBytes && Objects.equals(this.peakModelBytes, that.peakModelBytes) && Objects.equals(this.modelBytesExceeded, that.modelBytesExceeded) && Objects.equals(this.modelBytesMemoryLimit, that.modelBytesMemoryLimit) && this.totalByFieldCount == that.totalByFieldCount && this.totalOverFieldCount == that.totalOverFieldCount && this.totalPartitionFieldCount == that.totalPartitionFieldCount && this.bucketAllocationFailuresCount == that.bucketAllocationFailuresCount && Objects.equals((Object)this.memoryStatus, (Object)that.memoryStatus) && this.categorizedDocCount == that.categorizedDocCount && this.totalCategoryCount == that.totalCategoryCount && this.frequentCategoryCount == that.frequentCategoryCount && this.rareCategoryCount == that.rareCategoryCount && this.deadCategoryCount == that.deadCategoryCount && this.failedCategoryCount == that.failedCategoryCount && Objects.equals((Object)this.categorizationStatus, (Object)that.categorizationStatus) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.logTime, that.logTime) && Objects.equals(this.jobId, that.jobId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareLong(Builder::setModelBytes, MODEL_BYTES_FIELD);
        PARSER.declareLong(Builder::setPeakModelBytes, PEAK_MODEL_BYTES_FIELD);
        PARSER.declareLong(Builder::setModelBytesExceeded, MODEL_BYTES_EXCEEDED_FIELD);
        PARSER.declareLong(Builder::setModelBytesMemoryLimit, MODEL_BYTES_MEMORY_LIMIT_FIELD);
        PARSER.declareLong(Builder::setBucketAllocationFailuresCount, BUCKET_ALLOCATION_FAILURES_COUNT_FIELD);
        PARSER.declareLong(Builder::setTotalByFieldCount, TOTAL_BY_FIELD_COUNT_FIELD);
        PARSER.declareLong(Builder::setTotalOverFieldCount, TOTAL_OVER_FIELD_COUNT_FIELD);
        PARSER.declareLong(Builder::setTotalPartitionFieldCount, TOTAL_PARTITION_FIELD_COUNT_FIELD);
        PARSER.declareField(Builder::setMemoryStatus, p -> MemoryStatus.fromString(p.text()), MEMORY_STATUS_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareLong(Builder::setCategorizedDocCount, CATEGORIZED_DOC_COUNT_FIELD);
        PARSER.declareLong(Builder::setTotalCategoryCount, TOTAL_CATEGORY_COUNT_FIELD);
        PARSER.declareLong(Builder::setFrequentCategoryCount, FREQUENT_CATEGORY_COUNT_FIELD);
        PARSER.declareLong(Builder::setRareCategoryCount, RARE_CATEGORY_COUNT_FIELD);
        PARSER.declareLong(Builder::setDeadCategoryCount, DEAD_CATEGORY_COUNT_FIELD);
        PARSER.declareLong(Builder::setFailedCategoryCount, FAILED_CATEGORY_COUNT_FIELD);
        PARSER.declareField(Builder::setCategorizationStatus, p -> CategorizationStatus.fromString(p.text()), CATEGORIZATION_STATUS_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(Builder::setLogTime, p -> TimeUtil.parseTimeField(p, LOG_TIME_FIELD.getPreferredName()), LOG_TIME_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setTimestamp, p -> TimeUtil.parseTimeField(p, TIMESTAMP_FIELD.getPreferredName()), TIMESTAMP_FIELD, ObjectParser.ValueType.VALUE);
    }

    public static enum MemoryStatus {
        OK,
        SOFT_LIMIT,
        HARD_LIMIT;


        public static MemoryStatus fromString(String statusName) {
            return MemoryStatus.valueOf(statusName.trim().toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum CategorizationStatus {
        OK,
        WARN;


        public static CategorizationStatus fromString(String statusName) {
            return CategorizationStatus.valueOf(statusName.trim().toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private final String jobId;
        private long modelBytes;
        private Long peakModelBytes;
        private Long modelBytesExceeded;
        private Long modelBytesMemoryLimit;
        private long totalByFieldCount;
        private long totalOverFieldCount;
        private long totalPartitionFieldCount;
        private long bucketAllocationFailuresCount;
        private MemoryStatus memoryStatus;
        private long categorizedDocCount;
        private long totalCategoryCount;
        private long frequentCategoryCount;
        private long rareCategoryCount;
        private long deadCategoryCount;
        private long failedCategoryCount;
        private CategorizationStatus categorizationStatus;
        private Date timestamp;
        private Date logTime;

        public Builder(String jobId) {
            this.jobId = jobId;
            this.memoryStatus = MemoryStatus.OK;
            this.categorizationStatus = CategorizationStatus.OK;
            this.logTime = new Date();
        }

        public Builder(ModelSizeStats modelSizeStats) {
            this.jobId = modelSizeStats.jobId;
            this.modelBytes = modelSizeStats.modelBytes;
            this.peakModelBytes = modelSizeStats.peakModelBytes;
            this.modelBytesExceeded = modelSizeStats.modelBytesExceeded;
            this.modelBytesMemoryLimit = modelSizeStats.modelBytesMemoryLimit;
            this.totalByFieldCount = modelSizeStats.totalByFieldCount;
            this.totalOverFieldCount = modelSizeStats.totalOverFieldCount;
            this.totalPartitionFieldCount = modelSizeStats.totalPartitionFieldCount;
            this.bucketAllocationFailuresCount = modelSizeStats.bucketAllocationFailuresCount;
            this.memoryStatus = modelSizeStats.memoryStatus;
            this.categorizedDocCount = modelSizeStats.categorizedDocCount;
            this.totalCategoryCount = modelSizeStats.totalCategoryCount;
            this.frequentCategoryCount = modelSizeStats.frequentCategoryCount;
            this.rareCategoryCount = modelSizeStats.rareCategoryCount;
            this.deadCategoryCount = modelSizeStats.deadCategoryCount;
            this.failedCategoryCount = modelSizeStats.failedCategoryCount;
            this.categorizationStatus = modelSizeStats.categorizationStatus;
            this.timestamp = modelSizeStats.timestamp;
            this.logTime = modelSizeStats.logTime;
        }

        public Builder setModelBytes(long modelBytes) {
            this.modelBytes = modelBytes;
            return this;
        }

        public Builder setPeakModelBytes(long peakModelBytes) {
            this.peakModelBytes = peakModelBytes;
            return this;
        }

        public Builder setModelBytesExceeded(long modelBytesExceeded) {
            this.modelBytesExceeded = modelBytesExceeded;
            return this;
        }

        public Builder setModelBytesMemoryLimit(long modelBytesMemoryLimit) {
            this.modelBytesMemoryLimit = modelBytesMemoryLimit;
            return this;
        }

        public Builder setTotalByFieldCount(long totalByFieldCount) {
            this.totalByFieldCount = totalByFieldCount;
            return this;
        }

        public Builder setTotalPartitionFieldCount(long totalPartitionFieldCount) {
            this.totalPartitionFieldCount = totalPartitionFieldCount;
            return this;
        }

        public Builder setTotalOverFieldCount(long totalOverFieldCount) {
            this.totalOverFieldCount = totalOverFieldCount;
            return this;
        }

        public Builder setBucketAllocationFailuresCount(long bucketAllocationFailuresCount) {
            this.bucketAllocationFailuresCount = bucketAllocationFailuresCount;
            return this;
        }

        public Builder setMemoryStatus(MemoryStatus memoryStatus) {
            Objects.requireNonNull(memoryStatus, "[" + MEMORY_STATUS_FIELD.getPreferredName() + "] must not be null");
            this.memoryStatus = memoryStatus;
            return this;
        }

        public Builder setCategorizedDocCount(long categorizedDocCount) {
            this.categorizedDocCount = categorizedDocCount;
            return this;
        }

        public Builder setTotalCategoryCount(long totalCategoryCount) {
            this.totalCategoryCount = totalCategoryCount;
            return this;
        }

        public Builder setFrequentCategoryCount(long frequentCategoryCount) {
            this.frequentCategoryCount = frequentCategoryCount;
            return this;
        }

        public Builder setRareCategoryCount(long rareCategoryCount) {
            this.rareCategoryCount = rareCategoryCount;
            return this;
        }

        public Builder setDeadCategoryCount(long deadCategoryCount) {
            this.deadCategoryCount = deadCategoryCount;
            return this;
        }

        public Builder setFailedCategoryCount(long failedCategoryCount) {
            this.failedCategoryCount = failedCategoryCount;
            return this;
        }

        public Builder setCategorizationStatus(CategorizationStatus categorizationStatus) {
            Objects.requireNonNull(categorizationStatus, "[" + CATEGORIZATION_STATUS_FIELD.getPreferredName() + "] must not be null");
            this.categorizationStatus = categorizationStatus;
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setLogTime(Date logTime) {
            this.logTime = logTime;
            return this;
        }

        public ModelSizeStats build() {
            return new ModelSizeStats(this.jobId, this.modelBytes, this.peakModelBytes, this.modelBytesExceeded, this.modelBytesMemoryLimit, this.totalByFieldCount, this.totalOverFieldCount, this.totalPartitionFieldCount, this.bucketAllocationFailuresCount, this.memoryStatus, this.categorizedDocCount, this.totalCategoryCount, this.frequentCategoryCount, this.rareCategoryCount, this.deadCategoryCount, this.failedCategoryCount, this.categorizationStatus, this.timestamp, this.logTime);
        }
    }
}

