/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.eventsourcing.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.ACLDiffDTO;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.ACLUpdated;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.MailboxAggregateId;

class ACLUpdatedDTO
implements EventDTO {
    private final int eventId;
    private final String aggregateKey;
    private final String type;
    private final ACLDiffDTO aclDiff;

    static ACLUpdatedDTO from(ACLUpdated event, String type) {
        Preconditions.checkNotNull((Object)event);
        return new ACLUpdatedDTO(event.eventId().serialize(), event.getAggregateId().asAggregateKey(), type, ACLDiffDTO.fromACLDiff(event.getAclDiff()));
    }

    static ACLUpdatedDTO from(ACLUpdated event) {
        return ACLUpdatedDTO.from(event, "acl-updated");
    }

    @JsonCreator
    ACLUpdatedDTO(@JsonProperty(value="eventId") int eventId, @JsonProperty(value="aggregateKey") String aggregateKey, @JsonProperty(value="type") String type, @JsonProperty(value="aclDiff") ACLDiffDTO aclDiff) {
        this.eventId = eventId;
        this.aggregateKey = aggregateKey;
        this.type = type;
        this.aclDiff = aclDiff;
    }

    @JsonIgnore
    public ACLUpdated toEvent() {
        return new ACLUpdated(new MailboxAggregateId(CassandraId.of(this.aggregateKey)), EventId.fromSerialized((int)this.eventId), this.aclDiff.asACLDiff());
    }

    public int getEventId() {
        return this.eventId;
    }

    public String getAggregateKey() {
        return this.aggregateKey;
    }

    public String getType() {
        return this.type;
    }

    public ACLDiffDTO getAclDiff() {
        return this.aclDiff;
    }

    public final boolean equals(Object o) {
        if (o instanceof ACLUpdatedDTO) {
            ACLUpdatedDTO that = (ACLUpdatedDTO)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.aggregateKey, that.aggregateKey) && Objects.equals(this.type, that.type) && Objects.equals(this.aclDiff, that.aclDiff);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.eventId, this.aggregateKey, this.type, this.aclDiff);
    }
}

