/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.PeriodicalHealthChecksConfiguration;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.lifecycle.api.Startable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class PeriodicalHealthChecks
implements Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicalHealthChecks.class);
    private final Set<HealthCheck> healthChecks;
    private final Scheduler scheduler;
    private final PeriodicalHealthChecksConfiguration configuration;
    private Disposable disposable;

    @Inject
    PeriodicalHealthChecks(Set<HealthCheck> healthChecks, PeriodicalHealthChecksConfiguration configuration) {
        this.healthChecks = healthChecks;
        this.scheduler = Schedulers.elastic();
        this.configuration = configuration;
    }

    PeriodicalHealthChecks(Set<HealthCheck> healthChecks, Scheduler scheduler, PeriodicalHealthChecksConfiguration configuration) {
        this.healthChecks = healthChecks;
        this.scheduler = scheduler;
        this.configuration = configuration;
    }

    public void start() {
        this.disposable = Flux.interval((Duration)this.configuration.getPeriod(), (Scheduler)this.scheduler).flatMapIterable(any -> this.healthChecks).flatMap(healthCheck -> Mono.from((Publisher)healthCheck.check()).timeout(this.configuration.getPeriod()).onErrorResume(TimeoutException.class, e -> Mono.just((Object)Result.unhealthy((ComponentName)healthCheck.componentName(), (String)e.getMessage()))), 16).doOnNext(this::logResult).onErrorContinue(this::logError).subscribeOn(Schedulers.elastic()).subscribe();
    }

    @PreDestroy
    public void stop() {
        this.disposable.dispose();
    }

    private void logResult(Result result) {
        switch (result.getStatus()) {
            case HEALTHY: {
                break;
            }
            case DEGRADED: {
                LOGGER.warn("DEGRADED: {} : {}", (Object)result.getComponentName().getName(), (Object)result.getCause().orElse(""));
                break;
            }
            case UNHEALTHY: {
                this.logUnhealthy(result);
            }
        }
    }

    private void logUnhealthy(Result result) {
        result.getError().ifPresentOrElse(e -> LOGGER.error("UNHEALTHY: {} : {}", new Object[]{result.getComponentName().getName(), result.getCause().orElse(""), e}), () -> LOGGER.error("UNHEALTHY: {} : {}", (Object)result.getComponentName().getName(), (Object)result.getCause().orElse("")));
    }

    private void logError(Throwable error, Object triggeringValue) {
        if (triggeringValue instanceof Result) {
            Result result = (Result)triggeringValue;
            LOGGER.error("HealthCheck error for: {}, Cause: {}", (Object)result.getComponentName(), (Object)error);
            return;
        }
        LOGGER.error("HealthCheck error. Triggering value: {}, Cause: ", triggeringValue, (Object)error);
    }
}

