/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.json.EmailGetSerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailBodyPart$;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailGetResponse;
import org.apache.james.jmap.mail.EmailIds;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.EmailViewReaderFactory;
import org.apache.james.jmap.mail.SpecificHeaderRequest$;
import org.apache.james.jmap.mail.UnparsedEmailId;
import org.apache.james.jmap.method.EmailGetMethod$;
import org.apache.james.jmap.method.EmailGetResults;
import org.apache.james.jmap.method.EmailGetResults$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tEs!B\u000f\u001f\u0011\u0003Ic!B\u0016\u001f\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%IA\u000e\u0005\u0007{\u0005\u0001\u000b\u0011B\u001c\u0007\t-r\u0002A\u0010\u0005\t\u0011\u0016\u0011\t\u0011)A\u0005\u0013\"AA*\u0002B\u0001B\u0003%Q\n\u0003\u0005Z\u000b\t\u0015\r\u0011\"\u0001[\u0011!\u0019WA!A!\u0002\u0013Y\u0006\u0002\u00033\u0006\u0005\u000b\u0007I\u0011A3\t\u00115,!\u0011!Q\u0001\n\u0019D\u0001B\\\u0003\u0003\u0006\u0004%\ta\u001c\u0005\tm\u0016\u0011\t\u0011)A\u0005a\")1'\u0002C\u0001o\"I\u0011qB\u0003C\u0002\u0013\u0005\u0013\u0011\u0003\u0005\t\u0003\u007f)\u0001\u0015!\u0003\u0002\u0014!I\u0011\u0011I\u0003C\u0002\u0013\u0005\u00131\t\u0005\t\u0003G*\u0001\u0015!\u0003\u0002F!9\u0011QM\u0003\u0005B\u0005\u001d\u0004bBAN\u000b\u0011\u0005\u0013Q\u0014\u0005\b\u0003\u0007,A\u0011BAc\u0011\u001d\t\t.\u0002C\u0005\u0003'Dq!a8\u0006\t\u0013\t\t\u000fC\u0004\u0002f\u0016!I!a:\t\u000f\u0005]X\u0001\"\u0003\u0002z\"9\u0011Q]\u0003\u0005\n\t\u001d\u0001b\u0002B\u0010\u000b\u0011%!\u0011\u0005\u0005\b\u0005w)A\u0011\u0002B\u001f\u00039)U.Y5m\u000f\u0016$X*\u001a;i_\u0012T!a\b\u0011\u0002\r5,G\u000f[8e\u0015\t\t#%\u0001\u0003k[\u0006\u0004(BA\u0012%\u0003\u0015Q\u0017-\\3t\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001A\u0011!&A\u0007\u0002=\tqQ)\\1jY\u001e+G/T3uQ>$7CA\u0001.!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!K\u0001\u0007Y><w-\u001a:\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0014\u0002\u000bMdg\r\u000e6\n\u0005qJ$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0014\u0007\u0015is\bE\u0002+\u0001\nK!!\u0011\u0010\u000315+G\u000f[8e%\u0016\fX/\u001b:j]\u001e\f5mY8v]RLE\r\u0005\u0002D\r6\tAI\u0003\u0002FA\u0005!Q.Y5m\u0013\t9EIA\bF[\u0006LGnR3u%\u0016\fX/Z:u\u00035\u0011X-\u00193fe\u001a\u000b7\r^8ssB\u00111IS\u0005\u0003\u0017\u0012\u0013a#R7bS24\u0016.Z<SK\u0006$WM\u001d$bGR|'/_\u0001\u0011[\u0016\u001c8/Y4f\u0013\u00124\u0015m\u0019;pef\u0004\"A\u0014,\u000f\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016!B7pI\u0016d'BA*#\u0003\u001di\u0017-\u001b7c_bL!!\u0016)\u0002\u00135+7o]1hK&#\u0017BA,Y\u0005\u001d1\u0015m\u0019;pefT!!\u0016)\u0002\u001b5,GO]5d\r\u0006\u001cGo\u001c:z+\u0005Y\u0006C\u0001/b\u001b\u0005i&B\u00010`\u0003\r\t\u0007/\u001b\u0006\u0003A\n\nq!\\3ue&\u001c7/\u0003\u0002c;\niQ*\u001a;sS\u000e4\u0015m\u0019;pef\fa\"\\3ue&\u001cg)Y2u_JL\b%A\u000bf[\u0006LGn\u00195b]\u001e,'+\u001a9pg&$xN]=\u0016\u0003\u0019\u0004\"aZ6\u000e\u0003!T!!\u001b6\u0002\r\rD\u0017M\\4f\u0015\tq\u0006%\u0003\u0002mQ\n)R)\\1jY\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\u0018AF3nC&d7\r[1oO\u0016\u0014V\r]8tSR|'/\u001f\u0011\u0002\u001fM,7o]5p]N+\b\u000f\u001d7jKJ,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g\u0002\naA]8vi\u0016\u001c\u0018BA;s\u0005=\u0019Vm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001E:fgNLwN\\*vaBd\u0017.\u001a:!)\u0019A\u0018P_>}{B\u0011!&\u0002\u0005\u0006\u0011:\u0001\r!\u0013\u0005\u0006\u0019:\u0001\r!\u0014\u0005\u00063:\u0001\ra\u0017\u0005\u0006I:\u0001\rA\u001a\u0005\u0006]:\u0001\r\u0001\u001d\u0015\u0003\u001d}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003\u0013\tQA[1wCbLA!!\u0004\u0002\u0004\t1\u0011J\u001c6fGR\f!\"\\3uQ>$g*Y7f+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005eb\u0002BA\f\u0003gqA!!\u0007\u000209!\u00111DA\u0017\u001d\u0011\ti\"a\u000b\u000f\t\u0005}\u0011\u0011\u0006\b\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0015\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0013BA\u0013'\u0013\t\u0019C%\u0003\u0002\"E%\u0019\u0011\u0011\u0007\u0011\u0002\t\r|'/Z\u0005\u0005\u0003k\t9$\u0001\u0006J]Z|7-\u0019;j_:T1!!\r!\u0013\u0011\tY$!\u0010\u0003\u00155+G\u000f[8e\u001d\u0006lWM\u0003\u0003\u00026\u0005]\u0012aC7fi\"|GMT1nK\u0002\nAC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cXCAA#!\u0019\t9%a\u0014\u0002V9!\u0011\u0011JA&!\r\t\tcL\u0005\u0004\u0003\u001bz\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002R\u0005M#aA*fi*\u0019\u0011QJ\u0018\u0011\t\u0005]\u0013Q\f\b\u0005\u0003/\tI&\u0003\u0003\u0002\\\u0005]\u0012\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'/\u0003\u0003\u0002`\u0005\u0005$\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'O\u0003\u0003\u0002\\\u0005]\u0012!\u0006:fcVL'/\u001a3DCB\f'-\u001b7ji&,7\u000fI\u0001\nI>\u0004&o\\2fgN$\"\"!\u001b\u0002\u0004\u0006\u001d\u00151RAL!\u0019\tY'!\u001f\u0002~5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0005qk\nd\u0017n\u001d5fe*\u0019\u0001'a\u001d\u000b\t\u0005E\u0012Q\u000f\u0006\u0003\u0003o\nqA]3bGR|'/\u0003\u0003\u0002|\u00055$!B*N_:|\u0007c\u0001\u0016\u0002\u0000%\u0019\u0011\u0011\u0011\u0010\u0003+%sgo\\2bi&|gnV5uQ\u000e{g\u000e^3yi\"9\u0011QQ\nA\u0002\u0005\u0015\u0013\u0001D2ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\bbBAE'\u0001\u0007\u0011QP\u0001\u000bS:4xnY1uS>t\u0007bBAG'\u0001\u0007\u0011qR\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\u0011\t\t*a%\u000e\u0003IK1!!&S\u00059i\u0015-\u001b7c_b\u001cVm]:j_:Da!!'\u0014\u0001\u0004\u0011\u0015a\u0002:fcV,7\u000f^\u0001\u000bO\u0016$(+Z9vKN$HCBAP\u0003o\u000bI\fE\u0004\u0002\"\u0006-\u0016\u0011\u0017\"\u000f\t\u0005\r\u0016q\u0015\b\u0005\u0003C\t)+C\u00011\u0013\r\tIkL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti+a,\u0003\r\u0015KG\u000f[3s\u0015\r\tIk\f\t\u0005\u0003C\u000b\u0019,\u0003\u0003\u00026\u0006=&\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]\"9\u0011Q\u0012\u000bA\u0002\u0005=\u0005bBAE)\u0001\u0007\u00111\u0018\t\u0005\u0003{\u000by,\u0004\u0002\u00028%!\u0011\u0011YA\u001c\u0005)IeN^8dCRLwN\\\u0001\u001aG>l\u0007/\u001e;f%\u0016\u001c\bo\u001c8tK&sgo\\2bi&|g\u000e\u0006\u0006\u0002H\u0006%\u00171ZAg\u0003\u001f\u0004b!a\u001b\u0002z\u0005m\u0006bBAC+\u0001\u0007\u0011Q\t\u0005\u0007\u00033+\u0002\u0019\u0001\"\t\u000f\u0005%U\u00031\u0001\u0002<\"9\u0011QR\u000bA\u0002\u0005=\u0015A\u0005<bY&$\u0017\r^3Qe>\u0004XM\u001d;jKN$B!!6\u0002^BA\u0011\u0011UAV\u0003c\u000b9\u000e\u0005\u0003\u0002>\u0006e\u0017\u0002BAn\u0003o\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019\tIJ\u0006a\u0001\u0005\u00061b/\u00197jI\u0006$XMQ8esB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002V\u0006\r\bBBAM/\u0001\u0007!)A\u0005hKR,U.Y5mgRA\u0011\u0011^Ay\u0003g\f)\u0010\u0005\u0004\u0002l\u0005e\u00141\u001e\t\u0004\u0007\u00065\u0018bAAx\t\n\u0001R)\\1jY\u001e+GOU3ta>t7/\u001a\u0005\b\u0003\u000bC\u0002\u0019AA#\u0011\u0019\tI\n\u0007a\u0001\u0005\"9\u0011Q\u0012\rA\u0002\u0005=\u0015!\u0004:fiJLWM^3Ti\u0006$X\r\u0006\u0004\u0002|\n\r!Q\u0001\t\u0007\u0003W\nI(!@\u0011\u0007\u001d\fy0C\u0002\u0003\u0002!\u0014Qa\u0015;bi\u0016Dq!!\"\u001a\u0001\u0004\t)\u0005C\u0004\u0002\u000ef\u0001\r!a$\u0015\u0011\t%!\u0011\u0003B\u000e\u0005;\u0001b!a\u001b\u0002z\t-\u0001c\u0001\u0016\u0003\u000e%\u0019!q\u0002\u0010\u0003\u001f\u0015k\u0017-\u001b7HKR\u0014Vm];miNDqAa\u0005\u001b\u0001\u0004\u0011)\"A\u0002jIN\u00042a\u0011B\f\u0013\r\u0011I\u0002\u0012\u0002\t\u000b6\f\u0017\u000e\\%eg\"9\u0011Q\u0012\u000eA\u0002\u0005=\u0005BBAM5\u0001\u0007!)A\u0006bg6+7o]1hK&#G\u0003\u0002B\u0012\u0005o\u0001\u0002\"!)\u0002,\n\u0015\"\u0011\u0007\t\b]\t\u001d\"1FAY\u0013\r\u0011Ic\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\r\u0013i#C\u0002\u00030\u0011\u0013q\"\u00168qCJ\u001cX\rZ#nC&d\u0017\n\u001a\t\u0004\u001f\nM\u0012b\u0001B\u001b!\nIQ*Z:tC\u001e,\u0017\n\u001a\u0005\b\u0005sY\u0002\u0019\u0001B\u0016\u0003\tIG-\u0001\bsKR\u0014\u0018.\u001a<f\u000b6\f\u0017\u000e\\:\u0015\u0011\t}\"Q\tB'\u0005\u001f\u0002b!a\u001b\u0003B\t-\u0011\u0002\u0002B\"\u0003[\u0012Qa\u0015$mkbDqAa\u0005\u001d\u0001\u0004\u00119\u0005\u0005\u0004\u0002\"\n%#\u0011G\u0005\u0005\u0005\u0017\nyKA\u0002TKFDq!!$\u001d\u0001\u0004\ty\t\u0003\u0004\u0002\u001ar\u0001\rA\u0011")
public class EmailGetMethod
implements MethodRequiringAccountId<EmailGetRequest> {
    private final EmailViewReaderFactory readerFactory;
    private final MessageId.Factory messageIdFactory;
    private final MetricFactory metricFactory;
    private final EmailChangeRepository emailchangeRepository;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public EmailChangeRepository emailchangeRepository() {
        return this.emailchangeRepository;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, EmailGetRequest request) {
        return this.computeResponseInvocation(capabilities, request, invocation.invocation(), mailboxSession).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return SMono$.MODULE$.error(throwable2);
            }
            throw new MatchError((Object)throwable);
        }).map((Function1 & Serializable)invocationResult -> new InvocationWithContext((Invocation)invocationResult, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, EmailGetRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        JsResult<EmailGetRequest> jsResult = EmailGetSerializer$.MODULE$.deserializeEmailGetRequest((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            EmailGetRequest emailGetRequest = (EmailGetRequest)jsSuccess.value();
            return package$.MODULE$.Right().apply((Object)emailGetRequest);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            return package$.MODULE$.Left().apply((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        }
        throw new MatchError(jsResult);
    }

    private SMono<Invocation> computeResponseInvocation(Set<Refined<String, string.Uri>> capabilities, EmailGetRequest request, Invocation invocation, MailboxSession mailboxSession) {
        return (SMono)this.validateProperties(request).flatMap((Function1 & Serializable)properties -> this.validateBodyProperties(request).map((Function1 & Serializable)x$1 -> new Tuple2(properties, x$1))).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Properties properties = (Properties)tuple2._1();
                Properties bodyProperties = (Properties)tuple2._2();
                return this.getEmails(capabilities, request, mailboxSession).map((Function1 & Serializable)response -> new Invocation(this.methodName(), (JsObject)EmailGetSerializer$.MODULE$.serialize((EmailGetResponse)response, properties, bodyProperties).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.methodCallId()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Either<IllegalArgumentException, Properties> validateProperties(EmailGetRequest request) {
        Option<Properties> option = request.properties();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)Email$.MODULE$.defaultProperties());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Properties properties = (Properties)some.value();
            Set invalidProperties = (Set)((SetOps)properties.value().flatMap((Function1 & Serializable)property -> EmailGetMethod.$anonfun$validateProperties$1((String)((Refined)property).value()))).$minus$minus(Email$.MODULE$.allowedProperties().value());
            if (invalidProperties.nonEmpty()) {
                return package$.MODULE$.Left().apply((Object)new IllegalArgumentException(new StringBuilder(41).append("The following properties [").append(((IterableOnceOps)invalidProperties.map((Function1 & Serializable)p -> (String)((Refined)p).value())).mkString(", ")).append("] do not exist.").toString()));
            }
            return package$.MODULE$.Right().apply((Object)properties.$plus$plus(Email$.MODULE$.idProperty()));
        }
        throw new MatchError(option);
    }

    private Either<IllegalArgumentException, Properties> validateBodyProperties(EmailGetRequest request) {
        Option<Properties> option = request.bodyProperties();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)EmailBodyPart$.MODULE$.defaultProperties());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Properties properties = (Properties)some.value();
            Properties invalidProperties = properties.$minus$minus(EmailBodyPart$.MODULE$.allowedProperties());
            if (invalidProperties.isEmpty()) {
                return package$.MODULE$.Right().apply((Object)properties);
            }
            return package$.MODULE$.Left().apply((Object)new IllegalArgumentException(new StringBuilder(45).append("The following bodyProperties [").append(invalidProperties.format()).append("] do not exist.").toString()));
        }
        throw new MatchError(option);
    }

    private SMono<EmailGetResponse> getEmails(Set<Refined<String, string.Uri>> capabilities, EmailGetRequest request, MailboxSession mailboxSession) {
        Option<EmailIds> option = request.ids();
        if (None$.MODULE$.equals(option)) {
            return SMono$.MODULE$.error((Throwable)new IllegalArgumentException("ids can not be ommited for email/get"));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            EmailIds ids = (EmailIds)some.value();
            return this.getEmails(ids, mailboxSession, request).flatMap((Function1 & Serializable)result -> this.retrieveState(capabilities, mailboxSession).map((Function1 & Serializable)state -> new EmailGetResponse(request.accountId(), UuidState$.MODULE$.fromJava((State)state), (List<EmailView>)result.emails().toList(), result.notFound())));
        }
        throw new MatchError(option);
    }

    private SMono<State> retrieveState(Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession) {
        AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
        if (capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()))) {
            return SMono$.MODULE$.apply((Publisher)this.emailchangeRepository().getLatestStateWithDelegation(accountId));
        }
        return SMono$.MODULE$.apply((Publisher)this.emailchangeRepository().getLatestState(accountId));
    }

    private SMono<EmailGetResults> getEmails(EmailIds ids, MailboxSession mailboxSession, EmailGetRequest request) {
        List parsedIds = ids.value().map((Function1 & Serializable)id -> this.asMessageId((UnparsedEmailId)id));
        List messagesIds = parsedIds.flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                MessageId messageId = (MessageId)right.value();
                return new Some((Object)messageId);
            }
            throw new MatchError((Object)either);
        });
        SFlux parsingErrors = SFlux$.MODULE$.fromIterable((Iterable)parsedIds.flatMap((Function1 & Serializable)x0$2 -> {
            Left left;
            Tuple2 tuple2;
            Either either = x0$2;
            if (either instanceof Left && (tuple2 = (Tuple2)(left = (Left)either).value()) != null) {
                UnparsedEmailId id = (UnparsedEmailId)tuple2._1();
                IllegalArgumentException error = (IllegalArgumentException)tuple2._2();
                EmailGetMethod$.MODULE$.org$apache$james$jmap$method$EmailGetMethod$$logger().warn("id parsing failed", (Throwable)error);
                return new Some((Object)EmailGetResults$.MODULE$.notFound(id));
            }
            if (either instanceof Right) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }));
        return SFlux$.MODULE$.merge((Seq)new .colon.colon(this.retrieveEmails((Seq<MessageId>)messagesIds, mailboxSession, request), (List)new .colon.colon((Object)parsingErrors, (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).reduce((Object)EmailGetResults$.MODULE$.empty(), (Function2 & Serializable)(result1, result2) -> EmailGetResults$.MODULE$.merge((EmailGetResults)result1, (EmailGetResults)result2));
    }

    private Either<Tuple2<UnparsedEmailId, IllegalArgumentException>, MessageId> asMessageId(UnparsedEmailId id) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.messageIdFactory.fromString((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)id.id()), RefType$.MODULE$.refinedRefType())));
        }
        catch (Exception e) {
            left = package$.MODULE$.Left().apply((Object)new Tuple2((Object)id, (Object)new IllegalArgumentException(e)));
        }
        return left;
    }

    private SFlux<EmailGetResults> retrieveEmails(Seq<MessageId> ids, MailboxSession mailboxSession, EmailGetRequest request) {
        SMono foundResultsMono = this.readerFactory.selectReader(request).read(ids, request, mailboxSession).collectMap((Function1 & Serializable)x$3 -> x$3.metadata().id());
        return foundResultsMono.flatMapIterable((Function1 & Serializable)foundResults -> (Seq)ids.map((Function1 & Serializable)id -> (EmailGetResults)foundResults.get(id).map((Function1 & Serializable)email -> EmailGetResults$.MODULE$.found((EmailView)email)).getOrElse((Function0 & Serializable)() -> EmailGetResults$.MODULE$.notFound((MessageId)id))));
    }

    public static final /* synthetic */ Some $anonfun$validateProperties$2(String invalidProperty) {
        return new Some((Object)new Refined((Object)invalidProperty));
    }

    public static final /* synthetic */ Option $anonfun$validateProperties$1(String property) {
        return (Option)SpecificHeaderRequest$.MODULE$.from(property).fold((Function1 & Serializable)invalidProperty -> EmailGetMethod.$anonfun$validateProperties$2((String)((Refined)invalidProperty).value()), (Function1 & Serializable)x$2 -> None$.MODULE$);
    }

    @Inject
    public EmailGetMethod(EmailViewReaderFactory readerFactory, MessageId.Factory messageIdFactory, MetricFactory metricFactory, EmailChangeRepository emailchangeRepository, SessionSupplier sessionSupplier) {
        this.readerFactory = readerFactory;
        this.messageIdFactory = messageIdFactory;
        this.metricFactory = metricFactory;
        this.emailchangeRepository = emailchangeRepository;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Email/get")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

