/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraAclModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("acl").comment("Holds mailbox ACLs").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)((Create)statement.addPartitionKey("id", DataType.timeuuid()).addColumn("acl", DataType.text())).addColumn("version", DataType.bigint())).table("aclv2").comment("Holds mailbox ACLs. This table do not rely on a JSON representation nor on LWT, contrary to the acl table it replaces.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)statement.addPartitionKey("id", DataType.timeuuid()).addClusteringColumn("key", DataType.text()).addColumn("rights", (DataType)DataType.set((DataType)DataType.text()))).table("UserMailboxACL").comment("Denormalisation table. Allow to retrieve non personal mailboxIds a user has right on").options(options -> (Create.Options)((Create.Options)options.compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.leveledStrategy())).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)statement.addPartitionKey("userName", DataType.text()).addClusteringColumn("mailboxid", DataType.timeuuid()).addColumn("rights", DataType.text())).build();
}

