/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.projections;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.jmap.cassandra.projections.table.CassandraEmailQueryViewTable;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.streams.Limit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraEmailQueryView
implements EmailQueryView {
    private static final String LIMIT_MARKER = "LIMIT_BIND_MARKER";
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement listMailboxContentBySentAt;
    private final PreparedStatement listMailboxContentByReceivedAt;
    private final PreparedStatement listMailboxContentSinceSentAt;
    private final PreparedStatement listMailboxContentSinceReceivedAt;
    private final PreparedStatement insertInLookupTable;
    private final PreparedStatement insertReceivedAt;
    private final PreparedStatement insertSentAt;
    private final PreparedStatement deleteLookupRecord;
    private final PreparedStatement deleteSentAt;
    private final PreparedStatement deleteReceivedAt;
    private final PreparedStatement deleteAllLookupRecords;
    private final PreparedStatement deleteAllSentAt;
    private final PreparedStatement deleteAllReceivedAt;
    private final PreparedStatement lookupDate;

    @Inject
    public CassandraEmailQueryView(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.listMailboxContentBySentAt = session.prepare((RegularStatement)QueryBuilder.select().from("email_query_view_sent_at").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).orderBy(new Ordering[]{QueryBuilder.desc((String)"sentAt")}).limit(QueryBuilder.bindMarker((String)LIMIT_MARKER)));
        this.listMailboxContentByReceivedAt = session.prepare((RegularStatement)QueryBuilder.select().from("email_query_view_received_at").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).orderBy(new Ordering[]{QueryBuilder.desc((String)"receivedAt")}).limit(QueryBuilder.bindMarker((String)LIMIT_MARKER)));
        this.listMailboxContentSinceSentAt = session.prepare((RegularStatement)QueryBuilder.select().from("email_query_view_sent_at").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"sentAt", (Object)QueryBuilder.bindMarker((String)"sentAt"))).orderBy(new Ordering[]{QueryBuilder.desc((String)"sentAt")}).limit(QueryBuilder.bindMarker((String)LIMIT_MARKER)));
        this.listMailboxContentSinceReceivedAt = session.prepare((RegularStatement)QueryBuilder.select().from("email_query_view_received_at").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"receivedAt", (Object)QueryBuilder.bindMarker((String)"receivedAt"))).orderBy(new Ordering[]{QueryBuilder.desc((String)"receivedAt")}));
        this.insertInLookupTable = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"email_query_view_date_lookup").value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("sentAt", (Object)QueryBuilder.bindMarker((String)"sentAt")).value("receivedAt", (Object)QueryBuilder.bindMarker((String)"receivedAt")));
        this.insertSentAt = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"email_query_view_sent_at").value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("sentAt", (Object)QueryBuilder.bindMarker((String)"sentAt")));
        this.insertReceivedAt = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"email_query_view_received_at").value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("receivedAt", (Object)QueryBuilder.bindMarker((String)"receivedAt")).value("sentAt", (Object)QueryBuilder.bindMarker((String)"sentAt")));
        this.deleteLookupRecord = session.prepare((RegularStatement)QueryBuilder.delete().from("email_query_view_date_lookup").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
        this.deleteSentAt = session.prepare((RegularStatement)QueryBuilder.delete().from("email_query_view_sent_at").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.eq((String)"sentAt", (Object)QueryBuilder.bindMarker((String)"sentAt"))));
        this.deleteReceivedAt = session.prepare((RegularStatement)QueryBuilder.delete().from("email_query_view_received_at").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.eq((String)"receivedAt", (Object)QueryBuilder.bindMarker((String)"receivedAt"))));
        this.deleteAllLookupRecords = session.prepare((RegularStatement)QueryBuilder.delete().from("email_query_view_date_lookup").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
        this.deleteAllSentAt = session.prepare((RegularStatement)QueryBuilder.delete().from("email_query_view_sent_at").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
        this.deleteAllReceivedAt = session.prepare((RegularStatement)QueryBuilder.delete().from("email_query_view_received_at").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
        this.lookupDate = session.prepare((RegularStatement)QueryBuilder.select().from("email_query_view_date_lookup").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    public Flux<MessageId> listMailboxContent(MailboxId mailboxId, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)this.listMailboxContentBySentAt.bind().setUUID("mailboxId", cassandraId.asUuid()).setInt(LIMIT_MARKER, ((Integer)limit.getLimit().get()).intValue())).map(row -> CassandraMessageId.Factory.of((UUID)row.getUUID("messageId")));
    }

    public Flux<MessageId> listMailboxContentSortedByReceivedAt(MailboxId mailboxId, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)this.listMailboxContentByReceivedAt.bind().setUUID("mailboxId", cassandraId.asUuid()).setInt(LIMIT_MARKER, ((Integer)limit.getLimit().get()).intValue())).map(row -> CassandraMessageId.Factory.of((UUID)row.getUUID("messageId")));
    }

    public Flux<MessageId> listMailboxContentSinceReceivedAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        Date sinceDate = Date.from(since.toInstant());
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)this.listMailboxContentSinceReceivedAt.bind().setUUID("mailboxId", cassandraId.asUuid()).setTimestamp("receivedAt", sinceDate)).map(row -> {
            CassandraMessageId messageId = CassandraMessageId.Factory.of((UUID)row.getUUID("messageId"));
            Date receivedAt = row.getTimestamp("receivedAt");
            Date sentAt = row.getTimestamp("sentAt");
            return new EmailQueryView.Entry((MailboxId)cassandraId, (MessageId)messageId, ZonedDateTime.ofInstant(sentAt.toInstant(), ZoneOffset.UTC), ZonedDateTime.ofInstant(receivedAt.toInstant(), ZoneOffset.UTC));
        }).sort(Comparator.comparing(EmailQueryView.Entry::getSentAt).reversed()).map(EmailQueryView.Entry::getMessageId).take((long)((Integer)limit.getLimit().get()).intValue());
    }

    public Flux<MessageId> listMailboxContentSinceReceivedAtSortedByReceivedAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        Date sinceDate = Date.from(since.toInstant());
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)this.listMailboxContentSinceReceivedAt.bind().setUUID("mailboxId", cassandraId.asUuid()).setTimestamp("receivedAt", sinceDate)).map(row -> CassandraMessageId.Factory.of((UUID)row.getUUID("messageId"))).take((long)((Integer)limit.getLimit().get()).intValue());
    }

    public Flux<MessageId> listMailboxContentSinceSentAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        Date sinceDate = Date.from(since.toInstant());
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)this.listMailboxContentSinceSentAt.bind().setUUID("mailboxId", cassandraId.asUuid()).setInt(LIMIT_MARKER, ((Integer)limit.getLimit().get()).intValue()).setTimestamp("sentAt", sinceDate)).map(row -> CassandraMessageId.Factory.of((UUID)row.getUUID(CassandraEmailQueryViewTable.MESSAGE_ID_LOWERCASE)));
    }

    public Mono<Void> delete(MailboxId mailboxId, MessageId messageId) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeSingleRow((Statement)this.lookupDate.bind().setUUID("mailboxId", cassandraId.asUuid()).setUUID("messageId", cassandraMessageId.get())).flatMap(row -> this.doDelete(cassandraMessageId, cassandraId, (Row)row));
    }

    public Mono<? extends Void> doDelete(CassandraMessageId cassandraMessageId, CassandraId cassandraId, Row row) {
        Date receivedAt = row.getTimestamp("receivedAt");
        Date sentAt = row.getTimestamp("sentAt");
        BatchStatement batchStatement = new BatchStatement();
        batchStatement.add((Statement)this.deleteLookupRecord.bind().setUUID("mailboxId", cassandraId.asUuid()).setUUID("messageId", cassandraMessageId.get()));
        batchStatement.add((Statement)this.deleteSentAt.bind().setUUID("mailboxId", cassandraId.asUuid()).setUUID("messageId", cassandraMessageId.get()).setTimestamp("sentAt", sentAt));
        batchStatement.add((Statement)this.deleteReceivedAt.bind().setUUID("mailboxId", cassandraId.asUuid()).setUUID("messageId", cassandraMessageId.get()).setTimestamp("receivedAt", receivedAt));
        return this.executor.executeVoid((Statement)batchStatement);
    }

    public Mono<Void> delete(MailboxId mailboxId) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        BatchStatement batchStatement = new BatchStatement();
        batchStatement.add((Statement)this.deleteAllLookupRecords.bind().setUUID("mailboxId", ((CassandraId)mailboxId).asUuid()));
        batchStatement.add((Statement)this.deleteAllReceivedAt.bind().setUUID("mailboxId", cassandraId.asUuid()));
        batchStatement.add((Statement)this.deleteAllSentAt.bind().setUUID("mailboxId", cassandraId.asUuid()));
        return this.executor.executeVoid((Statement)batchStatement);
    }

    public Mono<Void> save(MailboxId mailboxId, ZonedDateTime sentAt, ZonedDateTime receivedAt, MessageId messageId) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        CassandraId cassandraId = (CassandraId)mailboxId;
        Date sentAtDate = Date.from(sentAt.toInstant());
        Date receivedAtDate = Date.from(receivedAt.toInstant());
        BatchStatement batchStatement = new BatchStatement();
        batchStatement.add((Statement)this.insertInLookupTable.bind().setUUID("messageId", cassandraMessageId.get()).setUUID("mailboxId", cassandraId.asUuid()).setTimestamp("receivedAt", receivedAtDate).setTimestamp("sentAt", sentAtDate));
        batchStatement.add((Statement)this.insertSentAt.bind().setUUID("messageId", cassandraMessageId.get()).setUUID("mailboxId", cassandraId.asUuid()).setTimestamp("sentAt", sentAtDate));
        batchStatement.add((Statement)this.insertReceivedAt.bind().setUUID("messageId", cassandraMessageId.get()).setUUID("mailboxId", cassandraId.asUuid()).setTimestamp("receivedAt", receivedAtDate).setTimestamp("sentAt", sentAtDate));
        return this.executor.executeVoid((Statement)batchStatement);
    }
}

