/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class GuavaCachedJwkProvider
implements JwkProvider {
    private final Cache<String, Jwk> cache;
    private final JwkProvider provider;
    @VisibleForTesting
    static final String NULL_KID_KEY = "null-kid";

    public GuavaCachedJwkProvider(JwkProvider provider) {
        this(provider, 5L, Duration.ofMinutes(10L));
    }

    public GuavaCachedJwkProvider(JwkProvider provider, long size, long expiresIn, TimeUnit expiresUnit) {
        this(provider, size, Duration.ofSeconds(expiresUnit.toSeconds(expiresIn)));
    }

    public GuavaCachedJwkProvider(JwkProvider provider, long size, Duration expiresIn) {
        this.provider = provider;
        this.cache = CacheBuilder.newBuilder().maximumSize(size).expireAfterWrite(expiresIn).build();
    }

    @Override
    public Jwk get(final String keyId) throws JwkException {
        try {
            String cacheKey = keyId == null ? NULL_KID_KEY : keyId;
            return (Jwk)this.cache.get((Object)cacheKey, (Callable)new Callable<Jwk>(){

                @Override
                public Jwk call() throws Exception {
                    return GuavaCachedJwkProvider.this.provider.get(keyId);
                }
            });
        }
        catch (ExecutionException e) {
            throw new SigningKeyNotFoundException("Failed to get key with kid " + keyId, e);
        }
    }

    @VisibleForTesting
    JwkProvider getBaseProvider() {
        return this.provider;
    }
}

