/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.core.version.impl.VersionImpl;

public final class VersionLoader {
    public static final String VERSION_PROP_FILE_KEY = "activemq.version.property.filename";
    public static final String DEFAULT_PROP_FILE_NAME = "activemq-version.properties";
    private static String PROP_FILE_NAME;
    private static Version[] versions;

    public static Version[] getClientVersions() {
        if (versions == null) {
            throw new RuntimeException(PROP_FILE_NAME + " is not available");
        }
        return versions;
    }

    public static Version getVersion() {
        if (versions == null) {
            throw new RuntimeException(PROP_FILE_NAME + " is not available");
        }
        return versions[0];
    }

    public static String getClasspathString() {
        URL[] urls;
        StringBuffer classpath = new StringBuffer();
        ClassLoader applicationClassLoader = VersionImpl.class.getClassLoader();
        for (URL url : urls = ((URLClassLoader)applicationClassLoader).getURLs()) {
            classpath.append(url.getFile()).append("\r\n");
        }
        return classpath.toString();
    }

    private static Version[] load() {
        Properties versionProps = new Properties();
        InputStream in = VersionImpl.class.getClassLoader().getResourceAsStream(PROP_FILE_NAME);
        try {
            if (in == null) {
                ActiveMQClientLogger.LOGGER.noVersionOnClasspath(VersionLoader.getClasspathString());
                throw new RuntimeException(PROP_FILE_NAME + " is not available");
            }
            try {
                versionProps.load(in);
                String versionName = versionProps.getProperty("activemq.version.versionName");
                int majorVersion = Integer.valueOf(versionProps.getProperty("activemq.version.majorVersion"));
                int minorVersion = Integer.valueOf(versionProps.getProperty("activemq.version.minorVersion"));
                int microVersion = Integer.valueOf(versionProps.getProperty("activemq.version.microVersion"));
                int[] incrementingVersions = VersionLoader.parseCompatibleVersionList(versionProps.getProperty("activemq.version.incrementingVersion"));
                int[] compatibleVersionArray = VersionLoader.parseCompatibleVersionList(versionProps.getProperty("activemq.version.compatibleVersionList"));
                ArrayList<VersionImpl> definedVersions = new ArrayList<VersionImpl>(incrementingVersions.length);
                for (int incrementingVersion : incrementingVersions) {
                    definedVersions.add(new VersionImpl(versionName, majorVersion, minorVersion, microVersion, incrementingVersion, compatibleVersionArray));
                }
                Collections.sort(definedVersions, new Comparator<Version>(){

                    @Override
                    public int compare(Version version1, Version version2) {
                        return version2.getIncrementingVersion() - version1.getIncrementingVersion();
                    }
                });
                Version[] versionArray = definedVersions.toArray(new Version[incrementingVersions.length]);
                return versionArray;
            }
            catch (IOException e) {
                throw new RuntimeException("unable to load " + PROP_FILE_NAME, e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static int[] parseCompatibleVersionList(String property) throws IOException {
        int[] verArray = new int[]{};
        StringTokenizer tokenizer = new StringTokenizer(property, ",");
        while (tokenizer.hasMoreTokens()) {
            int cursor;
            int from = -1;
            int to = -1;
            String token = tokenizer.nextToken();
            char firstChar = token.charAt(0);
            if (firstChar == '-') {
                from = 0;
                ++cursor;
                while (cursor < token.length() && Character.isDigit(token.charAt(cursor))) {
                    ++cursor;
                }
                if (cursor > 1) {
                    to = Integer.parseInt(token.substring(1, cursor));
                }
            } else if (Character.isDigit(firstChar)) {
                for (cursor = 0; cursor < token.length() && Character.isDigit(token.charAt(cursor)); ++cursor) {
                }
                from = Integer.parseInt(token.substring(0, cursor));
                if (cursor == token.length()) {
                    to = from;
                } else if (token.charAt(cursor) == '-') {
                    to = ++cursor == token.length() ? Integer.MAX_VALUE : Integer.parseInt(token.substring(cursor));
                }
            }
            if (from == -1 || to == -1) continue;
            int[] newArray = new int[verArray.length + to - from + 1];
            System.arraycopy(verArray, 0, newArray, 0, verArray.length);
            for (int i = 0; i < to - from + 1; ++i) {
                newArray[verArray.length + i] = from + i;
            }
            verArray = newArray;
        }
        return verArray;
    }

    static {
        try {
            try {
                PROP_FILE_NAME = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(VersionLoader.VERSION_PROP_FILE_KEY);
                    }
                });
            }
            catch (Throwable e) {
                ActiveMQClientLogger.LOGGER.unableToInitVersionLoader(e);
                PROP_FILE_NAME = null;
            }
            if (PROP_FILE_NAME == null) {
                PROP_FILE_NAME = DEFAULT_PROP_FILE_NAME;
            }
            versions = VersionLoader.load();
        }
        catch (Throwable e) {
            versions = null;
            ActiveMQClientLogger.LOGGER.unableToInitVersionLoaderError(e);
        }
    }
}

