/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SearchStats
implements JsonpSerializable {
    private final long fetchCurrent;
    private final long fetchTimeInMillis;
    private final long fetchTotal;
    @Nullable
    private final Long openContexts;
    private final long queryCurrent;
    private final long queryTimeInMillis;
    private final long queryTotal;
    private final long scrollCurrent;
    private final long scrollTimeInMillis;
    private final long scrollTotal;
    private final long suggestCurrent;
    private final long suggestTimeInMillis;
    private final long suggestTotal;
    private final Map<String, SearchStats> groups;
    public static final JsonpDeserializer<SearchStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchStats::setupSearchStatsDeserializer);

    private SearchStats(Builder builder) {
        this.fetchCurrent = ApiTypeHelper.requireNonNull(builder.fetchCurrent, this, "fetchCurrent");
        this.fetchTimeInMillis = ApiTypeHelper.requireNonNull(builder.fetchTimeInMillis, this, "fetchTimeInMillis");
        this.fetchTotal = ApiTypeHelper.requireNonNull(builder.fetchTotal, this, "fetchTotal");
        this.openContexts = builder.openContexts;
        this.queryCurrent = ApiTypeHelper.requireNonNull(builder.queryCurrent, this, "queryCurrent");
        this.queryTimeInMillis = ApiTypeHelper.requireNonNull(builder.queryTimeInMillis, this, "queryTimeInMillis");
        this.queryTotal = ApiTypeHelper.requireNonNull(builder.queryTotal, this, "queryTotal");
        this.scrollCurrent = ApiTypeHelper.requireNonNull(builder.scrollCurrent, this, "scrollCurrent");
        this.scrollTimeInMillis = ApiTypeHelper.requireNonNull(builder.scrollTimeInMillis, this, "scrollTimeInMillis");
        this.scrollTotal = ApiTypeHelper.requireNonNull(builder.scrollTotal, this, "scrollTotal");
        this.suggestCurrent = ApiTypeHelper.requireNonNull(builder.suggestCurrent, this, "suggestCurrent");
        this.suggestTimeInMillis = ApiTypeHelper.requireNonNull(builder.suggestTimeInMillis, this, "suggestTimeInMillis");
        this.suggestTotal = ApiTypeHelper.requireNonNull(builder.suggestTotal, this, "suggestTotal");
        this.groups = ApiTypeHelper.unmodifiable(builder.groups);
    }

    public static SearchStats of(Function<Builder, ObjectBuilder<SearchStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long fetchCurrent() {
        return this.fetchCurrent;
    }

    public final long fetchTimeInMillis() {
        return this.fetchTimeInMillis;
    }

    public final long fetchTotal() {
        return this.fetchTotal;
    }

    @Nullable
    public final Long openContexts() {
        return this.openContexts;
    }

    public final long queryCurrent() {
        return this.queryCurrent;
    }

    public final long queryTimeInMillis() {
        return this.queryTimeInMillis;
    }

    public final long queryTotal() {
        return this.queryTotal;
    }

    public final long scrollCurrent() {
        return this.scrollCurrent;
    }

    public final long scrollTimeInMillis() {
        return this.scrollTimeInMillis;
    }

    public final long scrollTotal() {
        return this.scrollTotal;
    }

    public final long suggestCurrent() {
        return this.suggestCurrent;
    }

    public final long suggestTimeInMillis() {
        return this.suggestTimeInMillis;
    }

    public final long suggestTotal() {
        return this.suggestTotal;
    }

    public final Map<String, SearchStats> groups() {
        return this.groups;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fetch_current");
        generator.write(this.fetchCurrent);
        generator.writeKey("fetch_time_in_millis");
        generator.write(this.fetchTimeInMillis);
        generator.writeKey("fetch_total");
        generator.write(this.fetchTotal);
        if (this.openContexts != null) {
            generator.writeKey("open_contexts");
            generator.write(this.openContexts.longValue());
        }
        generator.writeKey("query_current");
        generator.write(this.queryCurrent);
        generator.writeKey("query_time_in_millis");
        generator.write(this.queryTimeInMillis);
        generator.writeKey("query_total");
        generator.write(this.queryTotal);
        generator.writeKey("scroll_current");
        generator.write(this.scrollCurrent);
        generator.writeKey("scroll_time_in_millis");
        generator.write(this.scrollTimeInMillis);
        generator.writeKey("scroll_total");
        generator.write(this.scrollTotal);
        generator.writeKey("suggest_current");
        generator.write(this.suggestCurrent);
        generator.writeKey("suggest_time_in_millis");
        generator.write(this.suggestTimeInMillis);
        generator.writeKey("suggest_total");
        generator.write(this.suggestTotal);
        if (ApiTypeHelper.isDefined(this.groups)) {
            generator.writeKey("groups");
            generator.writeStartObject();
            for (Map.Entry<String, SearchStats> item0 : this.groups.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSearchStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fetchCurrent, JsonpDeserializer.longDeserializer(), "fetch_current");
        op.add(Builder::fetchTimeInMillis, JsonpDeserializer.longDeserializer(), "fetch_time_in_millis");
        op.add(Builder::fetchTotal, JsonpDeserializer.longDeserializer(), "fetch_total");
        op.add(Builder::openContexts, JsonpDeserializer.longDeserializer(), "open_contexts");
        op.add(Builder::queryCurrent, JsonpDeserializer.longDeserializer(), "query_current");
        op.add(Builder::queryTimeInMillis, JsonpDeserializer.longDeserializer(), "query_time_in_millis");
        op.add(Builder::queryTotal, JsonpDeserializer.longDeserializer(), "query_total");
        op.add(Builder::scrollCurrent, JsonpDeserializer.longDeserializer(), "scroll_current");
        op.add(Builder::scrollTimeInMillis, JsonpDeserializer.longDeserializer(), "scroll_time_in_millis");
        op.add(Builder::scrollTotal, JsonpDeserializer.longDeserializer(), "scroll_total");
        op.add(Builder::suggestCurrent, JsonpDeserializer.longDeserializer(), "suggest_current");
        op.add(Builder::suggestTimeInMillis, JsonpDeserializer.longDeserializer(), "suggest_time_in_millis");
        op.add(Builder::suggestTotal, JsonpDeserializer.longDeserializer(), "suggest_total");
        op.add(Builder::groups, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "groups");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SearchStats> {
        private Long fetchCurrent;
        private Long fetchTimeInMillis;
        private Long fetchTotal;
        @Nullable
        private Long openContexts;
        private Long queryCurrent;
        private Long queryTimeInMillis;
        private Long queryTotal;
        private Long scrollCurrent;
        private Long scrollTimeInMillis;
        private Long scrollTotal;
        private Long suggestCurrent;
        private Long suggestTimeInMillis;
        private Long suggestTotal;
        @Nullable
        private Map<String, SearchStats> groups;

        public final Builder fetchCurrent(long value) {
            this.fetchCurrent = value;
            return this;
        }

        public final Builder fetchTimeInMillis(long value) {
            this.fetchTimeInMillis = value;
            return this;
        }

        public final Builder fetchTotal(long value) {
            this.fetchTotal = value;
            return this;
        }

        public final Builder openContexts(@Nullable Long value) {
            this.openContexts = value;
            return this;
        }

        public final Builder queryCurrent(long value) {
            this.queryCurrent = value;
            return this;
        }

        public final Builder queryTimeInMillis(long value) {
            this.queryTimeInMillis = value;
            return this;
        }

        public final Builder queryTotal(long value) {
            this.queryTotal = value;
            return this;
        }

        public final Builder scrollCurrent(long value) {
            this.scrollCurrent = value;
            return this;
        }

        public final Builder scrollTimeInMillis(long value) {
            this.scrollTimeInMillis = value;
            return this;
        }

        public final Builder scrollTotal(long value) {
            this.scrollTotal = value;
            return this;
        }

        public final Builder suggestCurrent(long value) {
            this.suggestCurrent = value;
            return this;
        }

        public final Builder suggestTimeInMillis(long value) {
            this.suggestTimeInMillis = value;
            return this;
        }

        public final Builder suggestTotal(long value) {
            this.suggestTotal = value;
            return this;
        }

        public final Builder groups(Map<String, SearchStats> map) {
            this.groups = Builder._mapPutAll(this.groups, map);
            return this;
        }

        public final Builder groups(String key, SearchStats value) {
            this.groups = Builder._mapPut(this.groups, key, value);
            return this;
        }

        public final Builder groups(String key, Function<Builder, ObjectBuilder<SearchStats>> fn) {
            return this.groups(key, fn.apply(new Builder()).build());
        }

        @Override
        public SearchStats build() {
            this._checkSingleUse();
            return new SearchStats(this);
        }
    }
}

