/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class CurrentNode
implements JsonpSerializable {
    private final String id;
    private final String name;
    private final Map<String, String> attributes;
    private final String transportAddress;
    private final int weightRanking;
    public static final JsonpDeserializer<CurrentNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CurrentNode::setupCurrentNodeDeserializer);

    private CurrentNode(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.weightRanking = ApiTypeHelper.requireNonNull(builder.weightRanking, this, "weightRanking");
    }

    public static CurrentNode of(Function<Builder, ObjectBuilder<CurrentNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    public final int weightRanking() {
        return this.weightRanking;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.attributes.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("weight_ranking");
        generator.write(this.weightRanking);
    }

    protected static void setupCurrentNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::weightRanking, JsonpDeserializer.integerDeserializer(), "weight_ranking");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CurrentNode> {
        private String id;
        private String name;
        private Map<String, String> attributes;
        private String transportAddress;
        private Integer weightRanking;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder weightRanking(int value) {
            this.weightRanking = value;
            return this;
        }

        @Override
        public CurrentNode build() {
            this._checkSingleUse();
            return new CurrentNode(this);
        }
    }
}

