/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;

public class EhloCmdHandler
extends AbstractHookableCmdHandler<HeloHook>
implements EhloExtension {
    private static final String COMMAND_NAME = "EHLO";
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"EHLO");
    private static final List<String> ESMTP_FEATURES = ImmutableList.of((Object)"PIPELINING", (Object)"ENHANCEDSTATUSCODES", (Object)"8BITMIME");
    private static final Response DOMAIN_ADDRESS_REQUIRED = new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Domain address required: EHLO").immutable();
    private List<EhloExtension> ehloExtensions;

    @Inject
    public EhloCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    private Response doEHLO(SMTPSession session, String argument) {
        SMTPResponse resp = new SMTPResponse("250", new StringBuilder(session.getConfiguration().getHelloName()).append(" Hello ").append(argument).append(" [").append(session.getRemoteAddress().getAddress().getHostAddress()).append("])"));
        session.setAttachment(SMTPSession.CURRENT_HELO_MODE, COMMAND_NAME, ProtocolSession.State.Connection);
        this.processExtensions(session, resp);
        return resp;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    public List<Class<?>> getMarkerInterfaces() {
        List<Class<?>> classes = super.getMarkerInterfaces();
        classes.add(EhloExtension.class);
        return classes;
    }

    @Override
    public void wireExtensions(Class<?> interfaceName, List<?> extension) {
        super.wireExtensions(interfaceName, extension);
        if (EhloExtension.class.equals(interfaceName)) {
            this.ehloExtensions = extension;
        }
    }

    private void processExtensions(SMTPSession session, SMTPResponse resp) {
        if (this.ehloExtensions != null) {
            for (EhloExtension ehloExtension : this.ehloExtensions) {
                List<String> lines = ehloExtension.getImplementedEsmtpFeatures(session);
                if (lines == null) continue;
                for (String line : lines) {
                    resp.appendLine(line);
                }
            }
        }
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        return this.doEHLO(session, parameters);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String parameters) {
        session.resetState();
        if (parameters == null) {
            return DOMAIN_ADDRESS_REQUIRED;
        }
        session.setAttachment(SMTPSession.CURRENT_HELO_NAME, parameters, ProtocolSession.State.Connection);
        return null;
    }

    @Override
    protected Class<HeloHook> getHookInterface() {
        return HeloHook.class;
    }

    @Override
    protected HookResult callHook(HeloHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doHelo(session, parameters);
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        return ImmutableList.builder().addAll(ESMTP_FEATURES).addAll((Iterable)this.getHooks().stream().flatMap(heloHook -> heloHook.implementedEsmtpFeatures(session).stream()).collect(ImmutableList.toImmutableList())).build();
    }
}

