/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.access;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.access.AccessToken;
import org.apache.james.jmap.api.access.AccessTokenRepository;
import org.apache.james.jmap.api.access.exceptions.InvalidAccessToken;
import reactor.core.publisher.Mono;

public class MemoryAccessTokenRepository
implements AccessTokenRepository {
    private final PassiveExpiringMap<AccessToken, Username> tokensExpirationDates;

    @Inject
    public MemoryAccessTokenRepository(@Named(value="tokenExpirationInMs") long durationInMilliseconds) {
        this.tokensExpirationDates = new PassiveExpiringMap(durationInMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<Void> addToken(Username username, AccessToken accessToken) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)accessToken);
        PassiveExpiringMap<AccessToken, Username> passiveExpiringMap = this.tokensExpirationDates;
        synchronized (passiveExpiringMap) {
            this.tokensExpirationDates.put((Object)accessToken, (Object)username);
        }
        return Mono.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<Void> removeToken(AccessToken accessToken) {
        Preconditions.checkNotNull((Object)accessToken);
        PassiveExpiringMap<AccessToken, Username> passiveExpiringMap = this.tokensExpirationDates;
        synchronized (passiveExpiringMap) {
            this.tokensExpirationDates.remove((Object)accessToken);
        }
        return Mono.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<Username> getUsernameFromToken(AccessToken accessToken) throws InvalidAccessToken {
        Preconditions.checkNotNull((Object)accessToken);
        PassiveExpiringMap<AccessToken, Username> passiveExpiringMap = this.tokensExpirationDates;
        synchronized (passiveExpiringMap) {
            return Mono.just((Object)Optional.ofNullable((Username)this.tokensExpirationDates.get((Object)accessToken)).orElseThrow(() -> new InvalidAccessToken(accessToken)));
        }
    }
}

