/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExtendedRequestProtocolOp
implements ProtocolOp {
    public static final byte TYPE_OID = -128;
    public static final byte TYPE_VALUE = -127;
    private static final long serialVersionUID = -5343424210200494377L;
    @Nullable
    private final ASN1OctetString value;
    @NotNull
    private final String oid;

    public ExtendedRequestProtocolOp(@NotNull String oid, @Nullable ASN1OctetString value) {
        this.oid = oid;
        this.value = value == null ? null : new ASN1OctetString(-127, value.getValue());
    }

    public ExtendedRequestProtocolOp(@NotNull ExtendedRequest request) {
        this.oid = request.getOID();
        this.value = request.getValue();
    }

    ExtendedRequestProtocolOp(@NotNull ASN1StreamReader reader) throws LDAPException {
        try {
            ASN1StreamReaderSequence opSequence = reader.beginSequence();
            this.oid = reader.readString();
            Validator.ensureNotNull(this.oid);
            this.value = opSequence.hasMoreElements() ? new ASN1OctetString(-127, reader.readBytes()) : null;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_EXTENDED_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String getOID() {
        return this.oid;
    }

    @Nullable
    public ASN1OctetString getValue() {
        return this.value;
    }

    @Override
    public byte getProtocolOpType() {
        return 119;
    }

    @Override
    @NotNull
    public ASN1Element encodeProtocolOp() {
        if (this.value == null) {
            return new ASN1Sequence(119, new ASN1OctetString(-128, this.oid));
        }
        return new ASN1Sequence(119, new ASN1OctetString(-128, this.oid), this.value);
    }

    @NotNull
    public static ExtendedRequestProtocolOp decodeProtocolOp(@NotNull ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            String oid = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            ASN1OctetString value = elements.length == 1 ? null : ASN1OctetString.decodeAsOctetString(elements[1]);
            return new ExtendedRequestProtocolOp(oid, value);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_EXTENDED_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void writeTo(@NotNull ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)119);
        buffer.addOctetString((byte)-128, this.oid);
        if (this.value != null) {
            buffer.addOctetString((byte)-127, this.value.getValue());
        }
        opSequence.end();
    }

    @NotNull
    public ExtendedRequest toExtendedRequest(Control ... controls) {
        return new ExtendedRequest(this.oid, this.value, controls);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ExtendedRequestProtocolOp(oid='");
        buffer.append(this.oid);
        buffer.append("')");
    }
}

