/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class TermsExclude
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TermsExclude> _DESERIALIZER = JsonpDeserializer.lazy(TermsExclude::buildTermsExcludeDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private TermsExclude(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Terms: {
                return this.terms().stream().map(v -> v).collect(Collectors.joining(","));
            }
            case Regexp: {
                return this.regexp();
            }
        }
        throw new IllegalStateException("Unknown kind " + this._kind);
    }

    private TermsExclude(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TermsExclude of(Function<Builder, ObjectBuilder<TermsExclude>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTerms() {
        return this._kind == Kind.Terms;
    }

    public List<String> terms() {
        return (List)TaggedUnionUtils.get(this, Kind.Terms);
    }

    public boolean isRegexp() {
        return this._kind == Kind.Regexp;
    }

    public String regexp() {
        return (String)TaggedUnionUtils.get(this, Kind.Regexp);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Terms: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Regexp: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    private static JsonpDeserializer<TermsExclude> buildTermsExcludeDeserializer() {
        return new UnionDeserializer.Builder<TermsExclude, Kind, Object>(TermsExclude::new, false).addMember(Kind.Terms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())).addMember(Kind.Regexp, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TermsExclude> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<TermsExclude> terms(List<String> v) {
            this._kind = Kind.Terms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TermsExclude> regexp(String v) {
            this._kind = Kind.Regexp;
            this._value = v;
            return this;
        }

        @Override
        public TermsExclude build() {
            this._checkSingleUse();
            return new TermsExclude(this);
        }
    }

    public static enum Kind {
        Terms,
        Regexp;

    }
}

