/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lifecycle.api;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Disposable {
    public void dispose();

    public static class LeakAwareFinalizer
    extends PhantomReference<LeakAware<?>> {
        private static final Logger LOGGER = LoggerFactory.getLogger(LeakAwareFinalizer.class);
        private final LeakAware.Resource resource;
        private TraceRecord traceRecord;

        public LeakAwareFinalizer(LeakAware referent, LeakAware.Resource resource, ReferenceQueue<? super LeakAware<?>> q) {
            super(referent, q);
            this.resource = resource;
            if (LeakAware.tracedEnabled()) {
                this.traceRecord = new TraceRecord(StackWalker.getInstance().walk(s -> s.collect(Collectors.toList())));
            }
        }

        public void detectLeak() {
            switch (LeakAware.LEVEL) {
                case NONE: {
                    break;
                }
                case SIMPLE: 
                case ADVANCED: {
                    if (!this.isNotDisposed()) break;
                    this.errorLog();
                    this.resource.dispose();
                    LeakAware.REFERENCES_IN_USE.remove(this);
                    break;
                }
                case TESTING: {
                    if (!this.isNotDisposed()) break;
                    this.errorLog();
                    throw new LeakAware.LeakDetectorException();
                }
            }
        }

        public void errorLog() {
            if (LeakAware.tracedEnabled()) {
                LOGGER.error("Leak detected! Resource {} was not released before its referent was garbage-collected. \nThis resource was instanced at: \n{}", (Object)this.resource, (Object)this.traceRecord.toString());
            } else {
                LOGGER.error("Leak detected! Resource {} was not released before its referent was garbage-collected. \nResource management needs to be reviewed: ensure to always call dispose() for disposable objects you work with. \nConsider enabling advanced leak detection to further identify the problem.", (Object)this.resource);
            }
        }

        private boolean isNotDisposed() {
            return !this.resource.isDisposed();
        }
    }

    public static class TraceRecord {
        private final List<StackWalker.StackFrame> stackFrames;

        TraceRecord(List<StackWalker.StackFrame> stackFrames) {
            this.stackFrames = stackFrames;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.stackFrames.subList(3, this.stackFrames.size()).forEach(stackFrame -> {
                buf.append("\t");
                buf.append(stackFrame.getClassName());
                buf.append("#");
                buf.append(stackFrame.getMethodName());
                buf.append(":");
                buf.append(stackFrame.getLineNumber());
                buf.append("\n");
            });
            return buf.toString();
        }
    }

    public static abstract class LeakAware<T extends Resource>
    implements Disposable {
        public static final ReferenceQueue<LeakAware<?>> REFERENCE_QUEUE = new ReferenceQueue();
        public static final ConcurrentHashMap<LeakAwareFinalizer, Boolean> REFERENCES_IN_USE = new ConcurrentHashMap();
        public static final Level LEVEL = Optional.ofNullable(System.getProperty("james.lifecycle.leak.detection.mode")).map(Level::parse).orElse(Level.SIMPLE);
        private final T resource;
        private LeakAwareFinalizer finalizer;

        public static void track() {
            Reference<LeakAware<?>> referenceFromQueue;
            while ((referenceFromQueue = REFERENCE_QUEUE.poll()) != null) {
                if (LeakAware.leakDetectorEnabled()) {
                    ((LeakAwareFinalizer)referenceFromQueue).detectLeak();
                }
                referenceFromQueue.clear();
            }
        }

        private static boolean leakDetectorEnabled() {
            return LEVEL != Level.NONE;
        }

        public static boolean tracedEnabled() {
            return LEVEL == Level.ADVANCED || LEVEL == Level.TESTING;
        }

        protected LeakAware(T resource) {
            this.resource = resource;
            if (LeakAware.leakDetectorEnabled()) {
                this.finalizer = new LeakAwareFinalizer(this, (Resource)resource, (ReferenceQueue<? super LeakAware<?>>)REFERENCE_QUEUE);
                REFERENCES_IN_USE.put(this.finalizer, true);
            }
        }

        @Override
        public void dispose() {
            if (this.finalizer != null) {
                REFERENCES_IN_USE.remove(this.finalizer);
            }
            ((Resource)this.resource).dispose();
        }

        public T getResource() {
            return this.resource;
        }

        public static enum Level {
            NONE,
            SIMPLE,
            ADVANCED,
            TESTING;


            static Level parse(String input) {
                for (Level level : Level.values()) {
                    if (!level.name().equalsIgnoreCase(input)) continue;
                    return level;
                }
                throw new IllegalArgumentException(String.format("Unknown level `%s`", input));
            }
        }

        public static class LeakDetectorException
        extends RuntimeException {
        }

        public static class Resource
        implements Disposable {
            private final AtomicBoolean isDisposed = new AtomicBoolean(false);
            private final Disposable cleanup;

            public Resource(Disposable cleanup) {
                this.cleanup = cleanup;
            }

            public boolean isDisposed() {
                return this.isDisposed.get();
            }

            @Override
            public void dispose() {
                this.isDisposed.set(true);
                this.cleanup.dispose();
            }
        }
    }
}

