/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Flags;
import org.apache.james.backends.opensearch.DocumentId;
import org.apache.james.backends.opensearch.OpenSearchIndexer;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.backends.opensearch.UpdatedRepresentation;
import org.apache.james.events.Group;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.opensearch.json.MessageToOpenSearchJson;
import org.apache.james.mailbox.opensearch.search.OpenSearchSearcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch.core.get.GetResult;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class OpenSearchListeningMessageSearchIndex
extends ListeningMessageSearchIndex {
    private static final int FLAGS_UPDATE_PROCESSING_WINDOW_SIZE = 32;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchListeningMessageSearchIndex.class);
    private static final String ID_SEPARATOR = ":";
    private static final Group GROUP = new OpenSearchListeningMessageSearchIndexGroup();
    private static final ImmutableList<String> MESSAGE_ID_FIELD = ImmutableList.of((Object)"messageId");
    private static final ImmutableList<String> UID_FIELD = ImmutableList.of((Object)"uid");
    private final OpenSearchIndexer openSearchIndexer;
    private final OpenSearchSearcher searcher;
    private final MessageToOpenSearchJson messageToOpenSearchJson;
    private final RoutingKey.Factory<MailboxId> routingKeyFactory;
    private final MessageId.Factory messageIdFactory;

    @Inject
    public OpenSearchListeningMessageSearchIndex(MailboxSessionMapperFactory factory, Set<ListeningMessageSearchIndex.SearchOverride> searchOverrides, @Named(value="mailbox") OpenSearchIndexer indexer, OpenSearchSearcher searcher, MessageToOpenSearchJson messageToOpenSearchJson, SessionProvider sessionProvider, RoutingKey.Factory<MailboxId> routingKeyFactory, MessageId.Factory messageIdFactory) {
        super(factory, searchOverrides, sessionProvider);
        this.openSearchIndexer = indexer;
        this.messageToOpenSearchJson = messageToOpenSearchJson;
        this.searcher = searcher;
        this.routingKeyFactory = routingKeyFactory;
        this.messageIdFactory = messageIdFactory;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, new MailboxManager.SearchCapabilities[]{MailboxManager.SearchCapabilities.Text, MailboxManager.SearchCapabilities.FullText, MailboxManager.SearchCapabilities.Attachment, MailboxManager.SearchCapabilities.AttachmentFileName, MailboxManager.SearchCapabilities.PartialEmailMatch});
    }

    protected Flux<MessageUid> doSearch(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        Optional<Integer> noLimit = Optional.empty();
        return this.searcher.search((Collection<MailboxId>)ImmutableList.of((Object)mailbox.getMailboxId()), searchQuery, noLimit, (List<String>)UID_FIELD).handle(this::extractUidFromHit);
    }

    public Flux<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        if (mailboxIds.isEmpty()) {
            return Flux.empty();
        }
        return this.searcher.search(mailboxIds, searchQuery, Optional.empty(), (List<String>)MESSAGE_ID_FIELD).handle(this::extractMessageIdFromHit).distinct().take(limit);
    }

    public Mono<Void> add(MailboxSession session, Mailbox mailbox, MailboxMessage message) {
        LOGGER.info("Indexing mailbox {}-{} of user {} on message {}", new Object[]{mailbox.getName(), mailbox.getMailboxId().serialize(), session.getUser().asString(), message.getUid().asLong()});
        RoutingKey from = this.routingKeyFactory.from((Object)mailbox.getMailboxId());
        DocumentId id = this.indexIdFor(mailbox.getMailboxId(), message.getUid());
        return this.generateIndexedJson(mailbox, message, session).flatMap(jsonContent -> this.openSearchIndexer.index(id, jsonContent, from)).then();
    }

    private Mono<String> generateIndexedJson(Mailbox mailbox, MailboxMessage message, MailboxSession session) {
        return this.messageToOpenSearchJson.convertToJson(message).onErrorResume(e -> {
            LOGGER.warn("Indexing mailbox {}-{} of user {} on message {} without attachments ", new Object[]{mailbox.getName(), mailbox.getMailboxId().serialize(), session.getUser().asString(), message.getUid(), e});
            return this.messageToOpenSearchJson.convertToJsonWithoutAttachment(message);
        });
    }

    public Mono<Void> delete(MailboxSession session, MailboxId mailboxId, Collection<MessageUid> expungedUids) {
        return this.openSearchIndexer.delete((List)expungedUids.stream().map(uid -> this.indexIdFor(mailboxId, (MessageUid)uid)).collect(ImmutableList.toImmutableList()), this.routingKeyFactory.from((Object)mailboxId)).then();
    }

    public Mono<Void> deleteAll(MailboxSession session, MailboxId mailboxId) {
        Query query = TermQuery.of(t -> t.field("mailboxId").value((FieldValue)new FieldValue.Builder().stringValue(mailboxId.serialize()).build()))._toQuery();
        return this.openSearchIndexer.deleteAllMatchingQuery(query, this.routingKeyFactory.from((Object)mailboxId));
    }

    public Mono<Void> update(MailboxSession session, MailboxId mailboxId, List<UpdatedFlags> updatedFlagsList) {
        RoutingKey routingKey = this.routingKeyFactory.from((Object)mailboxId);
        return Flux.fromIterable(updatedFlagsList).map(Throwing.function(updatedFlags -> this.createUpdatedDocumentPartFromUpdatedFlags(mailboxId, (UpdatedFlags)updatedFlags)).sneakyThrow()).window(32).concatMap(flux -> flux.collect(ImmutableList.toImmutableList()).flatMap(updates -> this.openSearchIndexer.update((List)updates, routingKey))).then();
    }

    private UpdatedRepresentation createUpdatedDocumentPartFromUpdatedFlags(MailboxId mailboxId, UpdatedFlags updatedFlags) throws JsonProcessingException {
        return new UpdatedRepresentation(this.indexIdFor(mailboxId, updatedFlags.getUid()), this.messageToOpenSearchJson.getUpdatedJsonMessagePart(updatedFlags.getNewFlags(), updatedFlags.getModSeq()));
    }

    private DocumentId indexIdFor(MailboxId mailboxId, MessageUid uid) {
        return DocumentId.fromString((String)(mailboxId.serialize() + ID_SEPARATOR + uid.asLong()));
    }

    private void logIfNoMessageId(MessageSearchIndex.SearchResult searchResult) {
        if (!searchResult.getMessageId().isPresent()) {
            LOGGER.error("No messageUid for {} in mailbox {}", (Object)searchResult.getMessageUid(), (Object)searchResult.getMailboxId());
        }
    }

    public Mono<Flags> retrieveIndexedFlags(Mailbox mailbox, MessageUid uid) {
        RoutingKey routingKey = this.routingKeyFactory.from((Object)mailbox.getMailboxId());
        return this.openSearchIndexer.get(this.indexIdFor(mailbox.getMailboxId(), uid), routingKey).filter(GetResult::found).map(GetResult::source).map(this::extractFlags);
    }

    private Flags extractFlags(ObjectNode source) {
        FlagsBuilder flagsBuilder = FlagsBuilder.builder().isAnswered(this.extractFlag(source, "isAnswered")).isDeleted(this.extractFlag(source, "isDeleted")).isDraft(this.extractFlag(source, "isDraft")).isFlagged(this.extractFlag(source, "isFlagged")).isRecent(this.extractFlag(source, "isRecent")).isSeen(!this.extractFlag(source, "isUnread"));
        for (JsonNode userFlag : this.extractUserFlags(source)) {
            flagsBuilder.add(new String[]{userFlag.textValue()});
        }
        return flagsBuilder.build();
    }

    private boolean extractFlag(ObjectNode source, String flag) {
        return source.get(flag).asBoolean();
    }

    private ArrayNode extractUserFlags(ObjectNode source) {
        return source.withArray("userFlags");
    }

    private void extractMessageIdFromHit(Hit<ObjectNode> hit, SynchronousSink<MessageId> sink) {
        JsonData messageId = (JsonData)hit.fields().get("messageId");
        if (messageId != null) {
            String messageIdAsString = messageId.toJson().asJsonArray().getString(0);
            sink.next((Object)this.messageIdFactory.fromString(messageIdAsString));
        } else {
            LOGGER.warn("Can not extract UID, MessageID and/or MailboxId for search result {}", (Object)hit.id());
        }
    }

    private void extractUidFromHit(Hit<ObjectNode> hit, SynchronousSink<MessageUid> sink) {
        JsonData uid = (JsonData)hit.fields().get("uid");
        if (uid != null) {
            int uidAsInt = uid.toJson().asJsonArray().getInt(0);
            sink.next((Object)MessageUid.of((long)uidAsInt));
        } else {
            LOGGER.warn("Can not extract UID, MessageID and/or MailboxId for search result {}", (Object)hit.id());
        }
    }

    public static class OpenSearchListeningMessageSearchIndexGroup
    extends Group {
    }
}

