/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.incubator.codec.quic.FlushStrategy;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicPacketType;
import io.netty.incubator.codec.quic.QuicSslEngine;
import io.netty.incubator.codec.quic.QuicheConfig;
import io.netty.incubator.codec.quic.QuicheQuicChannel;
import io.netty.incubator.codec.quic.QuicheQuicCodec;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.function.Function;

final class QuicheQuicClientCodec
extends QuicheQuicCodec {
    private final Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider;
    private final Executor sslTaskExecutor;

    QuicheQuicClientCodec(QuicheConfig config, Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider, Executor sslTaskExecutor, int localConnIdLength, FlushStrategy flushStrategy) {
        super(config, localConnIdLength, 1350, flushStrategy);
        this.sslEngineProvider = sslEngineProvider;
        this.sslTaskExecutor = sslTaskExecutor;
    }

    @Override
    protected QuicheQuicChannel quicPacketRead(ChannelHandlerContext ctx, InetSocketAddress sender, InetSocketAddress recipient, QuicPacketType type, int version, ByteBuf scid, ByteBuf dcid, ByteBuf token) {
        ByteBuffer key = dcid.internalNioBuffer(dcid.readerIndex(), dcid.readableBytes());
        return this.getChannel(key);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        QuicheQuicChannel channel;
        try {
            channel = QuicheQuicChannel.handleConnect(this.sslEngineProvider, this.sslTaskExecutor, remoteAddress, this.config.nativeAddress(), this.localConnIdLength, this.config.isDatagramSupported(), this.senderSockaddrMemory.internalNioBuffer(0, this.senderSockaddrMemory.capacity()), this.recipientSockaddrMemory.internalNioBuffer(0, this.recipientSockaddrMemory.capacity()));
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            return;
        }
        if (channel != null) {
            this.putChannel(channel);
            channel.finishConnect();
            promise.setSuccess();
            return;
        }
        ctx.connect(remoteAddress, localAddress, promise);
    }
}

