/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.metadata.schema.events.AggregateChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.FunctionChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.KeyspaceChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TableChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TypeChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.ViewChangeEvent;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import io.netty.util.concurrent.EventExecutor;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class SchemaListenerNotifier {
    private final SchemaChangeListener listener;
    private final EventExecutor adminExecutor;
    private boolean sessionReady;

    SchemaListenerNotifier(SchemaChangeListener listener, EventBus eventBus, EventExecutor adminExecutor) {
        this.listener = listener;
        this.adminExecutor = adminExecutor;
        eventBus.register(AggregateChangeEvent.class, RunOrSchedule.on(adminExecutor, this::onAggregateChangeEvent));
        eventBus.register(FunctionChangeEvent.class, RunOrSchedule.on(adminExecutor, this::onFunctionChangeEvent));
        eventBus.register(KeyspaceChangeEvent.class, RunOrSchedule.on(adminExecutor, this::onKeyspaceChangeEvent));
        eventBus.register(TableChangeEvent.class, RunOrSchedule.on(adminExecutor, this::onTableChangeEvent));
        eventBus.register(TypeChangeEvent.class, RunOrSchedule.on(adminExecutor, this::onTypeChangeEvent));
        eventBus.register(ViewChangeEvent.class, RunOrSchedule.on(adminExecutor, this::onViewChangeEvent));
    }

    void onSessionReady(Session session) {
        RunOrSchedule.on(this.adminExecutor, () -> {
            this.sessionReady = true;
            this.listener.onSessionReady(session);
        });
    }

    private void onAggregateChangeEvent(AggregateChangeEvent event) {
        assert (this.adminExecutor.inEventLoop());
        if (this.sessionReady) {
            switch (event.changeType) {
                case CREATED: {
                    this.listener.onAggregateCreated(event.newAggregate);
                    break;
                }
                case UPDATED: {
                    this.listener.onAggregateUpdated(event.newAggregate, event.oldAggregate);
                    break;
                }
                case DROPPED: {
                    this.listener.onAggregateDropped(event.oldAggregate);
                }
            }
        }
    }

    private void onFunctionChangeEvent(FunctionChangeEvent event) {
        assert (this.adminExecutor.inEventLoop());
        if (this.sessionReady) {
            switch (event.changeType) {
                case CREATED: {
                    this.listener.onFunctionCreated(event.newFunction);
                    break;
                }
                case UPDATED: {
                    this.listener.onFunctionUpdated(event.newFunction, event.oldFunction);
                    break;
                }
                case DROPPED: {
                    this.listener.onFunctionDropped(event.oldFunction);
                }
            }
        }
    }

    private void onKeyspaceChangeEvent(KeyspaceChangeEvent event) {
        assert (this.adminExecutor.inEventLoop());
        if (this.sessionReady) {
            switch (event.changeType) {
                case CREATED: {
                    this.listener.onKeyspaceCreated(event.newKeyspace);
                    break;
                }
                case UPDATED: {
                    this.listener.onKeyspaceUpdated(event.newKeyspace, event.oldKeyspace);
                    break;
                }
                case DROPPED: {
                    this.listener.onKeyspaceDropped(event.oldKeyspace);
                }
            }
        }
    }

    private void onTableChangeEvent(TableChangeEvent event) {
        assert (this.adminExecutor.inEventLoop());
        if (this.sessionReady) {
            switch (event.changeType) {
                case CREATED: {
                    this.listener.onTableCreated(event.newTable);
                    break;
                }
                case UPDATED: {
                    this.listener.onTableUpdated(event.newTable, event.oldTable);
                    break;
                }
                case DROPPED: {
                    this.listener.onTableDropped(event.oldTable);
                }
            }
        }
    }

    private void onTypeChangeEvent(TypeChangeEvent event) {
        assert (this.adminExecutor.inEventLoop());
        if (this.sessionReady) {
            switch (event.changeType) {
                case CREATED: {
                    this.listener.onUserDefinedTypeCreated(event.newType);
                    break;
                }
                case UPDATED: {
                    this.listener.onUserDefinedTypeUpdated(event.newType, event.oldType);
                    break;
                }
                case DROPPED: {
                    this.listener.onUserDefinedTypeDropped(event.oldType);
                }
            }
        }
    }

    private void onViewChangeEvent(ViewChangeEvent event) {
        assert (this.adminExecutor.inEventLoop());
        if (this.sessionReady) {
            switch (event.changeType) {
                case CREATED: {
                    this.listener.onViewCreated(event.newView);
                    break;
                }
                case UPDATED: {
                    this.listener.onViewUpdated(event.newView, event.oldView);
                    break;
                }
                case DROPPED: {
                    this.listener.onViewDropped(event.oldView);
                }
            }
        }
    }
}

