/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.json;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.james.mailbox.model.MailboxACL;

public class MailboxACLJsonConverter {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(MailboxACL acl) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)acl);
    }

    public static MailboxACL toACL(String jsonACLString) throws IOException {
        return (MailboxACL)objectMapper.readValue(jsonACLString, MailboxACL.class);
    }

    static {
        SimpleModule module = new SimpleModule().addKeyDeserializer(MailboxACL.EntryKey.class, (KeyDeserializer)new ACLKeyDeserializer());
        objectMapper.addMixIn(MailboxACL.Rfc4314Rights.class, Rfc4314RightsMixIn.class).registerModule((Module)module);
    }

    static class ACLKeyDeserializer
    extends KeyDeserializer {
        ACLKeyDeserializer() {
        }

        public Object deserializeKey(String key, DeserializationContext deserializationContext) throws IOException {
            return MailboxACL.EntryKey.deserialize((String)key);
        }
    }

    static interface Rfc4314RightsMixIn {
        @JsonValue
        public String serialize();
    }
}

