/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMessageIdDAO;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAttachmentMapper
implements AttachmentMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraAttachmentMapper.class);
    private final CassandraAttachmentDAOV2 attachmentDAOV2;
    private final BlobStore blobStore;
    private final CassandraAttachmentMessageIdDAO attachmentMessageIdDAO;

    @Inject
    public CassandraAttachmentMapper(CassandraAttachmentDAOV2 attachmentDAOV2, BlobStore blobStore, CassandraAttachmentMessageIdDAO attachmentMessageIdDAO) {
        this.attachmentDAOV2 = attachmentDAOV2;
        this.blobStore = blobStore;
        this.attachmentMessageIdDAO = attachmentMessageIdDAO;
    }

    public AttachmentMetadata getAttachment(AttachmentId attachmentId) throws AttachmentNotFoundException {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return (AttachmentMetadata)this.getAttachmentInternal(attachmentId).blockOptional().orElseThrow(() -> new AttachmentNotFoundException(attachmentId.getId()));
    }

    public Mono<AttachmentMetadata> getAttachmentReactive(AttachmentId attachmentId) {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return this.getAttachmentInternal(attachmentId).switchIfEmpty(Mono.error(() -> new AttachmentNotFoundException(attachmentId.getId())));
    }

    public List<AttachmentMetadata> getAttachments(Collection<AttachmentId> attachmentIds) {
        Preconditions.checkArgument((attachmentIds != null ? 1 : 0) != 0);
        return (List)Flux.fromIterable(attachmentIds).flatMap(this::getAttachmentsAsMono, 16).collect(ImmutableList.toImmutableList()).block();
    }

    public InputStream loadAttachmentContent(AttachmentId attachmentId) throws AttachmentNotFoundException {
        return (InputStream)this.attachmentDAOV2.getAttachment(attachmentId, this.messageIdFallback(attachmentId)).map(daoAttachment -> this.blobStore.read(this.blobStore.getDefaultBucketName(), daoAttachment.getBlobId(), BlobStore.StoragePolicy.LOW_COST)).blockOptional().orElseThrow(() -> new AttachmentNotFoundException(attachmentId.toString()));
    }

    public Mono<InputStream> loadAttachmentContentReactive(AttachmentId attachmentId) {
        return this.attachmentDAOV2.getAttachment(attachmentId, this.messageIdFallback(attachmentId)).flatMap(daoAttachment -> Mono.from((Publisher)this.blobStore.readReactive(this.blobStore.getDefaultBucketName(), daoAttachment.getBlobId(), BlobStore.StoragePolicy.LOW_COST))).switchIfEmpty(Mono.error(() -> new AttachmentNotFoundException(attachmentId.toString())));
    }

    private Mono<CassandraMessageId> messageIdFallback(AttachmentId attachmentId) {
        return this.attachmentMessageIdDAO.getOwnerMessageIds(attachmentId).map(CassandraMessageId.class::cast).next();
    }

    public Mono<AttachmentMetadata> getAttachmentsAsMono(AttachmentId attachmentId) {
        return this.getAttachmentInternal(attachmentId).switchIfEmpty(ReactorUtils.executeAndEmpty(() -> this.logNotFound(attachmentId)));
    }

    private Mono<AttachmentMetadata> getAttachmentInternal(AttachmentId id) {
        return this.attachmentDAOV2.getAttachment(id, this.messageIdFallback(id)).map(CassandraAttachmentDAOV2.DAOAttachment::toAttachment);
    }

    public List<MessageAttachmentMetadata> storeAttachments(Collection<ParsedAttachment> parsedAttachments, MessageId ownerMessageId) {
        return (List)this.storeAttachmentsReactive(parsedAttachments, ownerMessageId).block();
    }

    public Mono<List<MessageAttachmentMetadata>> storeAttachmentsReactive(Collection<ParsedAttachment> attachments, MessageId ownerMessageId) {
        return Flux.fromIterable(attachments).concatMap(attachment -> this.storeAttachmentAsync((ParsedAttachment)attachment, ownerMessageId)).collectList();
    }

    public Collection<MessageId> getRelatedMessageIds(AttachmentId attachmentId) {
        return (Collection)this.attachmentMessageIdDAO.getOwnerMessageIds(attachmentId).collect(ImmutableList.toImmutableList()).block();
    }

    private Mono<MessageAttachmentMetadata> storeAttachmentAsync(ParsedAttachment parsedAttachment, MessageId ownerMessageId) {
        try {
            AttachmentId attachmentId = AttachmentId.random();
            ByteSource content = parsedAttachment.getContent();
            long size = content.size();
            return Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), content, BlobStore.StoragePolicy.LOW_COST)).map(blobId -> new CassandraAttachmentDAOV2.DAOAttachment(ownerMessageId, attachmentId, (BlobId)blobId, parsedAttachment.getContentType(), size)).flatMap(this::storeAttachmentWithIndex).thenReturn((Object)parsedAttachment.asMessageAttachment(attachmentId, size, ownerMessageId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Mono<Void> storeAttachmentWithIndex(CassandraAttachmentDAOV2.DAOAttachment daoAttachment) {
        return this.attachmentDAOV2.storeAttachment(daoAttachment);
    }

    private void logNotFound(AttachmentId attachmentId) {
        LOGGER.warn("Failed retrieving attachment {}", (Object)attachmentId);
    }
}

