/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.name.Named;
import java.io.FileNotFoundException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.PeriodicalHealthChecks;
import org.apache.james.PeriodicalHealthChecksConfiguration;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceGenericLoader;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.NamingScheme;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicalHealthChecksModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicalHealthChecksModule.class);
    private static final String FILENAME = "healthcheck";

    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class);
    }

    @Singleton
    @Provides
    @Named(value="resolved-checks")
    Set<HealthCheck> provideHealthChecks(Set<HealthCheck> builtInHealthChecks, GuiceGenericLoader loader, PeriodicalHealthChecksConfiguration configuration) {
        Set additionalHealthChecks = configuration.getAdditionalHealthChecks().stream().map(ClassName::new).map(Throwing.function(arg_0 -> ((GuiceGenericLoader.InvocationPerformer)loader.withNamingSheme(NamingScheme.IDENTITY)).instantiate(arg_0))).peek(additionalHealthCheck -> LOGGER.info("Loading additional Healthcheck {}", (Object)additionalHealthCheck.getClass().getCanonicalName())).collect(Collectors.toSet());
        return ImmutableSet.builder().addAll(builtInHealthChecks).addAll(additionalHealthChecks).build();
    }

    @Singleton
    @Provides
    PeriodicalHealthChecksConfiguration periodicalHealthChecksConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfigurations(new String[]{FILENAME});
            return PeriodicalHealthChecksConfiguration.from(configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find {} configuration file, using default configuration", (Object)FILENAME);
            return PeriodicalHealthChecksConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @ProvidesIntoSet
    InitializationOperation configurePeriodicalHealthChecks(PeriodicalHealthChecks periodicalHealthChecks) {
        return InitilizationOperationBuilder.forClass(PeriodicalHealthChecks.class).init(periodicalHealthChecks::start);
    }
}

