/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.EnableRequest;
import org.apache.james.imap.message.response.EnableResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.CapabilityProcessor;
import org.apache.james.imap.processor.PermitEnableCapabilityProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EnableProcessor
extends AbstractMailboxProcessor<EnableRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnableProcessor.class);
    private static final List<PermitEnableCapabilityProcessor> capabilities = new ArrayList<PermitEnableCapabilityProcessor>();
    public static final String ENABLED_CAPABILITIES = "ENABLED_CAPABILITIES";
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_ENABLE);
    private final CapabilityProcessor capabilityProcessor;

    public EnableProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, List<PermitEnableCapabilityProcessor> capabilities, MetricFactory metricFactory, CapabilityProcessor capabilityProcessor) {
        this(mailboxManager, factory, metricFactory, capabilityProcessor);
        EnableProcessor.capabilities.addAll(capabilities);
    }

    @Inject
    public EnableProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, CapabilityProcessor capabilityProcessor) {
        super(EnableRequest.class, mailboxManager, factory, metricFactory);
        this.capabilityProcessor = capabilityProcessor;
    }

    @Override
    protected Mono<Void> processRequestReactive(EnableRequest request, ImapSession session, ImapProcessor.Responder responder) {
        List<Capability> caps = request.getCapabilities();
        return this.enable(request, responder, session, caps).doOnNext(enabledCaps -> responder.respond(new EnableResponse((Set<Capability>)enabledCaps))).then(this.unsolicitedResponses(session, responder, false)).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).onErrorResume(PermitEnableCapabilityProcessor.EnableException.class, e -> {
            this.taggedBad(request, responder, HumanReadableText.FAILED);
            return ReactorUtils.logAsMono(() -> LOGGER.info("Unable to enable extension", (Throwable)e));
        }).then();
    }

    public Mono<Set<Capability>> enable(ImapRequest request, ImapProcessor.Responder responder, ImapSession session, List<Capability> caps) {
        return Flux.fromIterable(caps).flatMap(cap -> {
            if (this.capabilityProcessor.getSupportedCapabilities(session).contains(cap)) {
                return Flux.fromIterable(capabilities).flatMap(enableProcessor -> {
                    if (enableProcessor.getPermitEnableCapabilities(session).contains(cap)) {
                        return enableProcessor.enable(request, responder, session, (Capability)cap).then(Mono.just((Object)cap));
                    }
                    return Mono.empty();
                }).distinct().next();
            }
            return Mono.empty();
        }).collect(ImmutableSet.toImmutableSet()).map(enabledCaps -> {
            EnableProcessor.getEnabledCapabilities(session).addAll((Collection<Capability>)enabledCaps);
            return enabledCaps;
        });
    }

    public void addProcessor(PermitEnableCapabilityProcessor implementor) {
        capabilities.add(implementor);
    }

    public static Set<Capability> getEnabledCapabilities(ImapSession session) {
        HashSet caps = (HashSet)session.getAttribute(ENABLED_CAPABILITIES);
        if (caps == null) {
            caps = new HashSet();
            session.setAttribute(ENABLED_CAPABILITIES, caps);
        }
        return caps;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected MDCBuilder mdc(EnableRequest request) {
        return MDCBuilder.create().addToContext("action", "ENABLE").addToContext("capabilities", ImmutableList.copyOf(request.getCapabilities()).toString());
    }
}

