/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.model.Quota;

public class QuotaThreshold
implements Comparable<QuotaThreshold> {
    public static final QuotaThreshold ZERO = new QuotaThreshold(0.0);
    private final double quotaOccupationRatio;

    public QuotaThreshold(double quotaOccupationRatio) {
        Preconditions.checkArgument((quotaOccupationRatio >= 0.0 ? 1 : 0) != 0, (Object)"Threshold should be contained in [0., 1.] range");
        Preconditions.checkArgument((quotaOccupationRatio <= 1.0 ? 1 : 0) != 0, (Object)"Threshold should be contained in [0., 1.] range");
        this.quotaOccupationRatio = quotaOccupationRatio;
    }

    public double getQuotaOccupationRatio() {
        return this.quotaOccupationRatio;
    }

    public int getQuotaOccupationRatioAsPercent() {
        return Double.valueOf(this.quotaOccupationRatio * 100.0).intValue();
    }

    public boolean isExceeded(Quota<?, ?> quota) {
        double limit;
        if (quota.getLimit().isUnlimited()) {
            return false;
        }
        double used = this.toDouble(quota.getUsed().asLong());
        double ratio = used / (limit = this.toDouble(quota.getLimit().asLong()));
        return ratio > this.quotaOccupationRatio;
    }

    public Optional<QuotaThreshold> nonZero() {
        if (this.equals(ZERO)) {
            return Optional.empty();
        }
        return Optional.of(this);
    }

    @Override
    public int compareTo(QuotaThreshold o) {
        return Double.compare(this.quotaOccupationRatio, o.quotaOccupationRatio);
    }

    private double toDouble(long aLong) {
        return Long.valueOf(aLong).doubleValue();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaThreshold) {
            QuotaThreshold that = (QuotaThreshold)o;
            return Objects.equals(this.quotaOccupationRatio, that.quotaOccupationRatio);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.quotaOccupationRatio);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("quotaOccupationInPercent", this.quotaOccupationRatio).toString();
    }
}

