/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.imap.api.message.Capability;

public class ImapConfiguration {
    public static final boolean DEFAULT_ENABLE_IDLE = true;
    public static final long DEFAULT_HEARTBEAT_INTERVAL_IN_SECONDS = 120L;
    public static final TimeUnit DEFAULT_HEARTBEAT_INTERVAL_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_CONCURRENT_REQUESTS = 128;
    public static final int DEFAULT_QUEUE_SIZE = 4096;
    public static final boolean DEFAULT_PROVISION_DEFAULT_MAILBOXES = true;
    private final Optional<Long> appendLimit;
    private final long idleTimeInterval;
    private final int concurrentRequests;
    private final int maxQueueSize;
    private final TimeUnit idleTimeIntervalUnit;
    private final ImmutableSet<Capability> disabledCaps;
    private final boolean enableIdle;
    private final boolean isCondstoreEnable;
    private final boolean provisionDefaultMailboxes;
    private final Properties customProperties;

    public static Builder builder() {
        return new Builder();
    }

    private ImapConfiguration(Optional<Long> appendLimit, boolean enableIdle, long idleTimeInterval, int concurrentRequests, int maxQueueSize, TimeUnit idleTimeIntervalUnit, ImmutableSet<Capability> disabledCaps, boolean isCondstoreEnable, boolean provisionDefaultMailboxes, Properties customProperties) {
        this.appendLimit = appendLimit;
        this.enableIdle = enableIdle;
        this.idleTimeInterval = idleTimeInterval;
        this.concurrentRequests = concurrentRequests;
        this.maxQueueSize = maxQueueSize;
        this.idleTimeIntervalUnit = idleTimeIntervalUnit;
        this.disabledCaps = disabledCaps;
        this.isCondstoreEnable = isCondstoreEnable;
        this.provisionDefaultMailboxes = provisionDefaultMailboxes;
        this.customProperties = customProperties;
    }

    public Optional<Long> getAppendLimit() {
        return this.appendLimit;
    }

    public int getConcurrentRequests() {
        return this.concurrentRequests;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public long getIdleTimeInterval() {
        return this.idleTimeInterval;
    }

    public TimeUnit getIdleTimeIntervalUnit() {
        return this.idleTimeIntervalUnit;
    }

    public ImmutableSet<Capability> getDisabledCaps() {
        return this.disabledCaps;
    }

    public boolean isEnableIdle() {
        return this.enableIdle;
    }

    public boolean isCondstoreEnable() {
        return this.isCondstoreEnable;
    }

    public boolean isProvisionDefaultMailboxes() {
        return this.provisionDefaultMailboxes;
    }

    public Duration idleTimeIntervalAsDuration() {
        return Duration.of(this.getIdleTimeInterval(), this.getIdleTimeIntervalUnit().toChronoUnit());
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ImapConfiguration) {
            ImapConfiguration that = (ImapConfiguration)obj;
            return Objects.equal((Object)that.isEnableIdle(), (Object)this.enableIdle) && Objects.equal((Object)that.getIdleTimeInterval(), (Object)this.idleTimeInterval) && Objects.equal(that.getAppendLimit(), this.appendLimit) && Objects.equal((Object)((Object)that.getIdleTimeIntervalUnit()), (Object)((Object)this.idleTimeIntervalUnit)) && Objects.equal((Object)that.getConcurrentRequests(), (Object)this.concurrentRequests) && Objects.equal((Object)that.getMaxQueueSize(), (Object)this.maxQueueSize) && Objects.equal(that.getDisabledCaps(), this.disabledCaps) && Objects.equal((Object)that.isProvisionDefaultMailboxes(), (Object)this.provisionDefaultMailboxes) && Objects.equal((Object)that.getCustomProperties(), (Object)this.customProperties) && Objects.equal((Object)that.isCondstoreEnable(), (Object)this.isCondstoreEnable);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enableIdle, this.idleTimeInterval, this.idleTimeIntervalUnit, this.disabledCaps, this.isCondstoreEnable, this.concurrentRequests, this.maxQueueSize, this.appendLimit, this.provisionDefaultMailboxes, this.customProperties});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appendLimit", this.appendLimit).add("enabledIdle", this.enableIdle).add("idleTimeInterval", this.idleTimeInterval).add("idleTimeIntervalUnit", (Object)this.idleTimeIntervalUnit).add("disabledCaps", this.disabledCaps).add("isCondstoreEnable", this.isCondstoreEnable).add("concurrentRequests", this.concurrentRequests).add("maxQueueSize", this.maxQueueSize).add("provisionDefaultMailboxes", this.provisionDefaultMailboxes).add("customProperties", (Object)this.customProperties).toString();
    }

    public static class Builder {
        private static final boolean DEFAULT_CONDSTORE_DISABLE = false;
        private Optional<Long> idleTimeInterval;
        private Optional<Long> appendLimit = Optional.empty();
        private Optional<Integer> concurrentRequests = Optional.empty();
        private Optional<Integer> maxQueueSize = Optional.empty();
        private Optional<TimeUnit> idleTimeIntervalUnit;
        private Optional<Boolean> enableIdle;
        private ImmutableSet<String> disabledCaps;
        private Optional<Boolean> isCondstoreEnable;
        private Optional<Boolean> provisionDefaultMailboxes;
        private Optional<Properties> customProperties;

        private static boolean noBlankString(String disableCap) {
            return !StringUtils.isBlank((CharSequence)disableCap);
        }

        private Builder() {
            this.idleTimeInterval = Optional.empty();
            this.idleTimeIntervalUnit = Optional.empty();
            this.enableIdle = Optional.empty();
            this.disabledCaps = ImmutableSet.of();
            this.isCondstoreEnable = Optional.empty();
            this.provisionDefaultMailboxes = Optional.empty();
            this.customProperties = Optional.empty();
        }

        public Builder idleTimeInterval(long idleTimeInterval) {
            Preconditions.checkArgument((idleTimeInterval > 0L ? 1 : 0) != 0, (Object)"The interval time should not be zero or negative");
            this.idleTimeInterval = Optional.of(idleTimeInterval);
            return this;
        }

        public Builder concurrentRequests(int concurrentRequests) {
            this.concurrentRequests = Optional.of(concurrentRequests);
            return this;
        }

        public Builder maxQueueSize(int maxQueueSize) {
            Preconditions.checkArgument((maxQueueSize > 0 ? 1 : 0) != 0, (Object)"maxQueueSize should not be negative");
            this.maxQueueSize = Optional.of(maxQueueSize);
            return this;
        }

        public Builder idleTimeIntervalUnit(TimeUnit idleTimeIntervalUnit) {
            this.idleTimeIntervalUnit = Optional.of(idleTimeIntervalUnit);
            return this;
        }

        public Builder enableIdle(Boolean enableIdle) {
            this.enableIdle = Optional.of(enableIdle);
            return this;
        }

        public Builder disabledCaps(ImmutableSet<String> disabledCaps) {
            this.disabledCaps = disabledCaps;
            return this;
        }

        public Builder disabledCaps(String ... disableCaps) {
            this.disabledCaps = ImmutableSet.copyOf((Object[])disableCaps);
            return this;
        }

        public Builder disabledCap(String disableCap) {
            this.disabledCaps = ImmutableSet.of((Object)disableCap);
            return this;
        }

        public Builder isCondstoreEnable(boolean isCondstoreEnable) {
            this.isCondstoreEnable = Optional.of(isCondstoreEnable);
            return this;
        }

        public Builder appendLimit(long appendLimit) {
            this.appendLimit = Optional.of(appendLimit);
            return this;
        }

        public Builder appendLimit(Optional<Integer> appendLimit) {
            this.appendLimit = appendLimit.map(Integer::longValue);
            return this;
        }

        public Builder isProvisionDefaultMailboxes(Boolean isProvisionDefaultMailboxes) {
            this.provisionDefaultMailboxes = Optional.of(isProvisionDefaultMailboxes);
            return this;
        }

        public Builder withCustomProperties(Properties customProperties) {
            this.customProperties = Optional.of(customProperties);
            return this;
        }

        public ImapConfiguration build() {
            ImmutableSet normalizeDisableCaps = (ImmutableSet)this.disabledCaps.stream().filter(Builder::noBlankString).map(StringUtils::normalizeSpace).map(Capability::of).collect(ImmutableSet.toImmutableSet());
            return new ImapConfiguration(this.appendLimit, this.enableIdle.orElse(true), this.idleTimeInterval.orElse(120L), this.concurrentRequests.orElse(128), this.maxQueueSize.orElse(4096), this.idleTimeIntervalUnit.orElse(DEFAULT_HEARTBEAT_INTERVAL_UNIT), (ImmutableSet<Capability>)normalizeDisableCaps, this.isCondstoreEnable.orElse(false), this.provisionDefaultMailboxes.orElse(true), this.customProperties.orElseGet(Properties::new));
        }
    }
}

