/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;

public enum MultiUpdateErrorBehavior {
    ATOMIC(0),
    ABORT_ON_ERROR(1),
    CONTINUE_ON_ERROR(2);

    private final int intValue;

    private MultiUpdateErrorBehavior(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static MultiUpdateErrorBehavior valueOf(int intValue) {
        for (MultiUpdateErrorBehavior v : MultiUpdateErrorBehavior.values()) {
            if (intValue != v.intValue) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public static MultiUpdateErrorBehavior forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "atomic": {
                return ATOMIC;
            }
            case "abortonerror": 
            case "abort-on-error": 
            case "abort_on_error": {
                return ABORT_ON_ERROR;
            }
            case "continueonerror": 
            case "continue-on-error": 
            case "continue_on_error": {
                return CONTINUE_ON_ERROR;
            }
        }
        return null;
    }
}

