/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

public final class PowerOf2Util {
    private PowerOf2Util() {
    }

    public static int align(int value, int pow2alignment) {
        return value + (pow2alignment - 1) & ~(pow2alignment - 1);
    }

    public static boolean isPowOf2(int value) {
        return Integer.bitCount(value) == 1;
    }

    public static boolean isAligned(long value, int pow2alignment) {
        if (!PowerOf2Util.isPowOf2(pow2alignment)) {
            throw new IllegalArgumentException("Alignment must be a power of 2");
        }
        return (value & (long)(pow2alignment - 1)) == 0L;
    }
}

