/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.conf;

import java.util.Locale;
import javax.sql.DataSource;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.jdbc.conf.FetchModeValue;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCSeqValue;
import org.apache.openjpa.jdbc.conf.MappingFactoryValue;
import org.apache.openjpa.jdbc.identifier.DBIdentifierUtil;
import org.apache.openjpa.jdbc.kernel.BatchingConstraintUpdateManager;
import org.apache.openjpa.jdbc.kernel.BatchingOperationOrderUpdateManager;
import org.apache.openjpa.jdbc.kernel.JDBCBrokerFactory;
import org.apache.openjpa.jdbc.kernel.PessimisticLockManager;
import org.apache.openjpa.jdbc.kernel.UpdateManager;
import org.apache.openjpa.jdbc.meta.MappingDefaults;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.schema.DataSourceFactory;
import org.apache.openjpa.jdbc.schema.DriverDataSource;
import org.apache.openjpa.jdbc.schema.SchemaFactory;
import org.apache.openjpa.jdbc.sql.AccessDictionary;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DBDictionaryFactory;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.EmpressDictionary;
import org.apache.openjpa.jdbc.sql.FoxProDictionary;
import org.apache.openjpa.jdbc.sql.H2Dictionary;
import org.apache.openjpa.jdbc.sql.HSQLDictionary;
import org.apache.openjpa.jdbc.sql.HerdDBDictionary;
import org.apache.openjpa.jdbc.sql.InformixDictionary;
import org.apache.openjpa.jdbc.sql.IngresDictionary;
import org.apache.openjpa.jdbc.sql.JDataStoreDictionary;
import org.apache.openjpa.jdbc.sql.MariaDBDictionary;
import org.apache.openjpa.jdbc.sql.MaxDBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.PointbaseDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.jdbc.sql.SQLFactory;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.jdbc.sql.SolidDBDictionary;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.conf.IntValue;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.StringListValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.util.UserException;
import serp.bytecode.Instruction;
import serp.bytecode.lowlevel.Entry;

public class JDBCConfigurationImpl
extends OpenJPAConfigurationImpl
implements JDBCConfiguration {
    public StringValue schema = this.addString("jdbc.Schema");
    public StringListValue schemas = this.addStringList("jdbc.Schemas");
    public IntValue transactionIsolation = this.addInt("jdbc.TransactionIsolation");
    public IntValue resultSetType;
    public IntValue fetchDirection;
    public FetchModeValue eagerFetchMode;
    public FetchModeValue subclassFetchMode;
    public IntValue lrsSize;
    public StringValue synchronizeMappings;
    public ObjectValue jdbcListenerPlugins;
    public ObjectValue connectionDecoratorPlugins;
    public PluginValue dbdictionaryPlugin;
    public ObjectValue updateManagerPlugin;
    public ObjectValue schemaFactoryPlugin;
    public ObjectValue sqlFactoryPlugin;
    public ObjectValue mappingDefaultsPlugin;
    public PluginValue driverDataSourcePlugin;
    public MappingFactoryValue mappingFactoryPlugin;
    public ObjectValue identifierUtilPlugin;
    private String firstUser = null;
    private String firstPass = null;
    private DecoratingDataSource dataSource = null;
    private DecoratingDataSource dataSource2 = null;
    private static final Localizer _loc = Localizer.forPackage(JDBCConfigurationImpl.class);

    public JDBCConfigurationImpl() {
        this(true);
    }

    public JDBCConfigurationImpl(boolean loadGlobals) {
        this(true, loadGlobals);
    }

    public JDBCConfigurationImpl(boolean derivations, boolean loadGlobals) {
        super(false, false);
        String[] aliases = new String[]{"default", String.valueOf(-1), "none", String.valueOf(0), "read-committed", String.valueOf(2), "read-uncommitted", String.valueOf(1), "repeatable-read", String.valueOf(4), "serializable", String.valueOf(8)};
        this.transactionIsolation.setAliases(aliases);
        this.transactionIsolation.setDefault(aliases[0]);
        this.transactionIsolation.set(-1);
        this.transactionIsolation.setAliasListComprehensive(true);
        this.resultSetType = this.addInt("jdbc.ResultSetType");
        aliases = new String[]{"forward-only", String.valueOf(1003), "scroll-sensitive", String.valueOf(1005), "scroll-insensitive", String.valueOf(1004)};
        this.resultSetType.setAliases(aliases);
        this.resultSetType.setDefault(aliases[0]);
        this.resultSetType.set(1003);
        this.resultSetType.setAliasListComprehensive(true);
        this.fetchDirection = this.addInt("jdbc.FetchDirection");
        aliases = new String[]{"forward", String.valueOf(1000), "reverse", String.valueOf(1001), "unknown", String.valueOf(1002)};
        this.fetchDirection.setAliases(aliases);
        this.fetchDirection.setDefault(aliases[0]);
        this.fetchDirection.set(1000);
        this.fetchDirection.setAliasListComprehensive(true);
        this.eagerFetchMode = new FetchModeValue("jdbc.EagerFetchMode");
        this.eagerFetchMode.setDefault("parallel");
        this.eagerFetchMode.set(2);
        this.addValue(this.eagerFetchMode);
        this.subclassFetchMode = new FetchModeValue("jdbc.SubclassFetchMode");
        this.subclassFetchMode.setDefault("join");
        this.subclassFetchMode.set(1);
        this.addValue(this.subclassFetchMode);
        this.lrsSize = this.addInt("jdbc.LRSSize");
        aliases = new String[]{"query", String.valueOf(2), "unknown", String.valueOf(0), "last", String.valueOf(1)};
        this.lrsSize.setAliases(aliases);
        this.lrsSize.setDefault(aliases[0]);
        this.lrsSize.set(2);
        this.lrsSize.setAliasListComprehensive(true);
        this.synchronizeMappings = this.addString("jdbc.SynchronizeMappings");
        aliases = new String[]{"false", null};
        this.synchronizeMappings.setAliases(aliases);
        this.synchronizeMappings.setDefault(aliases[0]);
        this.jdbcListenerPlugins = this.addPluginList("jdbc.JDBCListeners");
        this.jdbcListenerPlugins.setInstantiatingGetter("getJDBCListenerInstances");
        this.connectionDecoratorPlugins = this.addPluginList("jdbc.ConnectionDecorators");
        this.connectionDecoratorPlugins.setInstantiatingGetter("getConnectionDecoratorInstances");
        this.dbdictionaryPlugin = this.addPlugin("jdbc.DBDictionary", true);
        aliases = new String[]{"access", AccessDictionary.class.getName(), "db2", DB2Dictionary.class.getName(), "derby", DerbyDictionary.class.getName(), "empress", EmpressDictionary.class.getName(), "foxpro", FoxProDictionary.class.getName(), "h2", H2Dictionary.class.getName(), "hsql", HSQLDictionary.class.getName(), "informix", InformixDictionary.class.getName(), "ingres", IngresDictionary.class.getName(), "jdatastore", JDataStoreDictionary.class.getName(), "mariadb", MariaDBDictionary.class.getName(), "mysql", MySQLDictionary.class.getName(), "herddb", HerdDBDictionary.class.getName(), "oracle", OracleDictionary.class.getName(), "pointbase", PointbaseDictionary.class.getName(), "postgres", PostgresDictionary.class.getName(), "soliddb", SolidDBDictionary.class.getName(), "sqlserver", SQLServerDictionary.class.getName(), "sybase", SybaseDictionary.class.getName(), "maxdb", MaxDBDictionary.class.getName()};
        this.dbdictionaryPlugin.setAliases(aliases);
        this.dbdictionaryPlugin.setInstantiatingGetter("getDBDictionaryInstance");
        this.updateManagerPlugin = this.addPlugin("jdbc.UpdateManager", true);
        aliases = new String[]{"default", BatchingConstraintUpdateManager.class.getName(), "operation-order", "org.apache.openjpa.jdbc.kernel.OperationOrderUpdateManager", "constraint", "org.apache.openjpa.jdbc.kernel.ConstraintUpdateManager", "batching-constraint", BatchingConstraintUpdateManager.class.getName(), "batching-operation-order", BatchingOperationOrderUpdateManager.class.getName()};
        this.updateManagerPlugin.setAliases(aliases);
        this.updateManagerPlugin.setDefault(aliases[0]);
        this.updateManagerPlugin.setString(aliases[0]);
        this.updateManagerPlugin.setInstantiatingGetter("getUpdateManagerInstance");
        this.driverDataSourcePlugin = this.addPlugin("jdbc.DriverDataSource", false);
        aliases = new String[]{"auto", "org.apache.openjpa.jdbc.schema.AutoDriverDataSource", "simple", "org.apache.openjpa.jdbc.schema.SimpleDriverDataSource", "dbcp", "org.apache.openjpa.jdbc.schema.DBCPDriverDataSource"};
        this.driverDataSourcePlugin.setAliases(aliases);
        this.driverDataSourcePlugin.setDefault(aliases[0]);
        this.driverDataSourcePlugin.setString(aliases[0]);
        this.schemaFactoryPlugin = this.addPlugin("jdbc.SchemaFactory", true);
        aliases = new String[]{"dynamic", "org.apache.openjpa.jdbc.schema.DynamicSchemaFactory", "native", "org.apache.openjpa.jdbc.schema.LazySchemaFactory", "file", "org.apache.openjpa.jdbc.schema.FileSchemaFactory", "table", "org.apache.openjpa.jdbc.schema.TableSchemaFactory", "db", "org.apache.openjpa.jdbc.schema.TableSchemaFactory"};
        this.schemaFactoryPlugin.setAliases(aliases);
        this.schemaFactoryPlugin.setDefault(aliases[0]);
        this.schemaFactoryPlugin.setString(aliases[0]);
        this.schemaFactoryPlugin.setInstantiatingGetter("getSchemaFactoryInstance");
        this.sqlFactoryPlugin = this.addPlugin("jdbc.SQLFactory", true);
        aliases = new String[]{"default", "org.apache.openjpa.jdbc.sql.SQLFactoryImpl"};
        this.sqlFactoryPlugin.setAliases(aliases);
        this.sqlFactoryPlugin.setDefault(aliases[0]);
        this.sqlFactoryPlugin.setString(aliases[0]);
        this.sqlFactoryPlugin.setInstantiatingGetter("getSQLFactoryInstance");
        this.mappingFactoryPlugin = new MappingFactoryValue("jdbc.MappingFactory");
        this.addValue(this.mappingFactoryPlugin);
        this.mappingDefaultsPlugin = this.addPlugin("jdbc.MappingDefaults", true);
        aliases = new String[]{"default", "org.apache.openjpa.jdbc.meta.MappingDefaultsImpl"};
        this.mappingDefaultsPlugin.setAliases(aliases);
        this.mappingDefaultsPlugin.setDefault(aliases[0]);
        this.mappingDefaultsPlugin.setString(aliases[0]);
        this.mappingDefaultsPlugin.setInstantiatingGetter("getMappingDefaultsInstance");
        this.brokerFactoryPlugin.setAlias("jdbc", JDBCBrokerFactory.class.getName());
        this.brokerFactoryPlugin.setDefault("jdbc");
        this.brokerFactoryPlugin.setString("jdbc");
        this.metaRepositoryPlugin.setAlias("default", "org.apache.openjpa.jdbc.meta.MappingRepository");
        this.metaRepositoryPlugin.setDefault("default");
        this.metaRepositoryPlugin.setString("default");
        this.lockManagerPlugin.setAlias("pessimistic", PessimisticLockManager.class.getName());
        this.lockManagerPlugin.setDefault("pessimistic");
        this.lockManagerPlugin.setString("pessimistic");
        this.savepointManagerPlugin.setAlias("jdbc", "org.apache.openjpa.jdbc.kernel.JDBC3SavepointManager");
        this.seqPlugin.setAliases(JDBCSeqValue.ALIASES);
        this.seqPlugin.setDefault(JDBCSeqValue.ALIASES[0]);
        this.seqPlugin.setString(JDBCSeqValue.ALIASES[0]);
        this.preparedQueryCachePlugin = this.addPlugin("jdbc.QuerySQLCache", true);
        aliases = new String[]{"true", "org.apache.openjpa.jdbc.kernel.PreparedQueryCacheImpl", "false", null};
        this.preparedQueryCachePlugin.setAliases(aliases);
        this.preparedQueryCachePlugin.setAliasListComprehensive(true);
        this.preparedQueryCachePlugin.setDefault(aliases[0]);
        this.preparedQueryCachePlugin.setClassName(aliases[1]);
        this.preparedQueryCachePlugin.setDynamic(true);
        this.preparedQueryCachePlugin.setInstantiatingGetter("getQuerySQLCacheInstance");
        this.finderCachePlugin = this.addPlugin("jdbc.FinderCache", true);
        aliases = new String[]{"true", "org.apache.openjpa.jdbc.kernel.FinderCacheImpl", "false", null};
        this.finderCachePlugin.setAliases(aliases);
        this.finderCachePlugin.setAliasListComprehensive(true);
        this.finderCachePlugin.setDefault(aliases[0]);
        this.finderCachePlugin.setClassName(aliases[1]);
        this.finderCachePlugin.setDynamic(true);
        this.finderCachePlugin.setInstantiatingGetter("getFinderCacheInstance");
        this.identifierUtilPlugin = this.addPlugin("jdbc.IdentifierUtil", true);
        aliases = new String[]{"default", "org.apache.openjpa.jdbc.identifier.DBIdentifierUtilImpl"};
        this.identifierUtilPlugin.setAliases(aliases);
        this.identifierUtilPlugin.setDefault(aliases[0]);
        this.identifierUtilPlugin.setString(aliases[0]);
        this.identifierUtilPlugin.setInstantiatingGetter("getIdentifierUtilInstance");
        try {
            Entry.class.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Instruction.class.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.supportedOptions().add("openjpa.option.SQL");
        this.supportedOptions().add("openjpa.option.JDBCConnection");
        this.supportedOptions().remove("openjpa.option.IncrementValue");
        this.supportedOptions().remove("openjpa.option.NullContainer");
        if (derivations) {
            ProductDerivations.beforeConfigurationLoad(this);
        }
        if (loadGlobals) {
            this.loadGlobals();
        }
    }

    public JDBCConfigurationImpl(JDBCConfiguration conf) {
        this(true, false);
        if (conf != null) {
            this.fromProperties(conf.toProperties(false));
        }
    }

    @Override
    public void setSchema(String schema) {
        this.schema.setString(schema);
    }

    @Override
    public String getSchema() {
        return this.schema.getString();
    }

    @Override
    public void setSchemas(String schemas) {
        this.schemas.setString(schemas);
    }

    @Override
    public String getSchemas() {
        return this.schemas.getString();
    }

    @Override
    public void setSchemas(String[] schemas) {
        this.schemas.set(schemas);
    }

    @Override
    public String[] getSchemasList() {
        return this.schemas.get();
    }

    @Override
    public void setTransactionIsolation(String transactionIsolation) {
        this.transactionIsolation.setString(transactionIsolation);
    }

    @Override
    public String getTransactionIsolation() {
        return this.transactionIsolation.getString();
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation.set(transactionIsolation);
    }

    @Override
    public int getTransactionIsolationConstant() {
        return this.transactionIsolation.get();
    }

    @Override
    public void setResultSetType(String resultSetType) {
        this.resultSetType.setString(resultSetType);
    }

    @Override
    public String getResultSetType() {
        return this.resultSetType.getString();
    }

    @Override
    public void setResultSetType(int resultSetType) {
        this.resultSetType.set(resultSetType);
    }

    @Override
    public int getResultSetTypeConstant() {
        return this.resultSetType.get();
    }

    @Override
    public void setFetchDirection(String fetchDirection) {
        this.fetchDirection.setString(fetchDirection);
    }

    @Override
    public String getFetchDirection() {
        return this.fetchDirection.getString();
    }

    @Override
    public void setFetchDirection(int fetchDirection) {
        this.fetchDirection.set(fetchDirection);
    }

    @Override
    public int getFetchDirectionConstant() {
        return this.fetchDirection.get();
    }

    @Override
    public void setEagerFetchMode(String eagerFetchMode) {
        this.eagerFetchMode.setString(eagerFetchMode);
    }

    @Override
    public String getEagerFetchMode() {
        return this.eagerFetchMode.getString();
    }

    @Override
    public void setEagerFetchMode(int eagerFetchMode) {
        this.eagerFetchMode.set(eagerFetchMode);
    }

    @Override
    public int getEagerFetchModeConstant() {
        return this.eagerFetchMode.get();
    }

    @Override
    public void setSubclassFetchMode(String subclassFetchMode) {
        this.subclassFetchMode.setString(subclassFetchMode);
    }

    @Override
    public String getSubclassFetchMode() {
        return this.subclassFetchMode.getString();
    }

    @Override
    public void setSubclassFetchMode(int subclassFetchMode) {
        this.subclassFetchMode.set(subclassFetchMode);
    }

    @Override
    public int getSubclassFetchModeConstant() {
        return this.subclassFetchMode.get();
    }

    @Override
    public void setLRSSize(String lrsSize) {
        this.lrsSize.setString(lrsSize);
    }

    @Override
    public String getLRSSize() {
        return this.lrsSize.getString();
    }

    @Override
    public void setLRSSize(int lrsSize) {
        this.lrsSize.set(lrsSize);
    }

    @Override
    public int getLRSSizeConstant() {
        return this.lrsSize.get();
    }

    @Override
    public void setSynchronizeMappings(String synchronizeMappings) {
        this.synchronizeMappings.set(synchronizeMappings);
    }

    @Override
    public String getSynchronizeMappings() {
        return this.synchronizeMappings.get();
    }

    @Override
    public void setJDBCListeners(String jdbcListeners) {
        this.jdbcListenerPlugins.setString(jdbcListeners);
    }

    @Override
    public String getJDBCListeners() {
        return this.jdbcListenerPlugins.getString();
    }

    @Override
    public void setJDBCListeners(JDBCListener[] listeners) {
        this.jdbcListenerPlugins.set(listeners);
    }

    @Override
    public JDBCListener[] getJDBCListenerInstances() {
        if (this.jdbcListenerPlugins.get() == null) {
            this.jdbcListenerPlugins.instantiate(JDBCListener.class, this);
        }
        return (JDBCListener[])this.jdbcListenerPlugins.get();
    }

    @Override
    public void setConnectionDecorators(String connectionDecorators) {
        this.connectionDecoratorPlugins.setString(connectionDecorators);
    }

    @Override
    public String getConnectionDecorators() {
        return this.connectionDecoratorPlugins.getString();
    }

    @Override
    public void setConnectionDecorators(ConnectionDecorator[] decorators) {
        this.connectionDecoratorPlugins.set(decorators);
    }

    @Override
    public ConnectionDecorator[] getConnectionDecoratorInstances() {
        if (this.connectionDecoratorPlugins.get() == null) {
            this.connectionDecoratorPlugins.instantiate(ConnectionDecorator.class, this);
        }
        return (ConnectionDecorator[])this.connectionDecoratorPlugins.get();
    }

    @Override
    public void setDBDictionary(String dbdictionary) {
        this.dbdictionaryPlugin.setString(dbdictionary);
    }

    @Override
    public String getDBDictionary() {
        return this.dbdictionaryPlugin.getString();
    }

    @Override
    public void setDBDictionary(DBDictionary dbdictionary) {
        if (this.connectionFactory.get() != null || this.connectionFactory2.get() != null) {
            throw new IllegalStateException();
        }
        this.dbdictionaryPlugin.set(dbdictionary);
    }

    @Override
    public DBDictionary getDBDictionaryInstance() {
        DBDictionary dbdictionary = (DBDictionary)this.dbdictionaryPlugin.get();
        if (dbdictionary == null) {
            String clsName = this.dbdictionaryPlugin.getClassName();
            String props = this.dbdictionaryPlugin.getProperties();
            if (!StringUtil.isEmpty(clsName)) {
                dbdictionary = DBDictionaryFactory.newDBDictionary((JDBCConfiguration)this, clsName, props);
            } else {
                dbdictionary = DBDictionaryFactory.calculateDBDictionary(this, this.getConnectionURL(), this.getConnectionDriverName(), props);
                if (dbdictionary == null) {
                    Log log = this.getLog("openjpa.jdbc.JDBC");
                    if (log.isTraceEnabled()) {
                        Localizer loc = Localizer.forPackage(JDBCConfigurationImpl.class);
                        log.trace(loc.get("connecting-for-dictionary"));
                    }
                    DecoratingDataSource ds = this.createConnectionFactory();
                    dbdictionary = DBDictionaryFactory.newDBDictionary((JDBCConfiguration)this, this.getDataSource(null, ds), props);
                }
            }
            this.dbdictionaryPlugin.set(dbdictionary, true);
        }
        return dbdictionary;
    }

    @Override
    public void setUpdateManager(String updateManager) {
        this.updateManagerPlugin.setString(updateManager);
    }

    @Override
    public String getUpdateManager() {
        return this.updateManagerPlugin.getString();
    }

    @Override
    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManagerPlugin.set(updateManager);
    }

    @Override
    public UpdateManager getUpdateManagerInstance() {
        if (this.updateManagerPlugin.get() == null) {
            this.updateManagerPlugin.instantiate(UpdateManager.class, this);
        }
        return (UpdateManager)this.updateManagerPlugin.get();
    }

    @Override
    public void setDriverDataSource(String driverDataSource) {
        this.driverDataSourcePlugin.setString(driverDataSource);
    }

    @Override
    public String getDriverDataSource() {
        return this.driverDataSourcePlugin.getString();
    }

    @Override
    public DriverDataSource newDriverDataSourceInstance() {
        return (DriverDataSource)this.driverDataSourcePlugin.instantiate(DriverDataSource.class, this);
    }

    @Override
    public void setSchemaFactory(String schemaFactory) {
        this.schemaFactoryPlugin.setString(schemaFactory);
    }

    @Override
    public String getSchemaFactory() {
        return this.schemaFactoryPlugin.getString();
    }

    @Override
    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactoryPlugin.set(schemaFactory);
    }

    @Override
    public SchemaFactory getSchemaFactoryInstance() {
        if (this.schemaFactoryPlugin.get() == null) {
            this.schemaFactoryPlugin.instantiate(SchemaFactory.class, this);
        }
        return (SchemaFactory)this.schemaFactoryPlugin.get();
    }

    @Override
    public void setSQLFactory(String sqlFactory) {
        this.sqlFactoryPlugin.setString(sqlFactory);
    }

    @Override
    public String getSQLFactory() {
        return this.sqlFactoryPlugin.getString();
    }

    @Override
    public void setSQLFactory(SQLFactory sqlFactory) {
        this.sqlFactoryPlugin.set(sqlFactory);
    }

    @Override
    public SQLFactory getSQLFactoryInstance() {
        if (this.sqlFactoryPlugin.get() == null) {
            this.sqlFactoryPlugin.instantiate(SQLFactory.class, this);
        }
        return (SQLFactory)this.sqlFactoryPlugin.get();
    }

    @Override
    public String getMappingFactory() {
        return this.mappingFactoryPlugin.getString();
    }

    @Override
    public void setMappingFactory(String mapping) {
        this.mappingFactoryPlugin.setString(mapping);
    }

    @Override
    public MetaDataFactory newMetaDataFactoryInstance() {
        return this.mappingFactoryPlugin.instantiateMetaDataFactory(this, this.metaFactoryPlugin, this.getMapping());
    }

    @Override
    public void setMappingDefaults(String mapping) {
        this.mappingDefaultsPlugin.setString(mapping);
    }

    @Override
    public String getMappingDefaults() {
        return this.mappingDefaultsPlugin.getString();
    }

    @Override
    public void setMappingDefaults(MappingDefaults mapping) {
        this.mappingDefaultsPlugin.set(mapping);
    }

    @Override
    public MappingDefaults getMappingDefaultsInstance() {
        if (this.mappingDefaultsPlugin.get() == null) {
            this.mappingDefaultsPlugin.instantiate(MappingDefaults.class, this);
        }
        return (MappingDefaults)this.mappingDefaultsPlugin.get();
    }

    @Override
    public MappingRepository getMappingRepositoryInstance() {
        return (MappingRepository)this.getMetaDataRepositoryInstance();
    }

    @Override
    public MappingRepository newMappingRepositoryInstance() {
        return (MappingRepository)this.newMetaDataRepositoryInstance();
    }

    @Override
    public BrokerImpl newBrokerInstance(String user, String pass) {
        BrokerImpl broker = super.newBrokerInstance(user, pass);
        if (broker != null && user != null && this.firstUser == null) {
            this.firstUser = user;
            this.firstPass = pass;
        }
        return broker;
    }

    @Override
    public Object getConnectionFactory() {
        if (this.dataSource == null) {
            DecoratingDataSource ds = this.createConnectionFactory();
            this.dataSource = DataSourceFactory.installDBDictionary(this.getDBDictionaryInstance(), ds, this, false);
        }
        return this.dataSource;
    }

    @Override
    public void setConnectionFactory(Object factory) {
        if (factory == this.connectionFactory.get()) {
            return;
        }
        if (factory != null) {
            DecoratingDataSource ds = this.setupConnectionFactory((DataSource)factory, false);
            this.dataSource = DataSourceFactory.installDBDictionary(this.getDBDictionaryInstance(), ds, this, false);
        } else {
            this.connectionFactory.set(null);
        }
    }

    private DecoratingDataSource setupConnectionFactory(DataSource ds, boolean factory2) {
        if (ds == null) {
            return null;
        }
        DecoratingDataSource dds = ds instanceof DecoratingDataSource ? (DecoratingDataSource)ds : DataSourceFactory.decorateDataSource(ds, this, factory2);
        if (!factory2 && this.connectionFactory.get() != ds) {
            this.connectionFactory.set(dds, true);
        } else if (factory2 && this.connectionFactory2.get() != ds) {
            this.connectionFactory2.set(dds, true);
        }
        return dds;
    }

    @Override
    public Object getConnectionFactory2() {
        if (this.dataSource2 == null) {
            String driver;
            Object obj = super.getConnectionFactory2();
            DataSource ds = null;
            if (obj != null) {
                if (obj instanceof DataSource) {
                    ds = (DataSource)obj;
                } else {
                    Log log = this.getLog("openjpa.jdbc.JDBC");
                    if (log.isTraceEnabled()) {
                        Localizer loc = Localizer.forPackage(JDBCConfigurationImpl.class);
                        log.trace(loc.get("unknown-datasource", this.getConnectionFactory2Name(), obj.getClass().getName()));
                    }
                }
            }
            if (ds == null && !StringUtil.isEmpty(driver = this.getConnection2DriverName())) {
                ds = DataSourceFactory.newDataSource(this, true);
            }
            if (ds != null) {
                DecoratingDataSource dds = this.setupConnectionFactory(ds, true);
                this.dataSource2 = DataSourceFactory.installDBDictionary(this.getDBDictionaryInstance(), dds, this, true);
            }
        }
        return this.dataSource2;
    }

    @Override
    public void setConnectionFactory2(Object factory) {
        if (factory == this.connectionFactory2.get()) {
            return;
        }
        if (factory != null) {
            DecoratingDataSource ds = this.setupConnectionFactory((DataSource)factory, true);
            this.dataSource2 = DataSourceFactory.installDBDictionary(this.getDBDictionaryInstance(), ds, this, true);
        } else {
            this.connectionFactory2.set(null);
        }
    }

    public DecoratingDataSource createConnectionFactory() {
        DataSource ds = (DataSource)this.connectionFactory.get();
        Log log = this.getLog("openjpa.jdbc.JDBC");
        if (ds != null) {
            if (log.isTraceEnabled()) {
                log.trace("createConnectionFactory: DataSource:" + ds);
            }
            return this.setupConnectionFactory(ds, false);
        }
        if (log.isTraceEnabled()) {
            log.trace("createConnectionFactory: connectionFactory not created yet, attempt JNDI lookup...");
        }
        if ((ds = (DataSource)super.getConnectionFactory()) == null) {
            if (log.isTraceEnabled()) {
                log.trace("createConnectionFactory: JNDI lookup failed, attempt DataSource properties...");
            }
            ds = DataSourceFactory.newDataSource(this, false);
        }
        if (log.isTraceEnabled()) {
            log.trace("createConnectionFactory: DataSource=" + ds);
        }
        return this.setupConnectionFactory(ds, false);
    }

    @Override
    public DataSource getDataSource(StoreContext ctx) {
        Log log = this.getLog("openjpa.Runtime");
        DataSource ds = null;
        if (ctx != null && StringUtil.isNotEmpty(ctx.getConnectionFactoryName())) {
            ds = this.getDataSource(ctx, (DataSource)ctx.getConnectionFactory());
            if (ds == null) {
                throw new UserException(_loc.get("invalid-datasource", ctx.getConnectionFactoryName())).setFatal(true);
            }
            if (!(ds instanceof DecoratingDataSource)) {
                ds = DataSourceFactory.decorateDataSource(ds, this, false);
            }
            if (log.isTraceEnabled()) {
                log.trace("Found datasource1: " + ds + " from StoreContext using jndiName: " + ctx.getConnectionFactory2Name());
            }
            return ds;
        }
        ds = this.getDataSource(ctx, (DataSource)this.getConnectionFactory());
        if (log.isTraceEnabled()) {
            log.trace("Found datasource1: " + ds + " from configuration. StoreContext: " + ctx);
        }
        return ds;
    }

    @Override
    public DataSource getDataSource2(StoreContext ctx) {
        Log log = this.getLog("openjpa.Runtime");
        DataSource ds = null;
        if (ctx != null && StringUtil.isNotEmpty(ctx.getConnectionFactory2Name())) {
            ds = (DataSource)ctx.getConnectionFactory2();
            if (ds == null) {
                throw new UserException(_loc.get("invalid-datasource", ctx.getConnectionFactory2Name())).setFatal(true);
            }
            if (!(ds instanceof DecoratingDataSource)) {
                ds = DataSourceFactory.decorateDataSource(ds, this, false);
            }
            if (log.isTraceEnabled()) {
                log.trace("Found datasource2: " + ds + " from StoreContext using jndiName: " + ctx.getConnectionFactory2Name());
            }
            return ds;
        }
        ds = (DataSource)this.getConnectionFactory2();
        if (log.isTraceEnabled()) {
            log.trace("Found datasource 2: " + ds + " from config. StoreContext: " + ctx);
        }
        if (ds == null) {
            if (log.isTraceEnabled()) {
                log.trace("Trying datasource1");
            }
            return this.getDataSource(ctx);
        }
        String user = this.getConnection2UserName();
        String pass = this.getConnection2Password();
        if (user == null && pass == null) {
            if (ctx == null) {
                user = this.firstUser;
                pass = this.firstPass;
            } else {
                user = ctx.getConnectionUserName();
                pass = ctx.getConnectionPassword();
            }
        }
        return DataSourceFactory.defaultsDataSource(ds, user, pass);
    }

    private DataSource getDataSource(StoreContext ctx, DataSource ds) {
        String pass;
        String user;
        if (ctx == null) {
            user = this.getConnectionUserName();
            if (user == null) {
                user = this.firstUser;
            }
            if ((pass = this.getConnectionPassword()) == null) {
                pass = this.firstPass;
            }
        } else {
            user = ctx.getConnectionUserName();
            pass = ctx.getConnectionPassword();
        }
        return DataSourceFactory.defaultsDataSource(ds, user, pass);
    }

    @Override
    protected void preClose() {
        if (this.dataSource != null) {
            this.getDBDictionaryInstance().closeDataSource(this.dataSource);
            this.connectionFactory.set(null, true);
        }
        if (this.dataSource2 != null) {
            this.getDBDictionaryInstance().closeDataSource(this.dataSource);
            this.connectionFactory2.set(null, true);
        }
        super.preClose();
    }

    @Override
    protected boolean isInvalidProperty(String propName) {
        String[] prefixes;
        if (super.isInvalidProperty(propName)) {
            return true;
        }
        for (String prefix : prefixes = ProductDerivations.getConfigurationPrefixes()) {
            if (!propName.toLowerCase(Locale.ENGLISH).startsWith(prefix + ".jdbc")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getIdentifierUtil() {
        return this.identifierUtilPlugin.getString();
    }

    @Override
    public DBIdentifierUtil getIdentifierUtilInstance() {
        if (this.identifierUtilPlugin.get() == null) {
            this.identifierUtilPlugin.instantiate(DBIdentifierUtil.class, this);
        }
        return (DBIdentifierUtil)this.identifierUtilPlugin.get();
    }

    @Override
    public void setIdentifierUtil(DBIdentifierUtil util2) {
        this.identifierUtilPlugin.set(util2);
    }
}

