/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.replication.LogSequenceNumber;

final class KeepAliveMessage {
    private static final byte KEEP_ALIVE_REPLY = 114;
    private static final int NO_REPLY_REQUIRED = 0;
    private static final int REPLY_REQUIRED = 1;
    private final LogSequenceNumber received;
    private final LogSequenceNumber flushed;
    private final LogSequenceNumber applied;
    private final long systemClock;
    private boolean replyRequired;

    KeepAliveMessage(LogSequenceNumber received, LogSequenceNumber flushed, LogSequenceNumber applied, long systemClock, boolean replyRequired) {
        this.received = received;
        this.flushed = flushed;
        this.applied = applied;
        this.systemClock = systemClock;
        this.replyRequired = replyRequired;
    }

    public ByteBuf encode(ByteBufAllocator allocator) {
        ByteBuf out = allocator.buffer(34);
        out.writeByte(114);
        out.writeLong(this.received.asLong());
        out.writeLong(this.flushed.asLong());
        out.writeLong(this.applied.asLong());
        out.writeLong(this.systemClock);
        if (this.replyRequired) {
            out.writeByte(1);
        } else {
            out.writeByte(this.received == LogSequenceNumber.INVALID_LSN ? 1 : 0);
        }
        return out;
    }
}

