/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ChiSquareHeuristic
implements PlainJsonSerializable {
    private final boolean backgroundIsSuperset;
    private final boolean includeNegatives;
    public static final JsonpDeserializer<ChiSquareHeuristic> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChiSquareHeuristic::setupChiSquareHeuristicDeserializer);

    private ChiSquareHeuristic(Builder builder) {
        this.backgroundIsSuperset = ApiTypeHelper.requireNonNull(builder.backgroundIsSuperset, this, "backgroundIsSuperset");
        this.includeNegatives = ApiTypeHelper.requireNonNull(builder.includeNegatives, this, "includeNegatives");
    }

    public static ChiSquareHeuristic of(Function<Builder, ObjectBuilder<ChiSquareHeuristic>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean backgroundIsSuperset() {
        return this.backgroundIsSuperset;
    }

    public final boolean includeNegatives() {
        return this.includeNegatives;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("background_is_superset");
        generator.write(this.backgroundIsSuperset);
        generator.writeKey("include_negatives");
        generator.write(this.includeNegatives);
    }

    protected static void setupChiSquareHeuristicDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backgroundIsSuperset, JsonpDeserializer.booleanDeserializer(), "background_is_superset");
        op.add(Builder::includeNegatives, JsonpDeserializer.booleanDeserializer(), "include_negatives");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ChiSquareHeuristic> {
        private Boolean backgroundIsSuperset;
        private Boolean includeNegatives;

        public final Builder backgroundIsSuperset(boolean value) {
            this.backgroundIsSuperset = value;
            return this;
        }

        public final Builder includeNegatives(boolean value) {
            this.includeNegatives = value;
            return this;
        }

        @Override
        public ChiSquareHeuristic build() {
            this._checkSingleUse();
            return new ChiSquareHeuristic(this);
        }
    }
}

