/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuples;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\f\u0018\u0001\u0011B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A\u0001\n\u0001B\u0001B\u0003%\u0011\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003]\u0001\u0011\u0005S\fC\u0003]\u0001\u0011\u0005S\u0010\u0003\u0004]\u0001\u0011\u0005\u0013q\u0002\u0005\u00079\u0002!\t%!\f\t\rq\u0003A\u0011IA.\u0011\u0019a\u0006\u0001\"\u0011\u0002h!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!a#\u0001\t\u0003\ni\tC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005u\u0005\u0001\"\u0011\u0002 \"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003\u007f\u0003A\u0011IAa\u0011\u001d\t)\r\u0001C!\u0003\u000f\u0014A\u0003U1tgRC'o\\;hQ\ncwNY*u_J,'B\u0001\r\u001a\u00035!W\rZ;qY&\u001c\u0017\r^5p]*\u0011!dG\u0001\u0005E2|'M\u0003\u0002\u001d;\u000511/\u001a:wKJT!AH\u0010\u0002\u000b)\fW.Z:\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\u0002\u0001'\r\u0001Q%\f\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019y%M[3diB\u0011aFM\u0007\u0002_)\u0011\u0001'M\u0001\u0004CBL'B\u0001\u000e\u001e\u0013\t\u0019tFA\u0005CY>\u00147\u000b^8sK\u0006a!\r\\8c'R|'/\u001a#B\u001fB\u0011aFN\u0005\u0003o=\u0012AB\u00117pEN#xN]3E\u0003>\u000b\u0011\u0003Z3gCVdGOQ;dW\u0016$h*Y7f!\tq#(\u0003\u0002<_\tQ!)^2lKRt\u0015-\\3)\t\tiTI\u0012\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000ba!\u001b8kK\u000e$(\"\u0001\"\u0002\u000f)\f7.\u0019:uC&\u0011Ai\u0010\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0002\u000f\u0006iA-\u001a4bk2$()^2lKR\fQB\u00197pE&#g)Y2u_JL\bC\u0001&N\u001d\tq3*\u0003\u0002M_\u00051!\t\\8c\u0013\u0012L!AT(\u0003\u000f\u0019\u000b7\r^8ss*\u0011AjL\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI#Vk\u0016\t\u0003'\u0002i\u0011a\u0006\u0005\u0006i\u0011\u0001\r!\u000e\u0005\u0006q\u0011\u0001\r!\u000f\u0015\u0005+v*e\tC\u0003I\t\u0001\u0007\u0011\n\u000b\u0002\u00053B\u0011aHW\u0005\u00037~\u0012a!\u00138kK\u000e$\u0018\u0001B:bm\u0016$BAX4jiB\u0019qL\u00193\u000e\u0003\u0001T!!Y\u0011\u0002\u001fI,\u0017m\u0019;jm\u0016\u001cHO]3b[NL!a\u00191\u0003\u0013A+(\r\\5tQ\u0016\u0014\bC\u0001\u0018f\u0013\t1wF\u0001\u0004CY>\u0014\u0017\n\u001a\u0005\u0006Q\u0016\u0001\r!O\u0001\u000bEV\u001c7.\u001a;OC6,\u0007\"\u00026\u0006\u0001\u0004Y\u0017\u0001\u00023bi\u0006\u00042\u0001\\8r\u001b\u0005i'\"\u00018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Al'!B!se\u0006L\bC\u00017s\u0013\t\u0019XN\u0001\u0003CsR,\u0007\"B;\u0006\u0001\u00041\u0018!D:u_J\fw-\u001a)pY&\u001c\u0017\u0010\u0005\u0002xu:\u0011a\u0006_\u0005\u0003s>\n\u0011B\u00117pEN#xN]3\n\u0005md(!D*u_J\fw-\u001a)pY&\u001c\u0017P\u0003\u0002z_Q)aL`@\u0002\u000e!)\u0001N\u0002a\u0001s!1!N\u0002a\u0001\u0003\u0003\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fI\u0013AA5p\u0013\u0011\tY!!\u0002\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006k\u001a\u0001\rA\u001e\u000b\b=\u0006E\u00111CA\u0016\u0011\u0015Aw\u00011\u0001:\u0011\u0019Qw\u00011\u0001\u0002\u0016A!\u0011qCA\u0014\u001b\t\tIB\u0003\u0003\u0002\b\u0005m!\u0002BA\u000f\u0003?\taaY8n[>t'\u0002BA\u0011\u0003G\taaZ8pO2,'BAA\u0013\u0003\r\u0019w.\\\u0005\u0005\u0003S\tIB\u0001\u0006CsR,7k\\;sG\u0016DQ!^\u0004A\u0002Y$\u0012BXA\u0018\u0003c\t\u0019$!\u0017\t\u000b!D\u0001\u0019A\u001d\t\u000b)D\u0001\u0019A6\t\u000f\u0005U\u0002\u00021\u0001\u00028\u0005q!\r\\8c\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\b#BA\u001d\u0003+ZgbAA\u001eq:!\u0011QHA*\u001d\u0011\ty$!\u0015\u000f\t\u0005\u0005\u0013q\n\b\u0005\u0003\u0007\niE\u0004\u0003\u0002F\u0005-SBAA$\u0015\r\tIeI\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001I\u0011\n\u0005yy\u0012B\u0001\u000e\u001e\u0013\t\u0001\u0014'C\u0002\u0002Xq\u0014aB\u00117pE&#\u0007K]8wS\u0012,'\u000fC\u0003v\u0011\u0001\u0007a\u000fF\u0005_\u0003;\ny&!\u0019\u0002f!)\u0001.\u0003a\u0001s!1!.\u0003a\u0001\u0003+Aq!!\u000e\n\u0001\u0004\t\u0019\u0007\u0005\u0004\u0002:\u0005U\u0013Q\u0003\u0005\u0006k&\u0001\rA\u001e\u000b\n=\u0006%\u00141NA7\u0003cBQ\u0001\u001b\u0006A\u0002eBaA\u001b\u0006A\u0002\u0005\u0005\u0001bBA\u001b\u0015\u0001\u0007\u0011q\u000e\t\u0007\u0003s\t)&!\u0001\t\u000bUT\u0001\u0019\u0001<\u0002\u0015]LG\u000f\u001b\"m_\nLE-\u0006\u0002\u0002p\u0005\u0019r/\u001b;i\u00052|'-\u00133CsR,\u0017I\u001d:bsV\u0011\u0011qG\u0001\u0015o&$\bN\u00117pE&#')\u001f;f'>,(oY3\u0016\u0005\u0005\r\u0014!\u0003:fC\u0012\u0014\u0015\u0010^3t)\u0019\t\u0019)!\"\u0002\bB\u0019qLY6\t\u000b!t\u0001\u0019A\u001d\t\r\u0005%e\u00021\u0001e\u0003\u0019\u0011Gn\u001c2JI\u0006!!/Z1e)\u0019\t\t!a$\u0002\u0012\")\u0001n\u0004a\u0001s!1\u0011\u0011R\bA\u0002\u0011\fAB]3bIJ+\u0017m\u0019;jm\u0016$b!a&\u0002\u001a\u0006m\u0005\u0003B0c\u0003\u0003AQ\u0001\u001b\tA\u0002eBa!!#\u0011\u0001\u0004!\u0017\u0001F4fi\u0012+g-Y;mi\n+8m[3u\u001d\u0006lW\rF\u0001:\u00031!W\r\\3uK\n+8m[3u)\u0011\t)+!,\u0011\t}\u0013\u0017q\u0015\t\u0004M\u0005%\u0016bAAVO\t!ak\\5e\u0011\u0015A'\u00031\u0001:\u0003\u0019!W\r\\3uKR1\u00111WA^\u0003{\u0003Ba\u00182\u00026B\u0019a%a.\n\u0007\u0005evEA\u0004C_>dW-\u00198\t\u000b!\u001c\u0002\u0019A\u001d\t\r\u0005%5\u00031\u0001e\u0003-a\u0017n\u001d;Ck\u000e\\W\r^:\u0015\u0005\u0005\r\u0007cA0cs\u0005IA.[:u\u00052|'m\u001d\u000b\u0004=\u0006%\u0007\"\u00025\u0016\u0001\u0004I\u0004")
public class PassThroughBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;

    public Publisher<BlobId> save(BucketName bucketName, String data, BlobStore.StoragePolicy storagePolicy) {
        return super.save(bucketName, data, storagePolicy);
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.readBytes(bucketName, blobId, storagePolicy);
    }

    public InputStream read(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.read(bucketName, blobId, storagePolicy);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.readReactive(bucketName, blobId, storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data, this.withBlobIdByteArray(), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data, this.withBlobId(), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data, this.withBlobIdByteSource(), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.BlobIdProvider<byte[]> blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.apply(blobIdProvider.apply((Object)data)).map((Function1 & Serializable)x$1 -> (BlobId)x$1.getT1()).flatMap((Function1 & Serializable)blobId -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just(blobId)));
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.BlobIdProvider<ByteSource> blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.apply(blobIdProvider.apply((Object)data)).map((Function1 & Serializable)x$2 -> (BlobId)x$2.getT1()).flatMap((Function1 & Serializable)blobId -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just(blobId))).subscribeOn(Schedulers.boundedElastic());
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.BlobIdProvider<InputStream> blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.apply(blobIdProvider.apply((Object)data)).subscribeOn(Schedulers.boundedElastic()).flatMap((Function1 & Serializable)tuple -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, (BlobId)tuple.getT1(), (InputStream)tuple.getT2())).then(SMono$.MODULE$.just(tuple.getT1())));
    }

    private BlobStore.BlobIdProvider<InputStream> withBlobId() {
        return data -> SMono$.MODULE$.just((Object)Tuples.of((Object)$this.blobIdFactory.of(UUID.randomUUID().toString()), (Object)data));
    }

    private BlobStore.BlobIdProvider<byte[]> withBlobIdByteArray() {
        return data -> SMono$.MODULE$.just((Object)Tuples.of((Object)$this.blobIdFactory.of(UUID.randomUUID().toString()), (Object)data));
    }

    private BlobStore.BlobIdProvider<ByteSource> withBlobIdByteSource() {
        return data -> SMono$.MODULE$.just((Object)Tuples.of((Object)$this.blobIdFactory.of(UUID.randomUUID().toString()), (Object)data));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readReactive(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.fromPublisher(this.blobStoreDAO.delete(bucketName, blobId)).then(SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.concat((Publisher[])new Publisher[]{this.blobStoreDAO.listBuckets(), Flux.just((Object)this.defaultBucketName)}).distinct();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.blobStoreDAO.listBlobs(bucketName);
    }

    @Inject
    public PassThroughBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
    }
}

